unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImagesScroll, ComCtrls, Buttons, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    ImageList1: TImageList;
    SmallImages: TImageList;
    GroupBox3: TGroupBox;
    TreeView1: TTreeView;
    ImagesScroll2: TImagesScroll;
    Label3: TLabel;
    Label4: TLabel;
    PopupMenu: TPopupMenu;
    Expand1: TMenuItem;
    Collapse1: TMenuItem;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    ImagesScroll1: TImagesScroll;
    procedure ImagesScroll2Selected(Sender: TObject;
      SelectedIndex: Integer);
    procedure TreeView1GetSelectedIndex(Sender: TObject; Node: TTreeNode);
    procedure Expand1Click(Sender: TObject);
    procedure Collapse1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ImagesScroll2Selected(Sender: TObject;
  SelectedIndex: Integer);
begin
  if TreeView1.Selected.ImageIndex <> 0 then
   begin
    Label3.Caption := 'Current ImageIndex: ' + IntToStr(SelectedIndex);
    TreeView1.Selected.ImageIndex := SelectedIndex;
    TreeView1.Selected.SelectedIndex := SelectedIndex;
    TreeView1.Repaint;
   end;
end;

procedure TForm1.TreeView1GetSelectedIndex(Sender: TObject;
  Node: TTreeNode);
begin
  if Node = TreeView1.Selected then
   ImagesScroll2.ImageIndex := Node.ImageIndex;
end;

procedure TForm1.Expand1Click(Sender: TObject);
begin
  TreeView1.FullExpand;
end;

procedure TForm1.Collapse1Click(Sender: TObject);
begin
  TreeView1.FullCollapse;
end;

end.
