unit UIGrid05;
{version 05 apr.98; Two components: TComboEdit and
 TInspGrid}
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

const
MaxColCount = 3;
WinOffSet = 2;

type
TCustomComboEdit = class;


TCustomInspLBox = class(TCustomListBox)
 private
 lEdit : TCustomComboEdit;
 procedure CMExit( Var Message : TCMExit );   message CM_EXIT;
    procedure CNkeydown(var Message: TWMkeydown); message CN_KEYDOWN;
 public
  { Public declarations }
 constructor Create(AOwner: TComponent); override;
 destructor Destroy; override;
 end;


{============== TCustomComboEdit }
  TButtonStyle = (btNone, btArrow, btEllipsis,btRectangle);


  TCustomComboEdit = class(TCustomEdit)
  private
    { Private declarations }
    fShowList    : boolean;
    fListBox     : TCustomInspLBox;
    fOldText     : TCaption;
    fButtonWidth : integer;
    fButtonStyle : TButtonStyle;
    fPressed : boolean;
    fTracking : boolean;
    fBtnRect : TRect;
    fOnButtonClick : TNotifyEvent;
    fCanvas : TCanvas;
    procedure StopTracking;
    procedure SetButtonStyle(Value: TButtonStyle);
    procedure TrackButton(X,Y: Integer);
    procedure ArrowDown(ARect : Trect; P :boolean);
    procedure Ellipsis(ARect : TRect; p :Boolean);
    procedure PatRectangle(ARect : TRect; p :Boolean);
    procedure WMPaint(var Message: TWMPaint); message wm_Paint;
    procedure WMSize(var Msg :TWMSize);message WM_Size;
    procedure  SetShowList(aValue : boolean);
    function GetItem(ind : integer) : String;
    procedure SetItem(ind : integer; aValue : string);
    procedure CreateListBox;
    procedure CloseListBox;
    procedure SetListBoxBounds;
    procedure FreeListBox;
    function GetItemIndex:integer;
    procedure SetItemIndex(aValue : integer);
    function GetItemsCount:integer;
  protected
    { Protected declarations }
    procedure BoundsChanged;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CNkeydown(var Message: TWMkeydown); message CN_KEYDOWN;
    procedure CMEnter( Var Message : TCMEnter );   message CM_ENTER;
    procedure CMExit( Var Message : TCMExit );   message CM_EXIT;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure PaintWindow(DC: HDC); override;
    procedure WndProc(var message : TMessage); override;
    procedure EditButtonClick;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Loaded; override;
    destructor Destroy; override;
    function ClearItems : boolean;
    function SetComboEditItems(aValue : string):boolean;
    procedure Insert(Index: Integer; const S: string);
    procedure Delete(Index: Integer);
    property ItemIndex : integer read GetItemIndex write SetItemIndex;
    property ItemsCount : integer read GetItemsCount;
    property Item[ind : integer]:String read GetItem write SetItem;
    property ButtonStyle: TButtonStyle read fButtonStyle write SetButtonStyle default btNone;
    property ShowList : boolean read fShowList write SetShowList default False;
    property OnButtonClick : TNotifyEvent read fOnButtonClick write fOnButtonClick;
  published
    { Published declarations }
  end;


TComboEdit = class(TCustomComboEdit)
 published
    { Published declarations }
    property AutoSelect;
    property AutoSize;
    property BorderStyle;
    property ButtonStyle;
    property CharCase;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property HideSelection;
    property MaxLength;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property ShowList;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnButtonClick;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
 end;

//==== TCustomInspGrid    =================

TDrawState = (ds_Flat,ds_Lowered);

TRowType = (ctViewer, ctShowFocus, ctShowEdit, ctCallDialog,
                                          ctCallList, ctEdit );


TBtnClickEvent  = procedure(Sender: TObject; ARow :word;
                     var m : TCaption)of object;


TCustomInspGrid = class(TScrollBox)
private
    { Private declarations }
fColWidth  : array[0..MaxColCount] of word;

fCol              : word;
fColCount         : byte; { maximum value 3 }
fDefaultColWidth  : word;
fDefaultRowHeight : word;
fRow              : word;
fRowCount         : word;
fRowType          : TRowType;
fEdit             : TComboEdit;
fOnChangeRow      : TNotifyEvent;
fModified         : boolean;
fEditRow          : integer;
fOnBtnClick       : TBtnClickEvent;
fVGrRect          : TRect;
fVisibleRowCount  : word;
fTopRow           : word;
 fDrLine  : boolean;
 xOld     : word;    {stores position of cursor for MoseMove }
 xCol     : word;    {stores Column where drawing was started }
 fCanvas  : TCanvas;
 fItems     : TStringList; {stores Cells content}
function GetGridRectangle : TRect;
function GetLeftCoordinate(Acol : byte):word;
procedure fSetLastColWidth;
procedure UpdateScrollRange;
procedure SetColCount(aValue: byte);
procedure SetDefaultColWidth(aValue: word);
function GetColWidth(index : byte):word;
procedure SetColWidth(index : byte; value : word);
procedure SetRowCount(aValue: word);
procedure SetDefaultRowHeight(aValue: word);
procedure SetRow(AValue : word);
procedure SetRowType(aValue : TRowType);
procedure ChangeRow(var aRow : word);
procedure DrawBevel(ARect : TRect;AState : TDrawState);
procedure DrawCellText(ACol, ARow : word;  ARect :TRect);
procedure DrawCell(ACol, ARow : word; AState : TDrawState);virtual;
procedure DrawRow(ARow : word);
procedure WMPaint(var Message : TWMPaint); message WM_Paint;
function InSertEditor(R : TRect; aRow : Word):word;
procedure DeActivateEditor( aRow : Word);
procedure Proc(const s : string); // used in function GetColorsList
{=============== TsrigList manager == redo}
procedure InitItemsList;
procedure SetCells(ACol,ARow:word; const AValue : string);
function GetCells(ACol,ARow:word) : string;
function InsertRowString(ARow,Num : integer):boolean;
function DeleteRowString(ARow,Num : integer): boolean;
function DeleteColString(ACol,Num : byte):boolean;
function InsertColString(ACol,Num : byte):boolean;
function GetObjects(ACol,ARow : word) : TObject;
procedure SetObjects(ACol,ARow : word; const AValue : TObject);
//=========================================================================
procedure MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer); override;
procedure MouseUp(Button:TMouseButton; Shift:TShiftState; X,Y:Integer); override;
procedure MouseMove(Shift: TShiftState; X, Y: Integer);override;
procedure WMkeydown(var Message: TWMkeydown);message WM_KEYDOWN;
procedure WMCommand(var M : TWMCommand);message WM_COMMAND;
procedure fEditBtnClick;
//=========================================================================
procedure WMGetDlgCode (var Message : TMessage); message WM_GETDLGCODE;
procedure WMSize(var Msg : TWMSize); message WM_Size;
  protected
    { Protected declarations }
procedure WndProc(var message : TMessage); override;
procedure PaintWindow(DC: HDC); override;
  public
    { Public declarations }
constructor Create(AOwner: TComponent); override;
procedure Loaded; override;
destructor Destroy; override;

procedure InsertRows(ARow,Num : integer); virtual;
procedure DeleteRows(ARow,Num : integer); virtual;
function CellRect(aCol,ARow : word):TRect;
procedure MouseToCell(X, Y: Integer; var ACol, ARow: word);
function SetComboEditItems(m : string): boolean;
// new functions for convertion and validation input
function StrToBoolean(aValue : string):boolean;
function BoolToStr(aValue : boolean):string;
function ValidateInteger(aRow : word; def : integer):integer;
function ValidateFloat(aRow : word; def : double):double;
function GetColorsList:boolean;

 property Modified : boolean read fModified write fModified default False;
 property ColWidth[Index : byte]:word read GetColWidth write SetColWidth;
 property VisibleRowCount : word read fVisibleRowCount;
 property Cells[ACol,ARow : word] : String read GetCells write SetCells;
 property Objects[ACol, ARow: word]: TObject read GetObjects write SetObjects;
 property Row : Word read fRow write SetRow default 0;
 property ColCount :byte read fColCount write SetColCount default 2;
 property DefaultColWidth  : word read fDefaultColWidth
                       write SetDefaultColWidth default 64;
 property DefaultRowHeight : word read fDefaultRowHeight
                        write setDefaultRowHeight  default 22;
 property RowCount : word read fRowCount write SetRowCount default 12;
 property RowType : TRowType read fRowType write SetRowType default ctShowFocus;
 property OnBtnClick : TBtnClickEvent read fOnBtnClick write fOnBtnClick;
 property OnChangeRow : TNotifyEvent read fOnChangeRow write fOnChangeRow;
 property TabStop default True;
  published
    { Published declarations }

  end;

TInspGrid = class(TCustomInspGrid)
published
 property ColCount; // new
 property DefaultColWidth; // new
 property DefaultRowHeight; // new
 property RowCount;          // new
 property Align;
 property DragCursor;
 property DragMode;
 property Enabled;
 property Font;
 property ParentFont;
 property ParentShowHint;
 property TabStop;
 property Visible;
 property OnBtnClick;         // new
 property OnDragDrop;
 property OnDragOver;
 property OnEndDrag;
 property OnEnter;
 property OnExit;
 property OnChangeRow;         // new
 property OnMouseDown;
 property OnMouseMove;
 property OnMouseUp;
 property OnStartDrag;
end;

procedure Register;

implementation
{$R UIGrid05.Res}

procedure Register;
begin
  RegisterComponents('Samples', [TComboEdit]);
  RegisterComponents('Samples', [TInspGrid]);
end;

{ ========================== TCustomInspLBox }
constructor TCustomInspLBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
   BorderStyle := bsNone;
//Ctl3D := False;
sorted := true;
Visible := False;
end;


destructor TCustomInspLBox.Destroy;
begin
 if Parent <> lEdit then Parent := lEdit;
  lEdit.FListbox := nil;
 inherited
end;

procedure TCustomInspLBox.CMExit( Var Message : TCMExit );
begin
 if not lEdit.Focused or (Message.Unused[0] = 1) then
     begin
    Parent := lEdit;
      Visible := False;
    end;
end;

procedure TCustomInspLBox.CNkeydown(var Message: TWMkeydown);
begin
if (Message.CharCode = VK_RETURN) and
       (ssCtrl In KeyDataToShiftState(Message.KeyData)) then
  begin

    lEdit.EditButtonClick
    end else
inherited;
end;
{=========================================================}
constructor TCustomComboEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fButtonWidth := GetSystemMetrics(SM_CXVSCROLL);
  fButtonStyle := btNone;
  fShowLIst := False;
  fListBox := nil;
  fCanvas := TControlCanvas.Create;
TControlCanvas(fCanvas).Control := Self;
end; // Create

destructor TCustomComboEdit.Destroy;
begin
if fListbox<> nil then fListBox.Free;
 fCanvas.Free;
  inherited Destroy;
end; // Destroy


procedure TCustomComboEdit.Loaded;
begin
inherited;
 if fShowList and not (csDesigning in Componentstate )  then CreateListBox;
end;

procedure TCustomComboEdit.WndProc(var message : TMessage);
begin
  if (Message.msg  = WM_MOVE) or
       (Message.msg  = CM_VISIBLECHANGED) then begin
 if (fListBox <> nil) and fListBox.Visible then begin
          PostMessage(fListBox.Handle,CM_Exit,1,0);
                                                 end;
                    end;

  inherited WndProc(message);
end;


procedure TCustomComboEdit.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
if fButtonStyle <> btNone then
  with Params do  begin
    Style := Style or ES_MULTILINE;
  end;
end;  // CreateParams

procedure TCustomComboEdit.BoundsChanged;
var
  R: TRect;
begin
SetRect(R, 0, 0, ClientWidth - 2, ClientHeight + 1); // +1 is workaround for windows paint bug
  if (fButtonStyle <> btNone)then begin
SetRect(fBtnRect, ClientWidth - fButtonWidth, 0, ClientWidth, ClientHeight);
          Dec(R.Right, fButtonWidth);
                                               end;
  SendMessage(Handle, EM_SETRECT, 0, LongInt(@R));
  Repaint;
end; // BoundsChanged

procedure TCustomComboEdit.CreateListBox;
begin
if (fListBox = nil) then begin
 fListBox := TCustomInspLBox.Create(TCustomComboEdit(Owner));
with  fListBox do begin
 lEdit := Self;
  Parent := Self;
    lEdit.ReadOnly := True;
                  end;
      fShowList := True;
                       end
end;

procedure TCustomComboEdit.FreeListBox;
begin
   fListBox.Free;
      fListBox := nil;
        ReadOnly := False;
    fShowList := False;
end;

procedure TCustomComboEdit.SetShowList(aValue : boolean);
begin
if fShowList <>  aValue then  begin
  fShowList := aValue;
if not fShowList and (fListBox <> nil) then FreeListBox;
if fShowList and (fButtonStyle = btArrow) and
    not (csDesigning in Componentstate ) then CreateListBox;
  end;
end;

procedure TCustomComboEdit.SetButtonStyle(Value: TButtonStyle);
var oldValue: TButtonStyle;
begin
if Value = fButtonStyle then Exit;
 oldValue:= fButtonStyle;
  fButtonStyle := Value;
if (oldValue = btArrow) and fShowList then FreeListBox;
if (fButtonStyle = btArrow) and fShowList and
    not (csDesigning in Componentstate ) then CreateListBox;

if ((Ord(OldValue) = 0) and (Ord(fButtonStyle) > 0))
     or ((Ord(OldValue) > 0) and (Ord(fButtonStyle) = 0))
  then  RecreateWnd;
         BoundsChanged;
end; // SetLinkStyle


procedure TCustomComboEdit.SetListBoxBounds;
var R     : Trect; {item rectangle of fListBox}
  setTxt : boolean;
  ItHgt,  {item height}
  mWidth, {maximum Length(Strings[i])  }
  mHgt,    {height of fListBox }
    Yl,     {Top of fListBox}
    Xl,      {Left Coordinate of fListbox}
    W   : word;
    i   : byte;

begin
//if fListBox = nil then CreateListBox;
 if fListBox <> nil then with fListBox do begin
  Parent := TCustomComboEdit(Owner);
   setTxt := true;
     mHgt := ItemHeight;   // initial fListBox.height
   mWidth := lEdit.Width;  //initial fListBox.Width
 if (Items.Count>0) then       begin
 Perform(LB_GETITEMRECT,0,LongInt(@R)); // measure item height
  itHgt := (R.Bottom - R.Top);          // itemheight
   w := Items.Count;
    if w > 4 then w := 4;                 // 4 is maximum visible items
 mHgt := itHgt * w;
  for i := 0 to Items.Count-1 do  begin
     w := fCanvas.TextWidth(Items[i]);
  if  w > mWidth  then mWidth := w;
  if mWidth > longint(Parent.width) then
                   mWidth := longint(Parent.width-4);
// check edit text
if setTxt then setTxt := (lEdit.text <> Items[i]);
if not Settxt then fListBox.ItemIndex := i;
                                    end;
if setTxt then lEdit.text := Items[0]   // set edit text;
                                    end;
// find the direction of listbox and start point
    yl := LEdit.Top + LEdit.Height + 2;     // 2 is offset from Edit;
   xl := LEdit.Left; // goRight
if lEdit.Parent <> lEdit.Owner then begin
 xl := xl + lEdit.Parent.Left + 2;
 yl := yl + lEdit.Parent.Top;
                                     end;
if (longint(Parent.ClientHeight) < yl + mhgt) then  // goUP
                  yl := yl - (lEdit.height + mhgt + 2);

if (xl + mWidth > Parent.ClientWidth) then // goLeft
                  xl := xl + LEdit.Width - mWidth;

  SetBounds(xl, yl, mWidth,mHgt);
 Visible := true;
  SetFocus;
  end; // <> nil
end;

procedure TCustomComboEdit.CloseListBox;
begin
 if fListBox.ItemIndex >= 0 then
    Self.Text := fListBox.Items[fListBox.ItemIndex];
        fListBox.Visible := False;
           fListBox.Parent := Self;
     SetFocus;
end;


function TCustomComboEdit.ClearItems : boolean;
begin
if fListBox <> nil then  begin
Text := '';
   with fListBox do Items.Clear; Result := True;
                          end else Result := False;
end;

function TCustomComboEdit.SetComboEditItems(aValue : string):boolean;
begin
 if fListBox <> nil then  begin
 Text := '';
   with fListBox do Items.CommaText := aValue; Result := True;
                          end else Result := False;
end;

function TCustomComboEdit.GetItem(ind : integer) : String;
begin
if fListBox <> nil then
  with fListBox do
     if (ind >= 0) and (ind < Items.Count) then Result := Items[ind];
end;


procedure TCustomComboEdit.SetItem(ind : integer; aValue : string);
begin
if fListBox <> nil then
 with fListBox do begin
  if ind < Items.Count then Items[ind]:= aValue
    else Items.Add(aValue);
                  end;
end;

function TCustomComboEdit.GetItemIndex:integer;
begin
if fListBox <> nil then
Result := fListBox.ItemIndex;
end;

procedure TCustomComboEdit.SetItemIndex(aValue : integer);
begin
 if fListBox <> nil then
    if (aValue <> fListBox.ItemIndex) and (aValue < fListBox.Items.Count)
     then fListBox.ItemIndex := aValue;

end;

function TCustomComboEdit.GetItemsCount:integer;
begin
if fListBox <> nil then
     Result := fListBox.Items.Count
   else Result := -1;
end;



procedure TCustomComboEdit.Insert(Index: Integer; const S: string);
begin
 if (fListBox <> nil) and
   (index < fListBox.Items.Count)
       then fListBox.Items.Insert(index,s);
end;

procedure TCustomComboEdit.Delete(Index: Integer);
begin
 if (fListBox <> nil)
    and (index < fListBox.Items.Count)
       then fListBox.Items.Delete(index);
end;

procedure TCustomComboEdit.EditButtonClick;
var postMsg : boolean;
begin
postMsg := True;
 if fShowList then
   if fListBox.Visible then begin
       CloseListBox; postMsg := True end
                 else begin SetListBoxBounds; postMsg := False end;
 if postMsg and Assigned(fOnButtonClick) then fOnButtonClick(Self);
if HasParent and postMsg then
PostMessage(Parent.Handle,WM_COMMAND,BN_CLICKED,0);
end; // EditButtonClick

procedure TCustomComboEdit.WMPaint(var Message: TWMPaint);
begin
  PaintHandler(Message)
end; // WMPaint

procedure TCustomComboEdit.CNkeydown(var Message: TWMkeydown);
var
  Msg        : TMsg;
  fKeyAction : integer;
begin
   Case Message.CharCode of
VK_RETURN :
 if  (fButtonStyle <> btNone)
   and (ssCtrl In KeyDataToShiftState(Message.KeyData)) then
  begin
    EditButtonClick;
    PeekMessage(msg, Handle, WM_CHAR, WM_CHAR, PM_REMOVE);
  end  else fKeyAction := VK_DOWN;
VK_DOWN   : fKeyAction := VK_DOWN;

VK_UP     : fKeyAction := VK_UP;
VK_ESCAPE : begin Text := fOldText; fKeyAction := VK_ESCAPE; end;
 else inherited;
  end;
  if HasParent then PostMessage(Parent.Handle,WM_KEYDOWN,fKeyAction,0 )
end;


procedure TCustomComboEdit.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
var
  WasPressed: Boolean;
begin
 WasPressed := fPressed;
  StopTracking;
  if (Button = mbLeft) and (fButtonStyle <> btNone) and WasPressed then
    EditButtonClick;
  inherited MouseUp(Button, Shift, X, Y);
end;

procedure TCustomComboEdit.ArrowDown(ARect : Trect; P :boolean);
var m1,m3,v1 : word;
    OldColor : TColor;
begin
OldColor :=  fCanvas.Brush.Color;
 if p then fCanvas.Brush.Color := clGray else
             fCanvas.Brush.Color := clBlack;
with ARect do begin
m1  := Left + ((Right - Left) shr 1);
m3 :=  ((Right - Left) shr 2);
v1 :=  (Top + (Bottom - Top) shr 1) +  Ord(p);
 fCanvas.Polygon([Point( m1 - m3, v1 - m3), Point(m1 + m3, v1 - m3),
    Point(m1, v1 + m3)]);
end;
  fCanvas.Brush.Color := OldColor;
end;

procedure TCustomComboEdit.Ellipsis(ARect : TRect; p :Boolean);
var c,w,fl : integer;
begin
with ARect do begin
c :=  ((Right - Left) shr 1) - 1 + Ord(p);
w :=  (Right - Left) shr 3;
fl := ((Bottom - Top) shr 1) - 1 + Ord(p);
   if w = 0  then w := 1;
PatBlt(fCanvas.Handle,Left + c,Top + fl,w,w,BLACKNESS);
PatBlt(fCanvas.Handle,Left + c -w *2,Top + fl,w,w,BLACKNESS);
PatBlt(fCanvas.Handle,Left + c+W*2,Top + fl,w,w,BLACKNESS);
 end;
end;

procedure TCustomComboEdit.PatRectangle(ARect : TRect; p :Boolean);
 var pR : TRect;
     w : integer;
begin
 pR :=  ARect;
  InflateRect(pR,-4+ Ord(p),-4+ Ord(p));
 w := pR.Right-pR.Left;
with pR do
PatBlt(fCanvas.Handle,Left,Top,w,w,BLACKNESS);
end;



procedure TCustomComboEdit.WMSize(var Msg :TWMSize);
begin
   inherited;
 BoundsChanged;
end;


procedure TCustomComboEdit.PaintWindow(DC: HDC);
var
  Flags: Integer;
begin
 if (fButtonStyle <> btNone) then begin
   Flags := 0;
if FPressed then Flags := BF_FLAT;
  DrawEdge(DC, fBtnRect, EDGE_RAISED, BF_RECT or BF_MIDDLE or Flags);
Case Ord(fButtonStyle) of
  1 : ArrowDown(fBtnRect,fPressed);
  2 : Ellipsis(fBtnRect,fPressed);
  3 : PatRectangle(fBtnRect,fPressed);
 end;
  with fBtnRect do ExcludeClipRect(DC, Left, Top, Right, Bottom);
                                    end;
Text := Trim(Text);
  inherited PaintWindow(DC);
end; // PaintWindow

procedure TCustomComboEdit.StopTracking;
begin
if FTracking then
  begin
    TrackButton(-1, -1);
    FTracking := False;
    MouseCapture := False;
  end;
end; // StopTracking;


procedure TCustomComboEdit.TrackButton(X,Y: Integer);
var
  NewState: Boolean;
begin
 NewState := PtInRect(fBtnRect, Point(X, Y));
  if fPressed <> NewState then
  begin
    fPressed := NewState;
    InvalidateRect(Handle, @fBtnRect, False);
  end;
end; // TrackButton


procedure TCustomComboEdit.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
 if (Button = mbLeft) and (fButtonStyle <> btNone) and Focused
  and PtInRect(fBtnRect, Point(X,Y)) then
    begin
    MouseCapture := True;
    FTracking := True;
    TrackButton(X, Y);
    end;
  inherited MouseDown(Button, Shift, X, Y);
end; // MouseDown

procedure TCustomComboEdit.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
if (fButtonStyle <> btNone)
  and PtInRect(fBtnRect,Point(X,Y)) then  Screen.Cursor:= crArrow else
       Screen.Cursor:= crDefault;
  if fTracking then
    TrackButton(X, Y);
  inherited MouseMove(Shift, X, Y);
end; // MouseMove


procedure TCustomComboEdit.CMExit( Var Message : TCMExit );
begin
if fOldText <> Text then
  Modified := True else Modified := False;
if not fShowList and HasParent then Parent.SetFocus;
 if fShowList and not fListBox.Focused then begin
 PostMessage(fListBox.Handle,CM_Exit,0,0);
  if HasParent then begin
           Parent.SetFocus;
                        end;
        end;
  inherited;
end;

procedure TCustomComboEdit.CMEnter( Var Message : TCMEnter );
begin
inherited;
Modified := False;
 fOldText := Text;    {stores Text }
end;



{=================== TCustomInspGrid }
function TCustomInspGrid.BoolToStr(aValue : boolean):string;
begin
if aValue then Result := 'True'
 else Result := 'False';
end;


function TCustomInspGrid.StrToBoolean(aValue : string):boolean;
begin
if aValue = 'True' then Result := True
 else Result := False;
end;

function TCustomInspGrid.ValidateInteger(aRow : word; def : integer):integer;
// converts string of cells[1,aRow] to integer value
begin
try
  Result := StrToInt(fItems.Strings[fColCount * ARow + 1]);
except
 on EConvertError do begin
     MessageBeep(MB_OK);{ MB_ICONASTERISK}
  MessageDlg('Unable to convert the specified string to a valid integer ', mtError, [mbCancel], 0);
    Result := def;
  fItems.Strings[fColCount * ARow + 1] := IntToStr(def);
    fRow := aRow;
     Refresh;
                 end;
  end;
 end;

function TCustomInspGrid.ValidateFloat(aRow : word; def : double):double;
// converts string of cells[1,aRow] to float value
begin
try
 Result := StrToFloat(fItems.Strings[fColCount * ARow + 1]);
except
 on EConvertError do begin
 MessageBeep(MB_ICONASTERISK);
  MessageDlg('Unable to convert the specified string to a valid floating point value. ',
              mtError, [mbCancel], 0);
     Result := def;
 fItems.Strings[fColCount * ARow + 1] := FloatToStr(def);
    fRow := aRow;
     Refresh;
                 end;
  end;
 end;

procedure TCustomInspGrid.Proc(const s : string);
begin
 with fEdit do
      Item[ItemsCount] := s;
end;

function TCustomInspGrid.GetColorsList:boolean;
begin
Result := False;
if (fEdit <> nil) and (fRowType = ctCallList) then
 with fEdit do begin
  ClearItems;
    GetColorValues(Proc);
         Result := True;
               end;

end;
//==================================================

procedure TCustomInspGrid.UpdateScrollRange;
// define position, and range for scrollBar
var h : word;
begin
with VertScrollBar do begin
 Increment := fDefaultRowHeight;
  Position := 0;
   fTopRow := 0;
  h := ClientRect.Bottom - Clientrect.Top;
   Range := h+(fRowCount - fVisibleRowCount)*fDefaultRowHeight;
                      end;
end;


function TCustomInspGrid.GetGridRectangle : TRect;
// addjust the height of component and compute gridrectangle
begin
 fVisibleRowCount := ClientHeight div fDefaultRowHeight;
  if fVisibleRowCount > fRowCount then
                   fVisibleRowCount := fRowCount;
Height := fVisibleRowCount * fDefaultRowHeight + 4;
  Result := ClientRect;
  UpdateScrollRange;
 if (fEdit <> nil) and (fRow = fEditRow)  then begin
    fEdit.Width := fColWidth[1]; // assumed that edit on;ly in col[1]
        fEdit.Left := GetLeftCoordinate(1);
                                                end;
end;

function TCustomInspGrid.GetLeftCoordinate(aCol : byte):word;
var i : word;
begin
 Result := 0;
if aCol > 0 then
 for i := 0 to ACol - 1 do
  Result := Result + fColWidth[i];
end;


procedure TCustomInspGrid.fSetLastColWidth;
var  wdth  : word;
     lc    : word;
begin
wdth :=  ClientWidth;
lc :=  GetLeftCoordinate(fColCount - 1);
if lc <  wdth then
  fColWidth[ ColCount - 1 ] := wdth - lc - 2
          else  fColWidth[ fColCount - 1 ] := 0;
end;


procedure TCustomInspGrid.SetDefaultColWidth(aValue: word);
var i : word;
 begin
if fDefaultColWidth <> aValue then begin
 fDefaultColWidth := aValue;
   for i := 0 to ColCount -2 do
    fColWidth[i] := fDefaultColWidth;
       fSetLastColWidth;
  Invalidate;
 end;
end;


function TCustomInspGrid.GetColWidth(index : byte):word;
begin
if index < fColCount-1 then
   Result := fColWidth[index] else
MessageDlg('Index out of bounds', mtError, [mbCancel], 0);
end;


procedure TCustomInspGrid.SetColWidth(index : byte; value : word);
begin
if index > fColCount-1 then
 MessageDlg('Index out of bounds', mtError, [mbCancel], 0)
 else
if fColWidth[index] <> value   then  begin
  fColWidth[index] := value;
    fSetLastColWidth;
      Repaint;
                                      end
 end;



{============================================================================}

procedure TCustomInspGrid.WndProc(var message : TMessage);
var aTop : word;
begin
case  Message.msg of
 WM_VScroll :
    begin
    aTop := GetScrollPos(Handle,SB_VERT) div fDefaultRowHeight;
    if aTop <> fTopRow then begin
     fTopRow := aTop;
     Invalidate;
                            end;
      end;
 CM_MOUSELEAVE :  Screen.Cursor:= crDefault;
  end;
  inherited WndProc(message);
end;

procedure TCustomInspGrid.SetColCount(aValue : byte);
var i : byte;
  num : byte;
begin
if (aValue <= MaxColCount) and
   (fColCount <> aValue) then begin
 if fColCount < aValue then
     InsertColString(fColCount, aValue - fColCount);
 if fColCount > aValue then
     DeleteColString(AValue, fColCount - aValue);
 for i := 0 to fColCount -2 do
    fColWidth[i] := fDefaultColWidth;
  fSetLastColWidth;
if (fEdit <> nil) and (fRow = fEditRow)  then begin
    fEdit.Width := fColWidth[1];
        fEdit.Left := GetLeftCoordinate(1);
                                               end;
 Invalidate;
 end;
end;

procedure TCustomInspGrid.SetDefaultRowHeight(aValue: word);
begin
  if (fDefaultRowHeight <> aValue) then
 begin
 fDefaultRowHeight := aValue;
  fVGrRect := GetGridRectangle;
   Invalidate;
 end;
end;

procedure TCustomInspGrid.SetRowCount(aValue: word);
begin
if fRowCount <> aValue then
 begin
if fRowCount < aValue then
  InsertRowString(fRowCount,aValue-fRowCount);
if fRowCount > aValue then
  DeleteRowString(aValue,fRowCount-aValue);
 fVGrRect := GetGridRectangle;
Repaint
 end;
end;


procedure TCustomInspGrid.SetRow(AValue : word);
begin
if fRow <> aValue then
begin
   fRow := aValue;
 Refresh;
 end;
end;


procedure TCustomInspGrid.SetRowType(aValue : TRowType);
begin
 if fRowType <> AValue then  begin
        fRowType := AValue;
if Ord(fRowType) > 1 then begin
  if HandleAllocated and (fEdit = nil) then begin
    fEdit := TComboEdit.Create(TCustomInspGrid(Owner));
                   InsertControl(fEdit);
                                             end;
with  fEdit do begin
Color := clWindow;
BorderStyle := bsSingle;
Visible := False;
 ReadOnly := True;
    ShowList := False;
  Case fRowType of
ctShowEdit   : ButtonStyle := btNone;
ctCallDialog : ButtonStyle := btEllipsis;
ctCallList   : begin ButtonStyle := btArrow; ShowList := True; end;
ctEdit       : begin ButtonStyle := btNone; ReadOnly := False; end;
  end  // case of
      end // with fEdit
         end  // Ord(fRowType) > 1
              end // fRowType <> AValue
end;


procedure TCustomInspGrid.ChangeRow(var aRow : word);
begin
if (aRow = fRow) and (fRow <>  fEditRow) then begin
   if (fEditRow > -1) then  DeActivateEditor(fEditRow);
       if Assigned(fOnChangeRow) then  fOnChangeRow(Self);
if (fRowType > ctShowFocus) then
           fEditRow  := InSertEditor(CellRect(1,fRow),aRow);
                                                 end;
end;



procedure TCustomInspGrid.DrawBevel(ARect : TRect; AState : TDrawState);
begin
 with ARect,fCanvas do
 begin
 Pen.Style:= psInsideFrame;
if AState = ds_Flat then begin
 Pen.Color := clBtnShadow;
    PolyLine([ Point(Left, Bottom),Point(Right-1, Bottom),Point(Right-1, Top)]);
   Pen.Color := clBtnHighlight;
   if Left > 0 then
      PolyLine([ Point(Left, Bottom),Point(left, Top)]);
                         end;
if AState = ds_Lowered then begin
  Pen.Color := clBlack;
  if Left = 0  then
   PolyLine([Point(Left,Bottom), Point(Left, Top),Point(Right, Top)])
       else  PolyLine([Point(Left, Top),Point(Right, Top)]);
   Pen.Color := clBtnHighlight;
      PolyLine([ Point(Left, Bottom-1),Point(Right, Bottom-1),Point(Right,Top)]);
                           end;
 end;
end;


procedure TCustomInspGrid.DrawCellText(ACol, ARow : Word;  ARect :TRect);
var
 clText     : array[0..79] of Char;
 m          : string[79];
 FHeight    : Integer;
  begin
with fCanvas do begin
Brush.Color := Color;
 if (ARow = fRow) then  Font.Color  := clWindowText
      else   Font.Color  := clGrayText;
 InflateRect(ARect,-1,-1);
   FillRect(ARect);
     FHeight := TextHeight('W');
  with aRect do begin
   Top := ((Bottom + Top) - FHeight) shr 1;
   Bottom := Top + FHeight;
   Inc(Left,2);
            end;
m := fItems.Strings[fColCount * ARow + ACol];
  StrPlCopy(clText,m,Length(m));
    DrawText(Handle, clText, StrLen(clText), aRect, (DT_EXPANDTABS or
       DT_VCENTER or DT_Left));
  end; {with fCanvas}
end;

procedure  TCustomInspGrid.DrawCell(ACol, ARow : word; AState : TDrawState);
var ARect : TRect;
   Omit : boolean;
begin
   Omit := False;
    aRect := CellRect(ACol,ARow);

if (ACol = 1) and (aRow = fEditRow) then Omit := True;
 if not Omit then begin
      DrawBevel(ARect,AState);
 DrawCellText(ACol, ARow, ARect);
                    end;
end;

procedure  TCustomInspGrid.DrawRow(ARow : word);
var     i : byte;
   AState : TDrawState;
begin
if (ARow >= fTopRow) and (ARow <= fTopRow + fVisibleRowCount-1)
 then begin
 if (fRowType <> ctViewer) and
   (ARow = fRow) then  AState :=  ds_Lowered else  AState :=  ds_Flat;
 for i:= 0 to fColCount - 1 do DrawCell( i, ARow, AState );
  end;
end;

procedure TCustomInspGrid.WMPaint(var Message : TWMPaint);
begin
  PaintHandler(Message);
end;

procedure TCustomInspGrid.PaintWindow(DC: HDC);
 var i : byte;
begin
for i := fTopRow to fTopRow + fVisibleRowCount do
      DrawRow(i);
  inherited PaintWindow(DC);
end; // PaintWindow


function TCustomInspGrid.InSertEditor(r :TRect;aRow : Word):word;
begin
    InflateRect(R,0,-1);
if fEdit.HandleAllocated then
  with R do fEdit.SetBounds(Left,Top,Right - Left,Bottom - Top);
with fEdit do begin
 Visible := True;
   Text := fItems.Strings[1 + ARow  * fColCount];
    fModified := False;
      SetFocus;
                end;
   Result := ARow;
end;

function TCustomInspGrid.SetComboEditItems(m : string): boolean;
begin
Result := False;
if (fEdit <> nil) and (fRowType = ctCallList) then
 with fEdit do begin
  ClearItems;
       SetComboEditItems(m);
        Result := True;
               end;
end;

procedure TCustomInspGrid.DeActivateEditor( aRow : Word);
begin
if fEdit <> nil then begin
  fEdit.Visible := False;
   fEditRow :=-1; {out from RowCount}
if fItems.Strings[1 + ARow  * fColCount] <> fEdit.Text then begin
 fItems.Strings[1 + ARow  * fColCount] := fEdit.Text;
   fModified := True;
  DrawCell( 1, ARow, ds_Flat );
                     end;
   end;
end;


{=============== TsrigList manager }
procedure TCustomInspGrid.InitItemsList;
var i : longint;
begin
 for i := 0 to fRowCount * fColCount-1 do fItems.Add('');
end;

function TCustomInspGrid.GetCells(ACol,ARow:word) : string;
begin
 if (ACol < fColCount) and (ARow < fRowCount) then
    Result := fItems.Strings[fColCount * ARow + ACol];
end;


procedure TCustomInspGrid.SetCells(ACol,ARow:word; const AValue : string);
begin
  if (ACol < fColCount) and (ARow < fRowCount) then
   begin
      fItems.Strings[ACol + ARow  * fColCount] := AValue;
    DrawRow(ARow);
   end;
end;

function TCustomInspGrid.InsertRowString(ARow,Num : integer):boolean;
var i   : byte;
begin
if aRow <= fRowCount then begin
 for i := 0 to fColCount*num -1 do
   fItems.Insert(ARow * fColCount + i,'');
              Inc(fRowCount,num);
    Result := True;
     end else Result := False;
 end;

function TCustomInspGrid.DeleteRowString(ARow,Num : integer): boolean;
var c : byte;
begin
if ARow + num < fRowCount then begin
  for c := 0 to fColCount *num -1 do
      fItems.Delete(ARow * fColCount);
           Dec(fRowCount,num);
       Result := True;
                  end else Result := False;
end;

function TCustomInspGrid.InsertColString(ACol,Num : byte):boolean;
var r,c : byte;
begin
 if aCol <= fColCount then begin
for r := 1 to fRowCount do
 for c:= 1 to num do
  fItems.Insert(fColCount*(fRowCount-r)+ACol,'');
     Inc(fColCount,num);
                Result := True;
                       end else Result := False;

 end;

function TCustomInspGrid.DeleteColString(ACol,Num : byte):boolean;
var r,c : byte;
 begin
 if ACol + Num <= fColCount then begin
for r := 1 to fRowCount do
 for c:= 1 to num do
  fItems.Delete(fColCount*(fRowCount-r)+ACol);
     Dec(fColCount,num);
                Result := True;
                       end else Result := False;
 end;


function TCustomInspGrid.GetObjects(ACol,ARow : word) : TObject;
begin
   Result := fItems.Objects[fColCount * ARow + ACol]
end;

procedure TCustomInspGrid.SetObjects(ACol,ARow : word; const AValue : TObject);
begin
if AValue <> nil
then fItems.Objects[fColCount * ARow + ACol] := AValue;
end;



procedure TCustomInspGrid.InsertRows(ARow,Num : integer);
begin
  InsertRowString(ARow,Num);
    fVGrRect := GetGridRectangle;
      Invalidate;
end;

procedure TCustomInspGrid.DeleteRows(ARow,Num : integer);
begin
  DeleteRowString(ARow,Num);
    fVGrRect := GetGridRectangle;
      Invalidate;
end;


{===================================================================}

procedure TCustomInspGrid.MouseToCell(X, Y: Integer; var ACol, ARow: word);
var i : byte;
    w : word;
begin
ARow := Y div fDefaultRowHeight + fTopRow;
  i := 0;
   w := 0;
  while  W < X  do begin
   W := W + fColWidth[i];
            Inc(i)
                   end;
ACol := i-1;
end;

procedure TCustomInspGrid.MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
var dRow : word;
begin
if (Button = mbLeft)  then
 if (Screen.Cursor = crHSplit) then
  begin
   XOld := X;
     fCanvas.MoveTo(xOld,0);
     fCanvas.LineTo(xOld,ClientHeight);
  end else
   begin
  dRow := fRow;
   { new fRow  } MouseToCell(X, Y,fCol,fRow);
if (dRow <> fRow) or (fEdit = nil) then
 ChangeRow( fRow );
      Invalidate;
  end;
   inherited;
end;

procedure TCustomInspGrid.MouseUp(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
begin
if fDrLine then begin
fColWidth[xCol] := X - CellRect(xCol,1).Left;
  fDrLine := False;
       Screen.Cursor:= crDefault;
              fSetLastColWidth;
if (fEdit <> nil) and (fRow = fEditRow)  then begin
         fEdit.Width := fColWidth[1]; // assumed that edit on;ly in col[1]
         fEdit.Left := GetLeftCoordinate(1);
         end;
               Invalidate;
  end;
 inherited;
 end;

procedure TCustomInspGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var mRow  : word;
   cRect  : TRect;
begin
if PtInRect(ClientRect, Point(X, Y))and not fDRLine then
begin
 MouseToCell(X,Y,xCol,mRow);
      CRect := CellRect(xCol,mRow);
if ((X + 5 >= CRect.Right) or
 ((X - 5 <= CRect.Left)) and (xCol < ColCount-1)
  and (xCol > 0)) and (X + 5 < ClientRect.Right) then
 begin
  Screen.Cursor:= crHSplit;
  if (Shift = [ssLeft]) then
        begin
        fDrLine := True;
   if (X-5 <= CRect.Left) then Dec(xCol);
         end;
       end   else Screen.Cursor:= crDefault;
end; {ClientRect}
  if not PtInRect(ClientRect, Point(X, Y)) then Screen.Cursor:= crDefault;
if fDrLine then
 with fCanvas do begin
 Screen.Cursor:= crIBeam;
    Pen.Mode := pmNotXor;
       Pen.Color := clBtnShadow;
         MoveTo(xOld,0);
       LineTo(xOld,ClientHeight);
     MoveTo(x,0);
  LineTo(x,ClientHeight);
Pen.Mode := pmCopy;
                   end;
Xold := x;
   inherited;
end;

procedure TCustomInspGrid.WMkeydown(var Message: TWMkeydown);
var
  key     : word;
  oldfRow : word;
begin
Key := Message.CharCode;
oldfRow := fRow;
case Key of
 VK_DOWN  : if (fRow < RowCount-1) then
    begin
      Inc(fRow);
   if fRow >= fTopRow + fVisibleRowCount then  begin
     Inc(fTopRow);  {and do scroll}
      SetScrollPos(Handle,SB_VERT,fTopRow*fDefaultRowHeight,True) ;
                                             end;
      end;
VK_UP : if fRow > 0 then
begin
 Dec(fRow);
   if FRow < fTopRow then begin
    Dec(fTopRow);
        SetScrollPos(Handle,SB_VERT,fTopRow*fDefaultRowHeight,True) ;
   end;
 end;
  else
    inherited;
    end;  {Case of}
if fRow <> oldfRow then begin
    ChangeRow( fRow);
if Assigned(OnClick) then OnClick(Self);
      Invalidate;
                       end;
end;

procedure TCustomInspGrid.WMCommand(var M : TWMCommand);
begin
   if M.NotifyCode = BN_CLICKED then fEditBtnClick;
end;

procedure TCustomInspGrid.fEditBtnClick;
var m : TCaption;
begin
if not fEdit.ShowList then begin
 if Assigned(fOnBtnClick) then fOnBtnClick(Self,fRow,m);
    fEdit.Text := m;
    end;
end;

procedure TCustomInspGrid.WMGetDlgCode (var Message : TMessage);
begin
   Message.result :=  DLGC_WANTARROWS;
end;



function TCustomInspGrid.CellRect(aCol,ARow : word):TRect;
var     ALeft, ATop : word;
begin
if (aCol < fColCount) and (ARow >= fTopRow)
       and (ARow <= fTopRow + fVisibleRowCount-1) then begin
ALeft := GetLeftCoordinate(Acol);
  ATop := (ARow - FTopRow) * fDefaultRowHeight;
Result :=  Bounds(ALeft, ATop, fColWidth[ACol], fDefaultRowHeight);
      end;
end;



procedure TCustomInspGrid.WMSize(var Msg :TWMSize);
begin
 inherited;
  fVGrRect := GetGridRectangle;
           fSetLastColWidth;
end;


constructor TCustomInspGrid.Create(AOwner: TComponent);
var i : byte;
begin
  inherited Create(AOwner);
//Color:= clBtnFace;
fColCount := 2;
fDefaultColWidth := 64;
 for i := 0 to fColCount - 1 do fColWidth[i] := fDefaultColWidth;
fRowCount := 12;
fDefaultRowHeight := 22;
fTopRow := 0;
fRow := 0;
fDrLine  := false;
fRowType := ctViewer;
 fEditRow := -1;
 fModified := False;
    fEdit := nil;
 fCanvas := TControlCanvas.Create;
TControlCanvas(fCanvas).Control := Self;

 fItems := TStringList.Create;
         InitItemsList;
end; // Create


procedure TCustomInspGrid.Loaded;
var i : byte;
begin
 inherited Loaded;
  fVGrRect := GetGridRectangle;
     fSetLastColWidth;
end;


destructor TCustomInspGrid.Destroy;
begin
 FItems.Clear;
  FItems.Free;
   FCanvas.Free;
  if fEdit <> nil then fEdit.Free;
 inherited Destroy;
end;

end.


