unit UDemo;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,UIGrid05;

type
  TForm1 = class(TForm)
    InsRows: TButton;
    DelRows: TButton;
    SetColCount: TButton;
    SetRows: TButton;
    OpenDialog1: TOpenDialog;
    Edit1: TEdit;
    Label1: TLabel;
    procedure SetColCountClick(Sender: TObject);
    procedure InsRowsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DelRowsClick(Sender: TObject);
    procedure SetRowsClick(Sender: TObject);
    procedure InspGrid1ChangeRow(Sender: TObject);
    procedure InspGrid1BtnClick(Sender: TObject; ARow: Word;
      var m: TCaption);
  private
    { Private declarations }
    InspGrid1: TInspGrid;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
Type

 TRowArray = array[0..5] of string;
const
 RowsArray :  TRowArray = ('ctViewer', 'ctShowFocus', 'ctShowEdit',
                           'ctCallDialog','ctCallList', 'ctEdit');



procedure TForm1.FormCreate(Sender: TObject);
var c,r : word;
m : string;
begin
    InspGrid1:= TInspGrid.Create(Form1);
with InspGrid1 do  begin
Parent := Self;
 Left := 2;
 Top := 50;
 Height := 160;
OnChangeRow := InspGrid1ChangeRow;
 OnBtnClick := InspGrid1BtnClick;
 for c := 0 to ColCount-1 do
  for r := 0 to RowCount-1 do begin
     FmtStr(m,'%d %d',[c,r] );
         Cells[c,r] := m;
  end;
end;
end;



procedure TForm1.SetColCountClick(Sender: TObject);
begin
with InspGrid1 do begin
 if  ColCount = 2 then ColCount := 3 else
  ColCount := 2;
  end;
end;


procedure TForm1.InsRowsClick(Sender: TObject);
begin
//This procedure inserts two rows : 5 and 6
with InspGrid1 do begin
       InsertRows(5,2);
   Cells[0,5] := 'new row';
         Cells[0,6] := 'new row';
      end;
 end;


procedure TForm1.DelRowsClick(Sender: TObject);
begin
 InspGrid1.DeleteRows(5,2);
end;

procedure TForm1.SetRowsClick(Sender: TObject);
begin
with InspGrid1 do begin
 if  RowCount = 12 then RowCount := 22 else
  RowCount := 12;
  end;
 end;

procedure TForm1.InspGrid1ChangeRow(Sender: TObject);
begin
if (sender is TInspGrid) then
 with InspGrid1 do
  Case Row of
0 : RowType := ctShowEdit;
1 : RowType := ctViewer;
2 : RowType := ctShowFocus;
3 : RowType := ctCallDialog;
4:  begin RowType := ctCallList; SetComboEditItems('True,False');end;
5:  RowType := ctEdit;
  else RowType :=  ctShowFocus;
end;
Edit1.text := RowsArray[Ord( InspGrid1.RowType)]
end;

procedure TForm1.InspGrid1BtnClick(Sender: TObject; ARow: Word;
  var m: TCaption);
begin
with inspGrid1 do
if (ARow = 3) and OpenDialog1.Execute then
    m := OpenDialog1.FileName;
end;

end.
