unit ICQConnection;
{$OPTIMIZATION OFF}
//Version: 1.2
//Author : SM SOFT
//e-mail : sm_soft@mail.ru
//webpage: www.crosswinds.net/~icqcon

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;
Const
 ICQ_inet_DLL_Name='icqinet.dll';
 ICQ_corp_DLL_Name='icqcorp.dll';

//internet version online status consts
 ISTATUS_ONLINE          =$00;
 ISTATUS_INVISIBLE       =$100;
 ISTATUS_INVISIBLE_2     =$10;
 ISTATUS_NA              =$05;
 ISTATUS_FREE_CHAT       =$20;
 ISTATUS_OCCUPIED        =$11;
 ISTATUS_AWAY            =$01;
 ISTATUS_DND             =$13;

//user info limits
 MAXNICKNAME             =128;
 MAXFIRSTNAME            =128;
 MAXLASTNAME             =128;
 MAXEMAIL                =128;

 MAXCITY                 =128;
 MAXSTATE                =128;
 MAXPHONE                =128;
 MAXHOMEPAGE             =256;
 MAXABOUT                =512;

//authorization consts
 Iauthorization_req      =0;
 Iauthorization_always   =1;

 PM_ICQINET_SERVERNOTFOUND				=(WM_USER+$1800);
 PM_ICQINET_CONFIGURATIONDATANOTFOUND	                =(WM_USER+$1810);
 PM_ICQINET_LOGINSUCCESS	   		        =(WM_USER+$1820);
 PM_ICQINET_LOGINFAILED					=(WM_USER+$1825);
 PM_ICQINET_MESSAGESENT					=(WM_USER+$1830);// wParam - message id
 PM_ICQINET_RECEIVEMESSAGE                              =(WM_USER+$1835);// wparam -UIN lparam-PChar
 PM_ICQINET_URLRECEIVED                                 =(WM_USER+$1836);// wparam -UIN lparam-pchar ( description + $FE + url )
 PM_ICQINET_INFOREPLY                                   =(WM_USER+$1837);// wParam - uin lParam - TICQUSERINFO struct
 PM_ICQINET_EXTINFOREPLY                                =(WM_USER+$1838);// wParam - uin lParam - TICQUSEREXTINFO struct


// wParam - uin lParam - status
 PM_ICQINET_USERONLINE                                  =(WM_USER+$1850);
// wParam - uin
 PM_ICQINET_USEROFFLINE                                 =(WM_USER+$1851);

type
  TICQ_Server_Type=(ist_Corp,ist_inet);

  TICQ_Init_Proc=Function(Window_Handle:HWND;S_Name:PChar;Port:Word;UIN:DWord;Pass:PChar;Contact:Pointer;Contact_Size:Byte):LongBool;stdcall;
  TICQ_Send_Msg_Proc=Function(IcqNumber:DWORD;Data:LPSTR):WORD;stdcall;
  TICQ_Finit_Proc=Procedure;stdcall;
  TICQ_Send_URL_Proc=Function(IcqNumber:DWORD;Description,Url:PChar):Word;stdcall;
  TICQ_Send_User_Info_Request_Proc=Function(IcqNumber:DWord):Word;stdcall;
  TICQ_Send_User_Ext_Info_Request_Proc=Function(IcqNumber:DWord):Word;stdcall;



  TServerNotFoundProcedure=TNotifyEvent;
  TLoginSuccess=TNotifyEvent;
  TLoginFailed=TNotifyEvent;
  TMessageSent=procedure (Sender:TObject;Message_ID:DWord)of Object;
  TOnMessageReceived=Procedure (Sender:TObject;UIN:DWORD;Message:String)of Object;
  TOnUserOnLine=Procedure (Sender:TObject;UIN:DWord;Status:DWord)of Object;
  TOnUserOffLine=Procedure (Sender:TObject;UIN:DWord)of Object;
  TOnURLReceived=Procedure (Sender:TObject;UIN:DWord;Description:String;URL:String)Of Object;
  TOnUserInfoReceived=Procedure (Sender:TObject;InfoID:Word;UIN:DWord;NickName,FirstName,LastName,EMail:String;AuthorizeNeeded:Boolean)Of Object;
  TOnUserExtInfoReceived=Procedure (Sender:TObject;InfoID:WORD;UIN:DWORD;City:String;CountryCode:WORD;CountryStatus:BYTE;State:String;Age:WORD;Sex:BYTE;Phone,HomePage,About:String)of Object;
  TICQUserInfo=packed Record
                       InfoSeqNum:WORD;                             // information sequence number
                       RemoteUin:DWORD;                              // remote user's uin
                       NickName:Array[1..MAXNICKNAME]Of Char;  // remote user's nick name
                       FirstName:Array[1..MAXFIRSTNAME]of Char;// remote user's first name
                       LastName:Array[1..MAXLASTNAME]Of Char;  // remote user's last name
                       EMail:Array[1..MAXEMAIL]Of Char;                // remote user's e-mail
                       Authorize:Byte;                              // 0x00 - authorization req., 0x01 - always
                      End;

  TICQUserExtInfo=packed Record
                          InfoSeqNum:WORD;                             // information sequence number
                          RemoteUin:DWORD;                              // remote user's uin
                          City:Array[1..MAXCITY]Of Char;                  // remote user's city
                          CountryCode:WORD;                    // remote user's country code
                          CountryStatus:BYTE;                  // 0xFE - country code entered, 0x9C - not entered
                          State:Array[1..MAXSTATE]Of Char;                // remote user's state (USA only)
                          Age:WORD;                                    // remote user's age, 0xFFFF - if not entered
                          Sex:BYTE;                                    // remote user's sex, 0x00 - not entered, 0x01 - female, 0x02 - male
                          Phone:Array[1..MAXPHONE]Of Char;                // remote user's phone
                          HomePage:Array[1..MAXHOMEPAGE]Of Char;  // remote user's home page
                          About:Array[1..MAXABOUT]Of Char;                // about user
                         End;
  TICQConnection = class(TComponent)
  private
    FUIN: DWORD;
    FPassword: String;
    FServerName: String;
    FActive: Boolean;
    FICQ_Server_Type:TICQ_Server_Type;
    Library_Handle:THandle;
    FServerPort: Word;
    Dispatch_Window:HWND;

    FOnMessageSent: TMessageSent;
    FOnServerNotFound: TNotifyEvent;
    FOnLoginSuccess: TNotifyEvent;
    FOnLoginFailed: TNotifyEvent;
    FOnMessageReceived: TOnMessageReceived;
    FContact_List: TStrings;
    FOnUserOnLine: TOnUserOnLine;
    FOnUserOffLine: TOnUserOffLine;
    FOnURLReceived: TOnURLReceived;
    FOnUserInfoReceived: TOnUserInfoReceived;
    FOnUserExtInfoReceived: TOnUserExtInfoReceived;

    procedure SetUIN(const Value: DWORD);
    procedure SetPassword(const Value: String);
    procedure SetServerName(const Value: String);
    procedure SetActive(const Value: Boolean);
    Procedure SetICQ_Server_Type(const Value:TICQ_Server_Type);
    procedure SetServerPort(const Value: Word);
    procedure SetOnLoginFailed(const Value: TNotifyEvent);
    procedure SetOnLoginSuccess(const Value: TNotifyEvent);
    procedure SetOnMessageSent(const Value: TMessageSent);
    procedure SetOnServerNotFound(const Value: TNotifyEvent);
    procedure SetOnMessageReceived(const Value: TOnMessageReceived);
    procedure SetContact_List(const Value: TStrings);
    procedure SetOnUserOnLine(const Value: TOnUserOnLine);
    procedure SetOnUserOffLine(const Value: TOnUserOffLine);
    procedure SetOnURLReceived(const Value: TOnURLReceived);
    procedure SetOnUserInfoReceived(const Value: TOnUserInfoReceived);
    procedure SetOnUserExtInfoReceived(
      const Value: TOnUserExtInfoReceived);
    { Private declarations }
  protected
    { Protected declarations }
    procedure Dispatch_Wnd_Proc(var Message: TMessage);
  public
    { Public declarations }
    Constructor Create(AOwner: TComponent);override;
    Destructor  Destroy;override;
    Function    SendICQMessage(UIN:DWord;Data:String):Word;
    Function    SendURLMessage(UIN:DWORD;Description,URL:String):Word;
    Function    SendUserInfoRequest(UIN:DWord):Word;
    Function    SendUserExtInfoRequest(UIN:DWord):Word;
  published
    { Published declarations }
   property Active:Boolean read FActive write SetActive;
   property UIN:DWORD read FUIN write SetUIN;
   property Password:String read FPassword write SetPassword;
   property ServerName:String read FServerName write SetServerName;
   property ICQServerType:TICQ_Server_Type read FICQ_Server_Type write SetICQ_Server_Type;
   property ServerPort:Word read FServerPort write SetServerPort;
   property Contact_List:TStrings read FContact_List write SetContact_List;

   property OnServerNotFound:TNotifyEvent read FOnServerNotFound write SetOnServerNotFound;
   property OnLoginSuccess:TNotifyEvent read FOnLoginSuccess write SetOnLoginSuccess;
   property OnLoginFailed:TNotifyEvent read FOnLoginFailed write SetOnLoginFailed;
   property OnMessageSent:TMessageSent read FOnMessageSent write SetOnMessageSent;
   property OnMessageReceived:TOnMessageReceived read FOnMessageReceived write SetOnMessageReceived;
   property OnUserOnLine:TOnUserOnLine read FOnUserOnLine write SetOnUserOnLine;
   property OnUserOffLine:TOnUserOffLine read FOnUserOffLine write SetOnUserOffLine;
   property OnURLReceived:TOnURLReceived read FOnURLReceived write SetOnURLReceived;
   property OnUserInfoReceived:TOnUserInfoReceived read FOnUserInfoReceived write SetOnUserInfoReceived;
   property OnUserExtInfoReceived:TOnUserExtInfoReceived read FOnUserExtInfoReceived write SetOnUserExtInfoReceived;
  end;
procedure Register;

implementation
Var
  ICQ_INIT_Proc:TICQ_Init_Proc;
  ICQ_Send_Msg_Proc:TICQ_Send_Msg_Proc;
  ICQ_Finit_Proc:TICQ_Finit_Proc;
  ICQ_Send_URL_Proc:TICQ_Send_URL_Proc;
  ICQ_Send_User_Info_Request_Proc:TICQ_Send_User_Info_Request_Proc;
  ICQ_Send_User_Ext_Info_Request_Proc:TICQ_Send_User_Ext_Info_Request_Proc;

procedure Register;
begin
  RegisterComponents('SM_SOFT', [TICQConnection]);
end;

{ TICQConnection }

//so strange method to convert null terminated string cause we got compiler error when using standart type translation :(

Function Convert_Char_Array_2_String(A:Array Of Char):String;
Var Z:Word;
Begin
 Result:='';
 Z:=0;
 While(A[Z])<>Chr(0) Do Begin Result:=Result+A[Z]; Inc(Z); End;
End;

procedure TICQConnection.SetActive(const Value: Boolean);
Var Temp_Serv,Temp_Pass:PChar;
    Contact_Array:Array[1..65535]Of DWord;
    A:Word;
begin
  If FActive=Value Then Exit;
  GetMem(Temp_Serv,100);
  GetMem(Temp_Pass,100);
  StrPCopy(Temp_Serv,FServerName);
  StrPCopy(Temp_Pass,FPassword);
Try
  FActive := Value;
  If Value Then Begin
                 Dispatch_Window:=AllocateHWnd(Dispatch_Wnd_Proc);
                 Case FICQ_Server_Type Of
                  ist_Corp:Library_Handle:=LoadLibrary(Icq_Corp_DLL_Name);
                  ist_inet:Library_Handle:=LoadLibrary(Icq_inet_DLL_Name);
                 End;
                 If Library_Handle=0 Then Raise Exception.Create('Error load Library');


                 @ICQ_INIT_Proc:=GetProcAddress(Library_Handle,'Initialize');
                 @ICQ_Send_Msg_Proc:=GetProcAddress(Library_Handle,'Send');
                 @ICQ_Finit_Proc:=GetProcAddress(Library_Handle,'Finalize');
                 @ICQ_Send_URL_Proc:=GetProcAddress(Library_Handle,'SendURL');
                 @ICQ_Send_User_Info_Request_Proc:=GetProcAddress(Library_Handle,'SendUserInfoRequest');
                 @ICQ_Send_User_Ext_Info_Request_Proc:=GetProcAddress(Library_Handle,'SendUserExtInfoRequest');

                 Try
                  For A:=1 To FContact_List.Count Do
                   Contact_Array[A]:=StrToInt(FContact_List[A-1]);
                 Except
                  On EConvertError Do raise Exception.Create('Error convert Contact List');
                 End;
                 A:=FContact_List.Count;

                 If Not ICQ_INIT_Proc(Dispatch_Window,Temp_Serv,FServerPort,FUIN,Temp_Pass,@Contact_Array,A)
                  Then raise Exception.Create('Error Init library');
                End Else Begin
                          If @ICQ_Finit_Proc<>Nil Then ICQ_Finit_Proc;
                          DeallocateHWnd(Dispatch_Window);
                          FreeLibrary(Library_Handle);
                          Library_Handle:=0;
                         End;
except
 on Exception Do FActive:=False;
End;
 FreeMem(Temp_Pass);
 FreeMem(Temp_Serv);
end;

procedure TICQConnection.SetPassword(const Value: String);
begin
  FPassword := Value;
end;

procedure TICQConnection.SetServerName(const Value: String);
begin
  FServerName := Value;
end;

procedure TICQConnection.SetUIN(const Value: DWORD);
begin
  FUIN := Value;
end;
Procedure TICQConnection.SetICQ_Server_Type(const Value:TICQ_Server_Type);
Begin
 FICQ_Server_Type:=Value;
 Case FICQ_Server_Type Of
  ist_inet:ServerName:='icq1.mirabilis.com';
 End;
End;
constructor TICQConnection.Create(AOwner: TComponent);
begin
 inherited;
 Library_Handle:=0;
 Dispatch_Window:=0;
 FServerPort:=4000;
 FContact_List:=TStringList.Create;
end;

procedure TICQConnection.Dispatch_Wnd_Proc(var Message: TMessage);
Var Desc,Url:String;UserInfo:^TICQUserInfo;
                    UserExtInfo:^TICQUserExtInfo;
begin
 With Message Do
  Case Msg Of
   PM_ICQINET_SERVERNOTFOUND:If Assigned (FOnServerNotFound) Then FOnServerNotFound(Self);
   PM_ICQINET_LOGINSUCCESS:If Assigned(FOnLoginSuccess) Then FOnLoginSuccess(Self);
   PM_ICQINET_LOGINFAILED:If Assigned(FOnLoginFailed) Then FOnLoginFailed(Self);
   PM_ICQINET_MESSAGESENT:If Assigned(FOnMessageSent) Then FOnMessageSent(Self,DWord(wparam));
   PM_ICQINET_RECEIVEMESSAGE:If Assigned(FOnMessageReceived) Then FOnMessageReceived(Self,wparam,String(PChar(lparam)));
   PM_ICQINET_USERONLINE:If Assigned(FOnUserOnLine) Then FOnUserOnLine(Self,wparam,lparam);
   PM_ICQINET_USEROFFLINE:If Assigned(FOnUserOffLine) Then FOnUserOffLine(Self,wparam);
   PM_ICQINET_URLRECEIVED:If Assigned(FOnURLReceived) Then Begin
                                                            Desc:=String(PChar(LParam));
                                                            Url:=Copy(Desc,Pos(Chr($FE),Desc)+1,1024);
                                                            Desc:=Copy(Desc,1,Pos(Chr($FE),Desc)-1);
                                                            FOnURLReceived(Self,wparam,Desc,Url);
                                                           End;
   PM_ICQINET_INFOREPLY:If Assigned(FOnUserInfoReceived)
                          Then Begin
                                UserInfo:=Pointer(lparam);
                                FOnUserInfoReceived(Self,UserInfo^.InfoSeqNum,UserInfo^.RemoteUin,
                                                    Convert_Char_Array_2_String(UserInfo^.NickName),
                                                    Convert_Char_Array_2_String(UserInfo^.FirstName),
                                                    Convert_Char_Array_2_String(UserInfo^.LastName),
                                                    Convert_Char_Array_2_String(UserInfo^.EMail),
                                                    Not Boolean(UserInfo^.Authorize));
                               End;
  PM_ICQINET_EXTINFOREPLY:If Assigned(FOnUserExtInfoReceived)
                          Then Begin
                                UserExtInfo:=Pointer(lparam);
                                FOnUserExtInfoReceived(Self,UserExtInfo^.InfoSeqNum,UserExtInfo^.RemoteUin,
                                                       Convert_Char_Array_2_String(UserExtInfo^.City),
                                                       UserExtInfo^.CountryCode,
                                                       UserExtInfo^.CountryStatus,
                                                       Convert_Char_Array_2_String(UserExtInfo^.State),
                                                       UserExtInfo^.Age,
                                                       UserExtInfo^.Sex,
                                                       Convert_Char_Array_2_String(UserExtInfo^.Phone),
                                                       Convert_Char_Array_2_String(UserExtInfo^.HomePage),
                                                       Convert_Char_Array_2_String(UserExtInfo^.About));
                               End;

  End;
end;

procedure TICQConnection.SetServerPort(const Value: Word);
begin
  FServerPort := Value;
end;

procedure TICQConnection.SetOnLoginFailed(const Value: TNotifyEvent);
begin
  FOnLoginFailed := Value;
end;

procedure TICQConnection.SetOnLoginSuccess(const Value: TNotifyEvent);
begin
  FOnLoginSuccess := Value;
end;

procedure TICQConnection.SetOnMessageSent(const Value: TMessageSent);
begin
  FOnMessageSent := Value;
end;

procedure TICQConnection.SetOnServerNotFound(const Value: TNotifyEvent);
begin
  FOnServerNotFound := Value;
end;

Function TICQConnection.SendICQMessage(UIN: DWord; Data: String):Word;
begin
 Result:=ICQ_Send_Msg_Proc(UIN,PChar(Data));
end;

destructor TICQConnection.Destroy;
begin
 SetActive(False);
 FContact_List.Free;
 Inherited;
end;

procedure TICQConnection.SetOnMessageReceived(
  const Value: TOnMessageReceived);
begin
  FOnMessageReceived := Value;
end;

procedure TICQConnection.SetContact_List(const Value: TStrings);
begin
  FContact_List.Assign(Value);
end;

procedure TICQConnection.SetOnUserOnLine(const Value: TOnUserOnLine);
begin
  FOnUserOnLine := Value;
end;

procedure TICQConnection.SetOnUserOffLine(const Value: TOnUserOffLine);
begin
  FOnUserOffLine := Value;
end;

function TICQConnection.SendURLMessage(UIN: DWORD; Description,
  URL: String): Word;
begin
 Result:=ICQ_Send_URL_Proc(UIN,PChar(Description),PChar(URL));

end;

procedure TICQConnection.SetOnURLReceived(const Value: TOnURLReceived);
begin
  FOnURLReceived := Value;
end;

function TICQConnection.SendUserInfoRequest(UIN: DWord): Word;
begin
 Result:=ICQ_Send_User_Info_Request_Proc(UIN);
end;

procedure TICQConnection.SetOnUserInfoReceived(
  const Value: TOnUserInfoReceived);
begin
  FOnUserInfoReceived := Value;
end;

procedure TICQConnection.SetOnUserExtInfoReceived(
  const Value: TOnUserExtInfoReceived);
begin
  FOnUserExtInfoReceived := Value;
end;

function TICQConnection.SendUserExtInfoRequest(UIN: DWord): Word;
begin
 Result:=ICQ_Send_User_Ext_Info_Request_Proc(UIN);
end;

end.
