unit LsIconPrEditorReg;

interface

uses DsgnIntf, Forms, SysUtils, Controls, Graphics, TypInfo;

type
 TLsIconPrEditor = class(TClassProperty)
 public
  function GetAttributes: TPropertyAttributes; override;
  procedure Edit; override;
 end;

procedure Register;

implementation

uses LsIconPrEditorMain, SaveIconDlg;

function TLsIconPrEditor.GetAttributes: TPropertyAttributes;
begin
 Result := [paDialog]
end;

procedure TLsIconPrEditor.Edit;
begin
 Application.CreateForm(TLsIconPrEditorForm, LsIconPrEditorForm);
 Application.CreateForm(TSaveIconForm, SaveIconForm);
 with LsIconPrEditorForm do
 try
  Image1.Picture.Graphic := TIcon(GetOrdValue);
  if ShowModal = mrOk then
   if (GetPropType^.Name = 'TIcon') then
    SetOrdValue(LongInt(Image1.Picture))
 finally
 {$IFNDEF VER90}
 	 Close;
 {$ELSE}
   Free;
 {$ENDIF}
 end;
end;

procedure Register;
begin
 RegisterPropertyEditor(TypeInfo(TIcon), nil, '', TLsIconPrEditor);
end;

end.