{LsIconPrEditor  version 2.00  Dec/99}
{==============================================================================}
{$A+,B-,C+,D+,E-,F-,G+,H+,I+,J+,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}

{$IFNDEF VER80}                   // If not Delphi 1
   {$DEFINE D2_OR_HIGHER}
   {$IFNDEF VER90}                // If not Delphi 2
      {$DEFINE D3_OR_HIGHER}
      {$IFNDEF VER100}            // If not Delphi 3
         {$DEFINE D4_OR_HIGHER}
         {$IFNDEF VER120}         // If not Delphi 4
            {$DEFINE D5_OR_HIGHER}
         {$ENDIF}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}


unit LsIconPrEditorMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, Buttons, StdCtrls, ExtCtrls, IniFiles, ShellAPI, Menus
{$IFDEF D4_OR_HIGHER},
  ImgList 
{$ENDIF};

type

	TCursorOrIcon = packed record
		Reserved: Word;
		wType: Word;
		Count: Word;
	end;

	PIconRec = ^TIconRec;
	TIconRec = packed record
		Width: Byte;
		Height: Byte;
		Colors: Word;
		Reserved1: Word;
		Reserved2: Word;
		DIBSize: Longint;
		DIBOffset: Longint;
	end;

	TLsIconPrEditorForm = class(TForm)
		StatusBar1: TStatusBar;
		Panel3: TPanel;
		Panel1: TPanel;
		Panel2: TPanel;
		BtnBookMk: TSpeedButton;
		BtnAddBookMk: TSpeedButton;
		BtnOpen: TSpeedButton;
		BtnClear: TSpeedButton;
    BtnCancel: TSpeedButton;
		IconView: TListView;
		OpenDialog1: TOpenDialog;
		SaveDialog1: TSaveDialog;
		IconList: TImageList;
		Image1: TImage;
		PopupMenu1: TPopupMenu;
		AddBookMark1: TMenuItem;
		DeleteBookMark1: TMenuItem;
		LbxBookMark: TListBox;
		BtnSaveIco: TSpeedButton;
		Label1: TLabel;
		MoveBookMarkUp1: TMenuItem;
		MoveBookMarkDown1: TMenuItem;
		CloseBookMarkList1: TMenuItem;
    BtnOK: TSpeedButton;
		procedure BtnOpenClick(Sender: TObject);
		procedure BtnClearClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure IconViewClick(Sender: TObject);
		procedure BtnBookMkClick(Sender: TObject);
		procedure LbxBookMarkDblClick(Sender: TObject);
		procedure BtnAddBookMkClick(Sender: TObject);
		procedure BtnSaveIcoClick(Sender: TObject);
		procedure AddBookMark1Click(Sender: TObject);
		procedure DeleteBookMark1Click(Sender: TObject);
		procedure MoveBookMarkUp1Click(Sender: TObject);
		procedure MoveBookMarkDown1Click(Sender: TObject);
		procedure CloseBookMarkList1Click(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
		procedure BtnCancelClick(Sender: TObject);
		procedure IconViewKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure LbxBookMarkKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
    procedure SaveToIcoFile(Sender: TObject);
		procedure SaveToBmpFile(Sender: TObject);

	private
	{ Private declarations }
		IniFile: TIniFile;
		InitDirPath: string;
		NumberOfIcons: longint;
		Title: string;

		procedure BtnState;
		procedure DisplayHint(Sender: TObject);
		procedure LoadBookMarks;
		procedure AddBookMark(NewFName: string);
		procedure UpdateBookMarks;

		procedure InitializeBitmapInfoHeader(Bitmap: HBITMAP; var bi: TBitmapInfoHeader;
			Colors: Integer);
		procedure GetDIBSizes(Bitmap: HBITMAP; var InfoHeaderSize: DWORD;
			var ImageSize: DWORD; Colors: Integer);
		function GetDIB(Bitmap: HBITMAP; Palette: HPALETTE; var BitmapInfo;
      var Bits; Colors: Integer): Boolean;
		procedure SaveToStream(Stream: TStream; Icon: HICON;
			SaveLength: Boolean; Colors: Integer);
//		procedure ConvertIcon2Bitmap( aIcon: TIcon; TransColor: TColor;
//      var aBitMap: TBitmap);

	public
	{ Public declarations }
    IsBmp : Boolean;
    IsIco : Boolean;
    BmpHeight : Integer;
    BmpWidth : Integer;
    IcoColors: Integer;
		IconFName: string;
		IconFExt : string;
		procedure LoadIcons(IFName: string);
	end;

var
	LsIconPrEditorForm: TLsIconPrEditorForm;

implementation

{$R *.DFM}

uses  SaveIconDlg;

// Display Hint in the StatusBar
procedure TLsIconPrEditorForm.DisplayHint(Sender: TObject);
begin
	Statusbar1.SimpleText := GetLongHint(Application.Hint);
end; //DisplayHint

// Enable buttons when needed
procedure TLsIconPrEditorForm.BtnState;
begin
	BtnSaveIco.Enabled := Image1.Picture.Icon.Empty = False;
  BtnClear.Enabled := IconView.Items.Count <> 0;
  BtnOK.Enabled := (Image1.Picture.Icon.Empty = False) or
    (Image1.Picture.Graphic.Empty = False);
end; //BtnState

procedure TLsIconPrEditorForm.FormCreate(Sender: TObject);
begin
{$IFDEF D3_OR_HIGHER}
	BtnBookMk.Flat := True;
	BtnAddBookMk.Flat := True;
	BtnOpen.Flat := True;
	BtnSaveIco.Flat := True;
	BtnClear.Flat := True;
  BtnOK.Flat := True;
	BtnCancel.Flat := True;
{$ENDIF}
	IconFName := '';
	NumberOfIcons := -1;
	Image1.Picture := nil;
	Application.OnHint := DisplayHint;
	Title := 'LsIconExplorer ';
	with LbxBookMark do begin
		Left := 103;
		Top := 2;
		Height := 125;
		Width := 284;
		Visible := False;
	end;
	GetDir(0, InitDirPath);
	LoadBookMarks;
	BtnState;
end; //FormCreate

// Retrieves icons from selected file. then load them to IconView
procedure TLsIconPrEditorForm.LoadIcons(IFName: string);
var
	x: integer;
	Icon: TIcon;
	pFName: array[0..255] of char;
	oldCursor: TCursor;
	ListItem: TListItem;
begin
	if FileExists(IFName) then begin
		OldCursor := Screen.Cursor;
		Screen.CurSor := crHourGlass;
		NumberOfIcons := ExtractIcon(hInstance, StrPCopy(pFName, IFName), $FFFFFFFF);
		IconList.Clear;
		IconList.Height := 32;
		IconList.Width := 32;
		Image1.Picture := nil;
		with IconView do begin
			Items.Clear;
			ViewStyle := vsIcon;
			LargeImages := IconList;
			Items.BeginUpdate;
			try
				for x := 0 to NumberOfIcons - 1 do begin
					Icon := TIcon.Create;
					Icon.Handle := ExtractIcon(hInstance, pFName, x);
					IconList.AddIcon(Icon);
					ListItem := Items.Add;
					ListItem.Caption := Format('%d', [x]);
          ListItem.ImageIndex := x;
          Icon.Free;
				end;
      finally
				Items.EndUpdate;
				IconView.Selected := nil;
				Screen.Cursor := OldCursor;
			end;
		end; // with
	end; // if
  BtnState;
end; //LoadIcons

// Load BookMarks from IniFile(IconEditor.ini) to BookMark List(LbxBookMark)
procedure TLsIconPrEditorForm.LoadBookMarks;
var
  i,
		BookMarkCount,
		LastFileIndex: integer;
begin
  IniFile := TIniFile.Create('IconEditor.ini');
	with IniFile do
  try
    LbxBookMark.Items.Clear;
		LbxBookMark.ItemIndex := 0;
		BookMarkCount := ReadInteger('General', 'BookMarkCount', 0);
    for i := 1 to BookMarkCount do begin
			LbxBookMark.ItemIndex := i - 1;
      LbxBookMark.Items.Add(ReadString('Path', 'File' + IntToStr(i), ''));
		end;
    LastFileIndex := ReadInteger('General', 'LastFileIndex', 0);
		LbxBookMark.ItemIndex := LastFileIndex;
  finally
		Free;
  end;
end; //LoadBookMarks

// Open a Exe, Dll, Icon or Nil file for retrieving icons
procedure TLsIconPrEditorForm.BtnOpenClick(Sender: TObject);
begin
	with OpenDialog1 do begin
    InitialDir := InitDirPath;
		Title := 'Open File for retrieving icons';
    DefaultExt := 'Exe, Dll, Nil, Ico, Bmp';
		if Execute then begin
      IconFName := OpenDialog1.FileName;
      LoadIcons(IconFName);
    end;
	end;
  Caption := Title + '- ' + ExtractFileName(IconFName);
end; //BtnOpenClick

// Clear icons from the IconView
procedure TLsIconPrEditorForm.BtnClearClick(Sender: TObject);
begin
	IconView.Items.Clear;
	Image1.Picture := nil;
	Caption := '';
	Caption := Title;
	BtnState;
end; //BtnClearClick

// Select an icon form IconView
procedure TLsIconPrEditorForm.IconViewClick(Sender: TObject);
var
	pFName   : array[0..255] of char;
begin
	if (IconView.Selected = nil) then exit;
	IconFExt := ExtractFileExt(IconFName);
	if UpperCase(IconFExt) = '.ICO' then
		Image1.Picture.Icon.LoadFromFile(IconFName)
	else
		Image1.Picture.Icon.Handle := ExtractIcon(hInstance,
																 StrPCopy(pFName, IconFName),
																 IconView.Selected.ImageIndex);
	BtnState;
end; //IconViewClick

// Press Return Key to select an icon from IconView
procedure TLsIconPrEditorForm.IconViewKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	if (Key = VK_Return) then
		IconViewClick(Sender);
end; //IconViewKeyDown

// Open or Close BookMark List
procedure TLsIconPrEditorForm.BtnBookMkClick(Sender: TObject);
begin
	with LbxBookMark do
    if Visible = False then
      Visible := True
		else Visible := False;
end; //BtnBookMkClick

// To open the selected file in BookMark ListBox
procedure TLsIconPrEditorForm.LbxBookMarkDblClick(Sender: TObject);
begin
	IconFName := LbxBookMark.Items[LbxBookMark.ItemIndex];
	LoadIcons(IconFName);
	Caption := Title + ' - ' + ExtractFileName(IconFName);
	LbxBookMark.Visible := False;
end; //LbxBookMarkDblClick

// Press Return Key to open the selected file in BookMark List
procedure TLsIconPrEditorForm.LbxBookMarkKeyDown(Sender: TObject;
	var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_Return) then
		LbxBookMarkDblClick(Sender);
end; //LbxBookMarkKeyDown

// Add currently opened file to BookMark List
procedure TLsIconPrEditorForm.BtnAddBookMkClick(Sender: TObject);
var
	IFileName: string;
begin
	if IconFName = '' then begin
    ShowMessage('No file selected');
    exit;
	end;
  IFileName := ExtractFileName(IconFName);
	if MessageDlg('Add the currently opened file' + #13 +
    '      "' + UpperCase(IFileName) + '"' + #13 +
		'to the BookMark List?' + #13, mtConfirmation,
		[mbYes, mbNo], 0) = mrNo then exit;
	AddBookMark(IconFName);
end; //BtnAddBookMkClick

// Add a File (NewFName) to BookMark List
procedure TLsIconPrEditorForm.AddBookMark(NewFName: string);
begin
  LbxBookMark.Items.Add(NewFName);
  LbxBookMark.ItemIndex := Pred(LbxBookMark.Items.Count);
  IniFile := TIniFile.Create('IconEditor.ini');
	with IniFile do
  try
		WriteInteger('General', 'BookMarkCount', LbxBookMark.Items.Count);
		WriteString('Path', 'File' + IntToStr(LbxBookMark.Items.Count),
      LowerCase(NewFName));
	finally
		Free;
	end;
end; //AddBookMark

// Update IniFile(IconEditor.ini) after deleting/moving BookMarks
procedure TLsIconPrEditorForm.UpdateBookMarks;
var
	i: integer;
begin
  IniFile := TIniFile.Create('IconEditor.ini');
	with IniFile do
	try
		WriteInteger('General', 'BookMarkCount', LbxBookMark.Items.Count);
    LbxBookMark.ItemIndex := 0;
    for i := 1 to LbxBookMark.Items.Count do begin
			LbxBookMark.ItemIndex := i - 1;
      WriteString('Path', 'File' + IntToStr(i),
        LowerCase(LbxBookMark.Items[Pred(i)]));
    end; // for
	finally
    Free;
	end;
end; //UpdateBookMarks

// Add a new file to the BookMark list
procedure TLsIconPrEditorForm.AddBookMark1Click(Sender: TObject);
var
  NewBkMark: string;
begin
  with OpenDialog1 do begin
    Title := 'Add selected file to BookMark List';
    if Execute then begin
      NewBkMark := OpenDialog1.FileName;
			if MessageDlg('Add file "' + UpperCase(ExtractFileName(NewBkMark)) +
				'"' + #13 + 'to the BookMark List?' + #13, mtConfirmation,
				[mbYes, mbNo], 0) = mrNo then
				exit;
      AddBookMark(NewBkMark);
		end;
  end;
end; //AddBookMark1Click

// Delete an existing BookMark from the BookMark List
procedure TLsIconPrEditorForm.DeleteBookMark1Click(Sender: TObject);
var
  OldItemIndex: integer;
begin
  if (LbxBookMark.Items.Count = 0) or (LbxBookMark.ItemIndex = -1) then
    exit;
	OldItemIndex := LbxBookMark.ItemIndex;
	if MessageDlg('Are you sure you want to delete' + #13 + '    "' +
		UpperCase(ExtractFileName(LbxBookMark.Items[OldItemIndex])) +
		'"' + #13 + 'from the BokkMark List ?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
	try
		LbxBookMark.Items.Delete(OldItemIndex);
		LbxBookMark.Update;
		LbxBookMark.ItemIndex := 0;
		UpdateBookMarks;
  finally
    LoadBookMarks;
	end;
end; //DeleteBookMark1Click

// Move selected Bookmark up by one position
procedure TLsIconPrEditorForm.MoveBookMarkUp1Click(Sender: TObject);
var
	OldItemIndex: integer;
begin
  OldItemIndex := LbxBookMark.ItemIndex;
	if (OldItemIndex = 0) then exit;
	LbxBookMark.Items.Exchange(OldItemIndex, Pred(OldItemIndex));
	UpdateBookMarks;
	LoadBookMarks;
	LbxBookMark.ItemIndex := OldItemIndex - 1;
end; //MoveBookMarkUp1Click

// Move selected BookMark down by one position
procedure TLsIconPrEditorForm.MoveBookMarkDown1Click(Sender: TObject);
var
	OldItemIndex: integer;
begin
	OldItemIndex := LbxBookMark.ITemIndex;
	if (OldItemIndex = LbxBookMark.Items.Count - 1) then exit;
	LbxBookMark.Items.Exchange(OldItemIndex, Succ(OldItemIndex));
	UpdateBookMarks;
	LoadBookMarks;
	LbxBookMark.ItemIndex := OldItemIndex + 1;
end; //MoveBookMarkDown1Click

// Close the BookMark List
procedure TLsIconPrEditorForm.CloseBookMarkList1Click(Sender: TObject);
begin
	LbxBookMark.Visible := False;
end; //CloseBookMarkList1Click

// Update the IconEditor.ini before Close
procedure TLsIconPrEditorForm.BtnCancelClick(Sender: TObject);
begin
	IniFile := TIniFile.Create('IconEditor.ini');
	IniFile.writeInteger('General', 'LastFileIndex', LbxBookMark.ItemIndex);
	IniFile.Free;
	ModalResult := mrCancel;
	Close;
end; //BtnCancelClick


procedure TLsIconPrEditorForm.BtnOKClick(Sender: TObject);
begin
 ModalResult := mrOK;
 IniFile := TIniFile.Create('IconEditor.ini');
 IniFile.writeInteger('General', 'LastFileIndex', LbxBookMark.ItemIndex);
 IniFile.Free;
end;

// Save the selected icon to an Icon file or to a Bitmap file
procedure TLsIconPrEditorForm.BtnSaveIcoClick(Sender: TObject);
begin
	if (IconView.Selected = nil) or
		 (Image1.Picture.Icon.Empty) then
	begin
		ShowMessage('No icon selected');
		exit;
	end;

	With SaveIconForm Do
	begin
		ShowModal;
		if ModalResult = mrOK then
    begin
      if IsIco then
      begin
        IcoColors := Colors;
        SaveToIcoFile(Sender);
      end
      else if IsBmp then
      begin
        SpEdtHeight.Update;
        SpEdtWidth.Update;
        BmpHeight := SpEdtHeight.Value;
        BmpWidth  := SpEdtWidth.Value;
        SaveToBmpFile(Sender);
      end;
    end
    else exit;
	end;
end;  //BtnSaveIcoClick

// Save selected icon to an .ico file
procedure TLsIconPrEditorForm.SaveToIcoFile(Sender: TObject);
var
	PEIcon	: TIcon;
	FStream : TFileStream;
begin
	PEIcon := Image1.Picture.Icon;
	with SaveDialog1 do
	begin
		Title := 'Save selected icon to *.ico file';
		FilterIndex := 2;
		DefaultExt := '.ico';
		InitialDir := InitDirPath;
		if SaveDialog1.Execute then
		begin
			if (SaveDialog1.FileName = '') or
				(IconView.Selected = nil) then exit;
			FStream := TFileStream.Create(SaveDialog1.FileName,fmCreate or fmOpenWrite) ;
			try
				SaveToStream(FStream, PEIcon.Handle, False, IcoColors);
			finally
				FStream.Free;
			end;
		end;
	end;
end; //SaveToIcoFile

// Convert selected icon to bitmap then save it to a .bmp file
procedure TLsIconPrEditorForm.SaveToBmpFile(Sender: TObject);
var
	Bmp1,
   Bmp2 : TBitmap;
	Icon1 : TIcon;
  Rect1 : TRect;
//  BitsperPixel : integer;
begin
	Bmp1 := TBitmap.Create;
  Bmp2 := TBitmap.Create;
	Icon1 := Image1.Picture.Icon;
	try
    with Rect1 do
    begin
      Top := 0;
      Left := 0;
      Right := BmpWidth;
      Bottom := BmpHeight;
    end;

		with Bmp1 do
		begin
			width := Icon1.Width;
			Height := Icon1.Height;
			canvas.draw(0, 0, Icon1);
		end;
//    ConvertIcon2Bitmap(Icon1, DefTransColor, Bmp2);

    with Bmp2 do
    begin
      Width := BmpWidth;
      Height := BmpHeight;
      Canvas.StretchDraw(Rect1, Bmp1);
    end;
		Image1.Picture := nil;
		Image1.Picture.Graphic := Bmp2;
		with SaveDialog1 do
		begin
			Title := 'Save selected icon to *.bmp file';
			FilterIndex := 1;
      DefaultExt := '.BMP';
      InitialDir := InitDirPath;
      if SaveDialog1.Execute then
      begin
        if (SaveDialog1.FileName = '') then exit;
				Image1.Picture.Bitmap.SaveToFile(SaveDialog1.FileName);
			end;
		end;
	finally
		Bmp1.Free;
    Bmp2.Free;
	end;
end; //SaveToBmpFile


// Procedures listed below are used to save an icon to a file stream
// either in 16-colors, 256-colors or higher

procedure TLsIconPrEditorForm.InitializeBitmapInfoHeader(Bitmap: HBITMAP;
	var bi: TBitmapInfoHeader; Colors: Integer);
var
	ds: TDIBSection;
	Bytes: Integer;

	function BytesPerScanline(PixelsPerScanline, BitsPerPixel,
		Alignment: Longint): Longint;
	begin
		Dec(Alignment);
		Result := ((PixelsPerScanline * BitsPerPixel) + Alignment) and not Alignment;
		Result := Result div 8;
	end;

begin
	ds.dsbmih.biSize := 0;
	Bytes := GetObject(Bitmap, SizeOf(ds), @ds);
	if Bytes = 0 then
		ShowMessage('Invalid Bitmap')
	else if (Bytes >= (sizeof(ds.dsbm) + sizeof(ds.dsbmih))) and
		(ds.dsbmih.biSize >= DWORD(sizeof(ds.dsbmih))) then
		bi := ds.dsbmih
	else
	begin
		FillChar(bi, sizeof(bi), 0);
		with bi, ds.dsbm do
		begin
			biSize := SizeOf(bi);
			biWidth := bmWidth;
			biHeight := bmHeight;
		end;
	end;
	if Colors <> 0 then
		case Colors of
			2: bi.biBitCount := 1;
			16: bi.biBitCount := 4;
			256: bi.biBitCount := 8;
		end
	else bi.biBitCount := ds.dsbm.bmBitsPixel * ds.dsbm.bmPlanes;
	bi.biPlanes := 1;
	if bi.biSizeImage = 0 then
		bi.biSizeImage := BytesPerScanLine(bi.biWidth, bi.biBitCount, 32) *
      Abs(bi.biHeight);
end; //InitializeBitmapInfoHeader

procedure TLsIconPrEditorForm.GetDIBSizes(Bitmap: HBITMAP;
  var InfoHeaderSize: DWORD; var ImageSize: DWORD; Colors: Integer);
var
	bi: TBitmapInfoHeader;
begin
	InitializeBitmapInfoHeader(Bitmap, bi, Colors);
	if bi.biBitCount > 8 then
	begin
		InfoHeaderSize := SizeOf(TBitmapInfoHeader);
		if (bi.biCompression and BI_BITFIELDS) <> 0 then
			Inc(InfoHeaderSize, 12);
	end
	else
		InfoHeaderSize := SizeOf(TBitmapInfoHeader) + SizeOf(TRGBQuad) *
			(1 shl bi.biBitCount);
	ImageSize := bi.biSizeImage;
end; //GetDIBSizes

function TLsIconPrEditorForm.GetDIB(Bitmap: HBITMAP; Palette: HPALETTE;
	var BitmapInfo; var Bits; Colors: Integer): Boolean;
var
	OldPal: hPalette;
	DC: HDC;
begin
	InitializeBitmapInfoHeader(Bitmap, TBitmapInfoHeader(BitmapInfo), Colors);
	OldPal := 0;
	DC := CreateCompatibleDC(0);
	try
		if Palette <> 0 then
		begin
			OldPal := SelectPalette(DC, Palette, False);
			RealizePalette(DC);
		end;
		Result := GetDIBits(DC, Bitmap, 0, TBitmapInfoHeader(BitmapInfo).biHeight, @Bits,
			TBitmapInfo(BitmapInfo), DIB_RGB_COLORS) <> 0;
	finally
		if OldPal <> 0 then SelectPalette(DC, OldPal, False);
		DeleteDC(DC);
	end;
end; //GetDIB

procedure TLsIconPrEditorForm.SaveToStream(Stream: TStream; Icon: HIcon;
	SaveLength :Boolean; Colors: Integer);
var
	ii: TIconInfo;
	MonoInfoSize, ColorInfoSize: DWORD;
	MonoBitsSize, ColorBitsSize: DWORD;
	MonoInfo, MonoBits, ColorInfo, ColorBits: Pointer;
	ci: TCursorOrIcon;
	List: TIconRec;
	Length: Longint;
begin
	FillChar(ci, SizeOf(ci), 0);
	FillChar(List, SizeOf(List), 0);
	if not GetIconInfo(Icon, ii) then
		ShowMessage('ERROR - unable to retrive IconInfo');
	try
		GetDIBSizes(ii.hbmMask, MonoInfoSize, MonoBitsSize, 2);
		GetDIBSizes(ii.hbmColor, ColorInfoSize, ColorBitsSize, Colors);
		MonoInfo := nil;
		MonoBits := nil;
		ColorInfo := nil;
		ColorBits := nil;
		try
			MonoInfo := AllocMem(MonoInfoSize);
			MonoBits := AllocMem(MonoBitsSize);
			ColorInfo := AllocMem(ColorInfoSize);
			ColorBits := AllocMem(ColorBitsSize);
			GetDIB(ii.hbmMask, 0, MonoInfo^, MonoBits^, 2);
			GetDIB(ii.hbmColor, 0, ColorInfo^, ColorBits^, Colors);
			if SaveLength then
			begin
				Length := SizeOf(ci) + SizeOf(List) + ColorInfoSize +
					ColorBitsSize + MonoBitsSize;
				Stream.Write(Length, SizeOf(Length));
			end;
			with ci do
			begin
				ci.wType := 1;  //RC3_ICON;
				ci.Count := 1;
			end;
			Stream.Write(ci, SizeOf(ci));
			with List, PBitmapInfoHeader(ColorInfo)^ do
			begin
				Width := biWidth;
				Height :=  biHeight;
				Colors := biPlanes * biBitCount;
				DIBSize := ColorInfoSize + ColorBitsSize + MonoBitsSize;
				DIBOffset := SizeOf(ci) + SizeOf(List);
			end;
			Stream.Write(List, SizeOf(List));
			with PBitmapInfoHeader(ColorInfo)^ do
				Inc(biHeight, biHeight); { color height includes mono bits }
			Stream.Write(ColorInfo^, ColorInfoSize);
			Stream.Write(ColorBits^, ColorBitsSize);
			Stream.Write(MonoBits^, MonoBitsSize);
		finally
			FreeMem(ColorInfo, ColorInfoSize);
			FreeMem(ColorBits, ColorBitsSize);
			FreeMem(MonoInfo, MonoInfoSize);
			FreeMem(MonoBits, MonoBitsSize);
		end;
	finally
		DeleteObject(ii.hbmColor);
		DeleteObject(ii.hbmMask);
	end;
end; //SaveToStream

{*
procedure TIconExplorerForm.ConvertIcon2Bitmap( aIcon: TIcon;
  TransColor: TColor; var aBitMap: TBitmap);
const
  DefTransColor : TColor = $00123456;
var
  i, j : integer;
  ii : TIconInfo;
  AndMask : TBitmap;
  OldMaskColor : TColor;
  NewMaskColor : TColor;
begin
  AndMask := TBitmap.Create;
  try
    GetIconInfo(aIcon.Handle, ii);
    AndMask.Handle := ii.hbmMask;
    aBitmap.Width := AndMask.Width;
    aBitmap.Height := AndMask.Height + 1;

    aBitmap.Canvas.Draw(0, 0, aIcon);

    aBitmap.Canvas.Pen.Color := TransColor;
    for j := 0 to AndMask.Height - 1 do
    begin
      OldMaskColor := clRed;
      aBitmap.Canvas.MoveTo( 0, j);
      for i := 0 to AndMask.Width - 1 do
      begin
        NewMaskColor := GetPixel(AndMask.Canvas.Handle, i, j);
        if NewMaskColor <> OldMaskColor then
        begin
          OldMaskColor := NewMaskColor;
          if NewMaskColor = clWhite then
            aBitmap.Canvas.MoveTo(i, j)
          else
            aBitmap.Canvas.LineTo(i, j);
        end;
      end; //for i
      if NewMaskColor = clWhite then
        aBitmap.Canvas.LineTo(AndMask.Width, j);
    end; //for j
    aBitmap.Canvas.MoveTo(0, aBitmap.Height - 1);
    aBitmap.Canvas.LineTo(aBitmap.Width, aBitmap.Height - 1);
  finally
    AndMask.Free;
  end; //try
end;
*}

end.

