unit u_trace;
(*@/// interface *)
interface

(*@/// uses *)
uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Grids,
  icmp;
(*@\\\0000000C03*)

type
(*@///   Tfrm_trace = class(TForm) *)
Tfrm_trace = class(TForm)
  TraceRoute: TTraceRoute;
  lbl_hostname: TLabel;
  edt_hostname: TEdit;
  grid: TStringGrid;
  btn_start: TButton;
  btn_break: TButton;
  procedure btn_startClick(Sender: TObject);
  procedure btn_breakClick(Sender: TObject);
  procedure TraceRouteRoute(sender:TObject; hop:Byte; ip,roundtime:Longint);
  procedure FormCreate(Sender: TObject);
end;
(*@\\\0000000C01*)

var
  frm_trace: Tfrm_trace;
(*@\\\0000000301*)
(*@/// implementation *)
implementation

{$R *.DFM}

uses
  ip_misc;

var
  nr:integer;

(*@/// procedure Tfrm_trace.btn_startClick(Sender: TObject); *)
procedure Tfrm_trace.btn_startClick(Sender: TObject);
begin
  traceroute.hostname:=edt_hostname.text;
  nr:=0;
  grid.rowcount:=0;
  traceroute.action;
  end;
(*@\\\0000000703*)
(*@/// procedure Tfrm_trace.btn_breakClick(Sender: TObject); *)
procedure Tfrm_trace.btn_breakClick(Sender: TObject);
begin
  traceroute.terminate;
  end;
(*@\\\*)
(*@/// procedure Tfrm_trace.TraceRouteRoute(sender: TObject; hop: Byte; ip,roundtime:Longint); *)
procedure Tfrm_trace.TraceRouteRoute(sender: TObject; hop: Byte; ip,roundtime:Longint);
var
  s,t:string;
begin
  grid.rowcount:=nr+1;
  grid.cells[0,nr]:=inttostr(hop)+'.';
  grid.cells[1,nr]:=inttostr(roundtime)+'ms';
  s:=ip2string(ip);
  t:=resolve_hostname(ip);
  if s=t then
    grid.cells[2,nr]:=s
  else
    grid.cells[2,nr]:=t+' ['+s+']';
  inc(nr);
  Application.Processmessages;  (* to give the break button a chance *)
  end;
(*@\\\0032000801000801000516000516*)
(*@/// procedure Tfrm_trace.FormCreate(Sender: TObject); *)
procedure Tfrm_trace.FormCreate(Sender: TObject);
begin
  grid.colwidths[0]:=20;
  grid.colwidths[1]:=40;
  grid.colwidths[2]:=grid.clientwidth-60;
  end;
(*@\\\0000000601*)

(*@\\\000C000F01000101000D01*)
end.
(*@\\\0001000011000301*)
