
{                                                                              }
{ TIB_TransactionLink                                                          }
{                                                                              }

  TIB_TransactionLinkEvent = procedure( Sender: TIB_TransactionLink;
                                        T: TIB_Transaction ) of object;

  TIB_TransactionLink = class( TComponent )
  private
  { Property Access Methods }
    procedure SetIB_Transaction( AValue: TIB_Transaction ); virtual;
    function GetStarted: boolean; virtual;
    function GetTranStatus: TIB_TranStatus; virtual;
  protected
  { Property Storage Fields }
    FIB_Transaction: TIB_Transaction;
    FReceiveFocus: boolean;
  { Event Storage Fields }
    FBeforeAssignment: TIB_TransactionLinkEvent;
    FAfterAssignment:  TIB_TransactionLinkEvent;
    FBeforeStart:      TIB_TransactionLinkEvent;
    FAfterStart:       TIB_TransactionLinkEvent;
    FBeforeSavePoint:  TIB_TransactionLinkEvent;
    FAfterSavePoint:   TIB_TransactionLinkEvent;
    FBeforeCommit:     TIB_TransactionLinkEvent;
    FAfterCommit:      TIB_TransactionLinkEvent;
    FBeforeRollback:   TIB_TransactionLinkEvent;
    FAfterRollback:    TIB_TransactionLinkEvent;
    FBeforeEnd:        TIB_TransactionLinkEvent;
    FAfterEnd:         TIB_TransactionLinkEvent;
    FOnStatusChanged:  TIB_TransactionLinkEvent;
    FOnReceiveFocus:   TIB_TransactionLinkEvent;
  public
  { Inherited Methods }
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
  { Event Dispatch Methods }
    procedure DoBeforeAssignment; virtual;
    procedure DoAfterAssignment; virtual;
    procedure DoBeforeStart; virtual;
    procedure DoAfterStart; virtual;
    procedure DoBeforeSavePoint; virtual;
    procedure DoAfterSavePoint; virtual;
    procedure DoBeforeCommit; virtual;
    procedure DoAfterCommit; virtual;
    procedure DoBeforeRollback; virtual;
    procedure DoAfterRollback; virtual;
    procedure DoBeforeEnd; virtual;
    procedure DoAfterEnd; virtual;
    procedure DoOnStatusChanged; virtual;
    procedure DoReceiveFocus( T: TIB_Transaction ); virtual;
  { Properties }
    property TranStatus: TIB_TranStatus read GetTranStatus;
    property Started: boolean read GetStarted;
  published
  { Properties }
    property IB_Transaction: TIB_Transaction read FIB_Transaction
                                             write SetIB_Transaction;
    property ReceiveFocus: boolean read FReceiveFocus
                                   write FReceiveFocus;
  { Events }
    property BeforeAssignment: TIB_TransactionLinkEvent read FBeforeAssignment
                                                        write FBeforeAssignment;
    property AfterAssignment:  TIB_TransactionLinkEvent read FAfterAssignment
                                                        write FAfterAssignment;
    property BeforeStart:      TIB_TransactionLinkEvent read FBeforeStart
                                                        write FBeforeStart;
    property AfterStart:       TIB_TransactionLinkEvent read FAfterStart
                                                        write FAfterStart;
    property BeforeSavePoint:  TIB_TransactionLinkEvent read FBeforeSavePoint
                                                        write FBeforeSavePoint;
    property AfterSavePoint:   TIB_TransactionLinkEvent read FAfterSavePoint
                                                        write FAfterSavePoint;
    property BeforeCommit:     TIB_TransactionLinkEvent read FBeforeCommit
                                                        write FBeforeCommit;
    property AfterCommit:      TIB_TransactionLinkEvent read FAfterCommit
                                                        write FAfterCommit;
    property BeforeRollback:   TIB_TransactionLinkEvent read FBeforeRollback
                                                        write FBeforeRollback;
    property AfterRollback:    TIB_TransactionLinkEvent read FAfterRollback
                                                        write FAfterRollback;
    property BeforeEnd:        TIB_TransactionLinkEvent read FBeforeEnd
                                                        write FBeforeEnd;
    property AfterEnd:         TIB_TransactionLinkEvent read FAfterEnd
                                                        write FAfterEnd;
    property OnStatusChanged:  TIB_TransactionLinkEvent read FOnStatusChanged
                                                        write FOnStatusChanged;
    property OnReceiveFocus:   TIB_TransactionLinkEvent read FOnReceiveFocus
                                                        write FOnReceiveFocus;
  end; { TIB_TransactionLink }

// IMP_IB_TransactionLink
