
{                                                                              }
{ TIB_Transaction                                                              }
{                                                                              }

  TIB_TranStatus = ( tsNone,
                     tsInactivePending,
                     tsInactive,
                     tsActivePending,
                     tsActive,
                     tsSavePointPending,
                     tsCommitPending,
                     tsRollbackPending );

  TIB_Isolation = ( tiConcurrency,  //  Read-Repeatable   .
                    tiConsistency,  //  Forced-Repeatable .
                    tiCommitted );  //  Read-Committed    .

  EIB_TransactionError = class ( EIB_Error );

  TIB_TransactionEvent = procedure( Sender: TIB_Transaction ) of object;

  TIB_Transaction = class( TComponent )
  private
  { Property Access Methods }
    procedure SetAutoStart( AValue: boolean ); virtual;
    procedure SetAutoCommit( AValue: boolean ); virtual;
    procedure SetTranStatus( AValue: TIB_TranStatus ); virtual;
    function GetPtrHandle: pisc_tr_handle; virtual;
    function GetConnectionCount: integer; virtual;
    function GetConnection( Index: integer ): TIB_Connection; virtual;
    function GetConnectionIndex( Index: TIB_Connection ): integer; virtual;
    function GetPdbHandles( Index: integer ): pisc_db_handle; virtual;
    function GetStatementCount: integer; virtual;
    function GetStatement( Index: integer ): TIB_Statement; virtual;
    function GetDataSetCount: integer; virtual;
    function GetDataSet( Index: integer ): TIB_DataSet; virtual;
    function GetTransactionLinkCount: integer; virtual;
    function GetTransactionLink( Index: integer ): TIB_TransactionLink; virtual;
    procedure SetReadOnly( AValue: boolean ); virtual;
    procedure SetIsolation( AValue: TIB_Isolation ); virtual;
    procedure SetRecVersion( AValue: boolean ); virtual;
    procedure SetLockWait( AValue: boolean ); virtual;
    function GetIB_Session: TIB_Session; virtual;
  protected
  { Utility Storage }
    flag_start_after_load: boolean;
    flag_req_start_after_load: boolean;
    flag_junk_value: integer;
  { Property storage fields }
    FtrHandle: isc_tr_handle;
    FConnectionLinkList: TList;
    FStatementList: TList;
    FDataSetList: TList;
    FTransactionLinkList: TList;
    FTranStatus: TIB_TranStatus;
    FReadOnly: boolean;
    FIsolation: TIB_Isolation;
    FRecVersion: boolean;
    FLockWait: boolean;
    FAutoCommit: boolean;
    FAutoStart: boolean;
    FAutoStartPending: boolean;
    FAnnounceFocus: boolean;
    FPostPendingCount: integer;
    FDDL_PostAll: boolean;
    FDDL_Commit: boolean;
  { Event storage fields }
    FBeforeStart:      TIB_TransactionEvent;
    FAfterStart:       TIB_TransactionEvent;
    FBeforeSavePoint:  TIB_TransactionEvent;
    FAfterSavePoint:   TIB_TransactionEvent;
    FBeforeCommit:     TIB_TransactionEvent;
    FAfterCommit:      TIB_TransactionEvent;
    FBeforeRollback:   TIB_TransactionEvent;
    FAfterRollback:    TIB_TransactionEvent;
    FBeforeEnd:        TIB_TransactionEvent;
    FAfterEnd:         TIB_TransactionEvent;
    FOnGainFocus:      TIB_TransactionEvent;
    FOnLoseFocus:      TIB_TransactionEvent;
  { Inherited Methods }
    procedure Loaded; override;
  { Property Access Methods }
    procedure SetStarted( AValue: boolean ); virtual;
    function GetStarted: boolean; virtual;
  { System Methods }
    function SysStart: boolean; virtual;
    procedure SysBeforeStart; virtual;
    procedure SysFailedStart; virtual;
    procedure SysAfterStart; virtual;
    procedure SysReqAutoStart; virtual;
    procedure SysExecAutoStart; virtual;
    procedure SysStartAfterLoad; virtual;
    procedure SysCheckDataSetsAfterLoad; virtual;
    procedure SysBeforeCommit; virtual;
    procedure SysAfterCommit; virtual;
    procedure SysCommit; virtual;
    procedure SysExecCommit; virtual;
    procedure SysBeforeSavePoint; virtual;
    procedure SysAfterSavePoint; virtual;
    procedure SysSavePoint; virtual;
    procedure SysBeforeRollback; virtual;
    procedure SysAfterRollback; virtual;
    procedure SysRollback; virtual;
    procedure SysExecRollback; virtual;
    procedure SysBeforeEnd; virtual;
    procedure SysAfterEnd; virtual;
    procedure SysPostAll; virtual;
    procedure SysCancelAll; virtual;
    procedure SysClose; virtual;
    procedure SysUnprepareStatements; virtual;
    procedure SysAdjustPostPendingCount( AdjFactor: smallint ); virtual;
    procedure SysBeforeExecDDL; virtual;
    procedure SysAfterExecDDL; virtual;
  { Connection handling stuff }
    procedure SysAddConnection( NewConnection: TIB_Connection ); virtual;
    procedure SysRemoveConnection( OldConnection: TIB_Connection ); virtual;
    procedure SysRemoveAllConnections; virtual;
  { API Level methods }
    procedure API_Start;
    procedure API_Commit;
    procedure API_SavePoint;
    procedure API_Rollback; 
  { Event Dispatch Methods }
    procedure DoBeforeStart; virtual;
    procedure DoAfterStart; virtual;
    procedure DoBeforeCommit; virtual;
    procedure DoAfterCommit; virtual;
    procedure DoBeforeSavePoint; virtual;
    procedure DoAfterSavePoint; virtual;
    procedure DoBeforeRollback; virtual;
    procedure DoAfterRollback; virtual;
    procedure DoBeforeEnd; virtual;
    procedure DoAfterEnd; virtual;
    procedure DoGainFocus; virtual;
    procedure DoLoseFocus; virtual;
  { Linked Event Dispatch Methods }
    procedure DoLinkBeforeStart; virtual;
    procedure DoLinkAfterStart; virtual;
    procedure DoLinkBeforeCommit; virtual;
    procedure DoLinkAfterCommit; virtual;
    procedure DoLinkBeforeSavePoint; virtual;
    procedure DoLinkAfterSavePoint; virtual;
    procedure DoLinkBeforeRollback; virtual;
    procedure DoLinkAfterRollback; virtual;
    procedure DoLinkBeforeEnd; virtual;
    procedure DoLinkAfterEnd; virtual;
    procedure DoLinkOnStatusChanged; virtual;
  { Link event handlers }
    procedure BeforeConnectionConnect     (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); virtual;
    procedure BeforeConnectionDisconnect  (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); virtual;
    procedure AfterConnectionConnect      (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); virtual;
    procedure AfterConnectionDisconnect   (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); virtual;
    procedure OnConnectionConnectedChanged(   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); virtual;
    procedure BeforeConnectionAssignment  ( OldLink: TIB_ConnectionLink;
                                            Old: TIB_Connection ); virtual;
    procedure AfterConnectionAssignment   ( NewLink: TIB_ConnectionLink;
                                            New: TIB_Connection ); virtual;
  { Properties }
    property TransactionLinkCount: integer read GetTransactionLinkCount;
    property TransactionLinks[ Index: integer ]: TIB_TransactionLink
        read GetTransactionLink;
  public
  { Inherited Methods }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  { New methods }
    procedure Start; dynamic;
    procedure Activate; dynamic;
    procedure SavePoint; dynamic;
    procedure Commit; dynamic;
    procedure Rollback; dynamic;
    procedure Close; dynamic;
    function CloseWithConfirm: TModalResult; dynamic;
    procedure PostAll; dynamic;
    procedure CancelAll; dynamic;
    procedure SetFocus; dynamic;
    procedure UpdateStatus; dynamic;
  { Properties }
    property trHandle: isc_tr_handle   read FtrHandle;
    property PtrHandle: pisc_tr_handle read GetPtrHandle;
    property TranStatus: TIB_TranStatus read FTranStatus;
    property ConnectionCount: integer read GetConnectionCount;
    property Connections[Index: integer]: TIB_Connection read GetConnection;
    property ConnectionIndex[Index: TIB_Connection]: integer
        read GetConnectionIndex;
    property StatementCount: integer read GetStatementCount;
    property Statements[Index: integer]: TIB_Statement read GetStatement;
    property DataSetCount: integer read GetDataSetCount;
    property DataSets[Index: integer]: TIB_DataSet read GetDataSet;
    property PdbHandles[Index: integer]: pisc_db_handle read GetPdbHandles;
    property PostPendingCount: integer read FPostPendingCount;
    property IB_Session: TIB_Session read GetIB_Session; 
  published
  { Properties }
    property Started: boolean read GetStarted write SetStarted default false;
    property AutoCommit: boolean read FAutoCommit write SetAutoCommit
                                                                  default false;
    property AutoStart: boolean read FAutoStart write SetAutoStart
                                                                  default false;
    property AutoStartPending: boolean read FAutoStartPending;
    property DDL_PostAll: boolean read FDDL_PostAll write FDDL_PostAll
                                                                  default false;
    property DDL_Commit: boolean read FDDL_Commit write FDDL_Commit
                                                                  default false;
  { New Properties }
    property AnnounceFocus: boolean read FAnnounceFocus
                                    write FAnnounceFocus
                                    default false;
    property ReadOnly: boolean read FReadOnly
                               write SetReadOnly
                               default false;
    property Isolation: TIB_Isolation read FIsolation
                                      write SetIsolation
                                      default tiConcurrency;
    property RecVersion: boolean read FRecVersion
                                 write SetRecVersion
                                 default false;
    property LockWait: boolean read FLockWait
                               write SetLockWait
                               default true;
{------------------------------------------------------------------------------}
    property _TransactionLinkCount: integer read GetTransactionLinkCount
                                            write flag_junk_value
                                            stored false;
    property _ConnectionCount: integer read GetConnectionCount
                                       write flag_junk_value
                                       stored false;
    property _StatementCount: integer read GetStatementCount
                                      write flag_junk_value
                                      stored false;
    property _DataSetCount: integer read GetDataSetCount
                                    write flag_junk_value
                                    stored false;
{------------------------------------------------------------------------------}

  { New Events }
    property BeforeStart:     TIB_TransactionEvent read FBeforeStart
                                                   write FBeforeStart;
    property AfterStart:      TIB_TransactionEvent read FAfterStart
                                                   write FAfterStart;
    property BeforeCommit:    TIB_TransactionEvent read FBeforeCommit
                                                   write FBeforeCommit;
    property AfterCommit:     TIB_TransactionEvent read FAfterCommit
                                                   write FAfterCommit;
    property BeforeSavePoint: TIB_TransactionEvent read FBeforeSavePoint
                                                   write FBeforeSavePoint;
    property AfterSavePoint:  TIB_TransactionEvent read FAfterSavePoint
                                                   write FAfterSavePoint;
    property BeforeRollback:  TIB_TransactionEvent read FBeforeRollback
                                                   write FBeforeRollback;
    property AfterRollback:   TIB_TransactionEvent read FAfterRollback
                                                   write FAfterRollback;
    property BeforeEnd:       TIB_TransactionEvent read FBeforeEnd
                                                   write FBeforeEnd;
    property AfterEnd:        TIB_TransactionEvent read FAfterEnd
                                                   write FAfterEnd;
    property OnGainFocus:     TIB_TransactionEvent read FOnGainFocus
                                                   write FOnGainFocus;
    property OnLoseFocus:     TIB_TransactionEvent read FOnLoseFocus
                                                   write FOnLoseFocus;
  end; { TIB_Transaction }

  TIB_TransactionSingle = class( TIB_Transaction )
  protected
    function GetIB_Connection: TIB_Connection; virtual;
    procedure SetIB_Connection( AValue: TIB_Connection ); virtual;
    procedure SysExecAutoStart; override;
  published
    property IB_Connection: TIB_Connection read GetIB_Connection
                                           write SetIB_Connection;
  end;

  TIB_TransactionDouble = class( TIB_Transaction )
  protected
    function GetIB_Connection1: TIB_Connection; virtual;
    procedure SetIB_Connection1( AValue: TIB_Connection ); virtual;
    function GetIB_Connection2: TIB_Connection; virtual;
    procedure SetIB_Connection2( AValue: TIB_Connection ); virtual;
    procedure SysExecAutoStart; override;
    procedure SysBeforeStart; override;
  published
    property IB_Connection1: TIB_Connection read GetIB_Connection1
                                            write SetIB_Connection1;
    property IB_Connection2: TIB_Connection read GetIB_Connection2
                                            write SetIB_Connection2;
  end;

  TIB_TransactionMultiple = class( TIB_Transaction )
  public
    procedure AddConnection( New: TIB_Connection ); virtual;
    procedure RemoveConnection( Old: TIB_Connection ); virtual;
  end;
  
// IMP_IB_Transaction
