
{                                                                              }
{ TIB_StatementLink                                                            }
{                                                                              }

  TIB_StmtLinkEvent = procedure ( Sender: TIB_StatementLinkBase;
                                       Statement: TIB_Statement ) of object;

  TIB_ColLinkEvent = procedure ( Sender: TIB_StatementLinkBase;
                                    Statement: TIB_Statement;
                                    Column: TIB_Column ) of object;

  TIB_StatementLinkBase = class( TComponent )
  private
    function GetPrepared: boolean;
    function GetActive: boolean;
    function GetStatementType: TIB_StatementType;
  protected
  { Property Storage Fields }
    FIB_Statement: TIB_Statement;
  { Event Storage Fields }
    FBeforeAssignment: TIB_StmtLinkEvent;
    FAfterAssignment: TIB_StmtLinkEvent;
    FOnAllocatedChanged: TIB_StmtLinkEvent;
    FBeforePrepare: TIB_StmtLinkEvent;
    FAfterPrepare: TIB_StmtLinkEvent;
    FBeforeUnprepare: TIB_StmtLinkEvent;
    FAfterUnprepare: TIB_StmtLinkEvent;
    FOnPreparedChanged: TIB_StmtLinkEvent;
    FBeforeExecute: TIB_StmtLinkEvent;
    FAfterExecute: TIB_StmtLinkEvent;
    FBeforeExecDDL: TIB_StmtLinkEvent;
    FAfterExecDDL: TIB_StmtLinkEvent;
    FBeforeExecDML: TIB_StmtLinkEvent;
    FAfterExecDML: TIB_StmtLinkEvent;
    FOnActiveChanged: TIB_StmtLinkEvent;
    FOnInputDataChanged: TIB_ColLinkEvent;
    FOnInputUpdateData: TIB_ColLinkEvent;
    FOnInputStateChanged: TIB_StmtLinkEvent;
    FOnOutputDataChanged: TIB_ColLinkEvent;
    FOnOutputUpdateData: TIB_ColLinkEvent;
    FOnOutputStateChanged: TIB_StmtLinkEvent;
    FOnPrepareSQL: TIB_StmtLinkEvent;
  { Property Access Methods }
    procedure SetIB_Statement( AValue: TIB_Statement ); virtual;
  { System Methods }
    procedure SysPrepareSQL; virtual;
    procedure SysBeforeUpdateDescriptors; virtual;
    procedure SysAfterUpdateDescriptors; virtual;
  { Event Dispatch Methods }
    procedure DoPrepareSQL; virtual;
    procedure DoBeforeAssignment; virtual;
    procedure DoAfterAssignment; virtual;
    procedure DoAllocatedChanged; virtual;
    procedure DoBeforePrepare; virtual;
    procedure DoAfterPrepare; virtual;
    procedure DoBeforeUnprepare; virtual;
    procedure DoAfterUnprepare; virtual;
    procedure DoPreparedChanged; virtual;
    procedure DoActiveChanged; virtual;
    procedure DoInputRowStateChanged; virtual;
    procedure DoInputRowUpdateData( Column: TIB_Column ); virtual;
    procedure DoInputRowDataChanged( Column: TIB_Column ); virtual;
    procedure DoOutputRowStateChanged; virtual;
    procedure DoOutputRowUpdateData( Column: TIB_Column ); virtual;
    procedure DoOutputRowDataChanged( Column: TIB_Column ); virtual;
    procedure DoBeforeExecute; virtual;
    procedure DoAfterExecute; virtual;
    procedure DoBeforeExecDDL; virtual;
    procedure DoAfterExecDDL; virtual;
    procedure DoBeforeExecDML; virtual;
    procedure DoAfterExecDML; virtual;
  public
  { Inherited Methods }
    destructor Destroy; override;
  { Properties }
    property Prepared: boolean read GetPrepared;
    property Active: boolean read GetActive;
    property StatementType: TIB_StatementType read GetStatementType;
    property IB_Statement: TIB_Statement read FIB_Statement
                                         write SetIB_Statement;
  { Events }
    property BeforeAssignment: TIB_StmtLinkEvent read FBeforeAssignment
                                                 write FBeforeAssignment;
    property AfterAssignment: TIB_StmtLinkEvent read FAfterAssignment
                                                write FAfterAssignment;
    property OnAllocatedChanged: TIB_StmtLinkEvent read FOnAllocatedChanged
                                                   write FOnAllocatedChanged;
    property BeforePrepare: TIB_StmtLinkEvent read FBeforePrepare
                                              write FBeforePrepare;
    property AfterPrepare: TIB_StmtLinkEvent read FAfterPrepare
                                             write FAfterPrepare;
    property BeforeUnprepare: TIB_StmtLinkEvent read FBeforeUnprepare
                                                write FBeforeUnprepare;
    property AfterUnprepare: TIB_StmtLinkEvent read FAfterUnprepare
                                               write FAfterUnprepare;
    property OnPreparedChanged: TIB_StmtLinkEvent read FOnPreparedChanged
                                                  write FOnPreparedChanged;
    property OnPrepareSQL: TIB_StmtLinkEvent read FOnPrepareSQL
                                             write FOnPrepareSQL;
    property BeforeExecute: TIB_StmtLinkEvent read FBeforeExecute
                                              write FBeforeExecute;
    property AfterExecute: TIB_StmtLinkEvent read FAfterExecute
                                             write FAfterExecute;
    property BeforeExecDDL: TIB_StmtLinkEvent read FBeforeExecDDL
                                              write FBeforeExecDDL;
    property AfterExecDDL: TIB_StmtLinkEvent read FAfterExecDDL
                                             write FAfterExecDDL;
    property BeforeExecDML: TIB_StmtLinkEvent read FBeforeExecDML
                                              write FBeforeExecDML;
    property AfterExecDML: TIB_StmtLinkEvent read FAfterExecDML
                                             write FAfterExecDML;
    property OnActiveChanged: TIB_StmtLinkEvent read FOnActiveChanged
                                                write FOnActiveChanged;
    property OnInputDataChanged: TIB_ColLinkEvent read FOnInputDataChanged
                                                  write FOnInputDataChanged;
    property OnInputUpdateData: TIB_ColLinkEvent read FOnInputUpdateData
                                                 write FOnInputUpdateData;
    property OnInputStateChanged: TIB_StmtLinkEvent read FOnInputStateChanged
                                                    write FOnInputStateChanged;
    property OnOutputDataChanged: TIB_ColLinkEvent read FOnOutputDataChanged
                                                   write FOnOutputDataChanged;
    property OnOutputUpdateData: TIB_ColLinkEvent read FOnOutputUpdateData
                                                  write FOnOutputUpdateData;
    property OnOutputStateChanged: TIB_StmtLinkEvent read FOnOutputStateChanged
                                                    write FOnOutputStateChanged;
  end; { TIB_StatementLink }

  TIB_StatementLink = class( TIB_StatementLinkBase )
  published
  { Properties }
    property IB_Statement;
  { Events }
    property BeforeAssignment;
    property AfterAssignment;
    property OnAllocatedChanged;
    property BeforePrepare;
    property AfterPrepare;
    property BeforeUnprepare;
    property AfterUnprepare;
    property OnPreparedChanged;
    property OnActiveChanged;
    property OnInputDataChanged;
    property OnInputUpdateData;
    property OnInputStateChanged;
    property OnOutputDataChanged;
    property OnOutputUpdateData;
    property OnOutputStateChanged;
    property OnPrepareSQL;
    property BeforeExecute;
    property AfterExecute;
    property BeforeExecDDL;
    property AfterExecDDL;
    property BeforeExecDML;
    property AfterExecDML;
  end; { TIB_StatementLink }

// INT_IB_Statement
// IMP_IB_Statement
// IMP_IB_StatementLink
