
{                                                                              }
{ TIB_Statement                                                                }
{                                                                              }

  EIB_StatementError = class( EIB_Error );

  TIB_StatementType = ( stUnknown,
                        stSelect,
                        stInsert,
                        stUpdate,
                        stDelete,
                        stDDL,
                        stGetSegment,
                        stPutSegment,
                        stExecProcedure,
                        stStartTrans,
                        stCommit,
                        stRollback,
                        stSelectForUpdate,
                        stSetGenerator );

  TIB_StatementEvent = procedure( Sender: TIB_Statement ) of object;

  TIB_RowStateEvent = procedure( Sender: TIB_Statement;
                                 Row: TIB_Row ) of object;

  TIB_RowType  = ( rtInput ,rtOutput );
  TIB_RowState = ( rsNone, rsUnmodified, rsModified );

  TIB_Statement = class( TComponent )
  private
  { Property Access Methods }
    function GetPdbHandle: pisc_db_handle;
    function GetPtrHandle: pisc_tr_handle;
    function GetPstHandle: pisc_stmt_handle;
    function GetStatementType: TIB_StatementType;
    function GetStatementPlan: string;
    function GetStatementLinkCount: integer;
    function GetStatementLinks( Index: integer ):TIB_StatementLinkBase;
    function GetSQLHistoryCount: integer;
    function GetSQLHistory( Index: integer ): TStrings;
    procedure SetSQLHistoryRef( AValue: integer );
    function GetSQLHistoryRef: integer;
    function GetInputCount: smallint;
    function GetInputRowState: TIB_RowState;
    function GetOutputCount: smallint;
    function GetOutputRowState: TIB_RowState;
  protected
  { Property storage fields }
    FstHandle: isc_stmt_handle;
//  FIB_Connection: TIB_Connection;         // For an internal instance.
    FIB_Transaction: TIB_TransactionSingle; // For an internal instance.
    FIB_ConnectionLink: TIB_ConnectionLink;
    FIB_TransactionLink: TIB_TransactionLink;
    FIB_StatementLinkList: TList;
    FIB_Session: TIB_Session;
    FEnableLinkLevel: integer;
    FSQL: TStrings;
    FSQL_Text: string;
    FSysParamNames: TStrings;
    FOldParamValues: TStrings;
    FSQLHistoryList: TStrings;
    FKeepSQLHistory: boolean;
    FSQLHistoryRef: integer;
    FStatementType: TIB_StatementType;
    FStatementPlan: string;
    FPrepared: boolean;
    FSQLValid: boolean;
    FInputRow: TIB_Row;
    FInputCount: smallint;
    FCursorOutputRow: TIB_Row;
    FCursorOutputCount: smallint;
    FActive: boolean;
  { Optimization/System Flags }
    flag_statement_type_invalid: boolean;
    flag_statement_plan_invalid: boolean;
    flag_prepare_after_load: boolean;
    flag_junk_value: integer;
  { Event storage fields }
    FBeforeAllocate: TIB_StatementEvent;
    FAfterAllocate: TIB_StatementEvent;
    FBeforeDeallocate: TIB_StatementEvent;
    FAfterDeallocate: TIB_StatementEvent;
    FBeforePrepare: TIB_StatementEvent;
    FAfterPrepare: TIB_StatementEvent;
    FBeforeUnprepare: TIB_StatementEvent;
    FAfterUnprepare: TIB_StatementEvent;
    FBeforeExecute: TIB_StatementEvent;
    FAfterExecute: TIB_StatementEvent;
    FBeforeExecDDL: TIB_StatementEvent;
    FAfterExecDDL: TIB_StatementEvent;
    FBeforeExecDML: TIB_StatementEvent;
    FAfterExecDML: TIB_StatementEvent;
    FOnAllocatedChanged: TIB_StatementEvent;
    FOnPrepareSQL: TIB_StatementEvent;
    FOnPreparedChanged: TIB_StatementEvent;
    FOnActiveChanged: TIB_StatementEvent;
    FOnInputRowStateChanged: TIB_RowStateEvent;
    FOnOutputRowStateChanged: TIB_RowStateEvent;
  { Property Access Methods }
    function GetAllocated: boolean; virtual;
    procedure SetAllocated( Value: boolean ); virtual;
    procedure SetPrepared( Value: boolean ); virtual;
    procedure SetActive( Value: boolean ); virtual;
    function GetActive: boolean; virtual;
    procedure SetIB_Connection( AValue: TIB_Connection ); virtual;
    function GetIB_Connection: TIB_Connection; virtual;
    procedure SetIB_Transaction( AValue: TIB_Transaction ); virtual;
    function GetIB_Transaction: TIB_Transaction; virtual;
    procedure SetSQL( AValue: TStrings ); virtual;
    procedure OnSQLChange( Sender: TObject ); virtual;
    function GetInputRow( Index: smallint ): TIB_Column; virtual;
    function GetOutputRow: TIB_Row; virtual;
  { Special Record data access methods }
    procedure SetInputRow( AValue: TIB_Row ); virtual;
    procedure SetCursorOutputRow( AValue: TIB_Row ); virtual;
    procedure SetOutputRow( AValue: TIB_Row ); virtual;
  { Event Dispatch Methods }
    procedure DoBeforeAllocate; virtual;
    procedure DoAfterAllocate; virtual;
    procedure DoBeforeDeallocate; virtual;
    procedure DoAfterDeallocate; virtual;
    procedure DoBeforePrepare; virtual;
    procedure DoAfterPrepare; virtual;
    procedure DoBeforeUnprepare; virtual;
    procedure DoAfterUnprepare; virtual;
    procedure DoBeforeExecute; virtual;
    procedure DoAfterExecute; virtual;
    procedure DoBeforeExecDDL; virtual;
    procedure DoAfterExecDDL; virtual;
    procedure DoBeforeExecDML; virtual;
    procedure DoAfterExecDML; virtual;
    procedure DoAllocatedChanged; virtual;
    procedure DoPreparedChanged; virtual;
    procedure DoPrepareSQL; virtual;
    procedure DoActiveChanged; virtual;
  { Link Event Dispatch Methods }
    procedure DoLinkBeforePrepare;
    procedure DoLinkAfterPrepare;
    procedure DoLinkBeforeUnprepare;
    procedure DoLinkAfterUnprepare;
    procedure DoLinkBeforeExecute;
    procedure DoLinkAfterExecute;
    procedure DoLinkBeforeExecDDL;
    procedure DoLinkAfterExecDDL;
    procedure DoLinkBeforeExecDML;
    procedure DoLinkAfterExecDML;
    procedure DoLinkPrepareSQL;
    procedure DoLinkBeforeUpdateDescriptors;
    procedure DoLinkAfterUpdateDescriptors;
    procedure DoLinkPreparedChanged;
    procedure DoLinkActiveChanged;
    procedure DoLinkInputRowStateChanged;
    procedure DoLinkInputRowDataChanged( AColumn: TIB_Column );
    procedure DoLinkInputRowUpdateData( AColumn: TIB_Column );
    procedure DoLinkOutputRowStateChanged;
    procedure DoLinkOutputRowDataChanged( AColumn: TIB_Column );
    procedure DoLinkOutputRowUpdateData( AColumn: TIB_Column );
  { System Methods }
    function SysCheckConnection( RequestConnect: boolean ): boolean; virtual;
    function SysCheckTransaction( RequestStart: boolean ): boolean; virtual;
    procedure SysPrepareAfterLoad; virtual;
    function SysAllocate: boolean; virtual;
    procedure SysDeallocate; virtual;
    function SysPrepare: boolean; virtual;
    procedure SysExecPrepare; virtual;
    procedure SysClose; virtual;
    procedure SysUnprepare; virtual;
    procedure SysBeforePrepare; virtual;
    procedure SysAfterPrepare; virtual;
    procedure SysBeforeUnprepare; virtual;
    procedure SysAfterUnprepare; virtual;
    procedure SysExecute; virtual;
    procedure SysBeforeExecute; virtual;
    procedure SysAfterExecute; virtual;
    procedure SysBeforeExecuteForOutput; virtual;
    procedure SysAfterExecuteForOutput; virtual;
    procedure SysExecuteImmediate( Statement: string; Input: PXSQLDA ); virtual;
    procedure SysExecImmed2( Statement: string; Input,
                                                Output: PXSQLDA ); virtual;
    procedure SysAllocatedChanged; virtual;
    procedure SysPreparedChanged; virtual;
    procedure SysActiveChanged; virtual;
    procedure SysUpdateStatementType; virtual;
    procedure SysUpdateStatementPlan; virtual;
    procedure SysPrepareSQL; virtual;
    procedure SysBeforeUpdateDescriptors; virtual;
    procedure SysAfterUpdateDescriptors; virtual;
    procedure SysUpdateDescriptors; virtual;
    procedure SysExecUnknown; virtual;
    procedure SysExecSetGenerator; virtual;
    procedure SysExecDML; virtual;
    procedure SysExecStartTrans; virtual;
    procedure SysExecCommit; virtual;
    procedure SysExecRollback; virtual;
    procedure SysExecDDL; virtual;
    procedure SysExecSelect; virtual;
    procedure SysExecGetSegment; virtual;
    procedure SysExecPutSegment; virtual;
    procedure SysExecExecProcedure; virtual;
    procedure SysClearSQLHistory; virtual;
    procedure SysAddSQLHistory; virtual;
    procedure SysPrepareFailed; virtual;
    function SysGetRawSQL: string; virtual;
  { Row alteration event handlers }
    procedure SysInputRowStateChanged( Sender: TIB_Row ); virtual;
    procedure SysBeforeInputRowDataChange( Sender: TIB_Row;
                                           AColumn: TIB_Column ); virtual;
    procedure SysAfterInputRowDataChange( Sender: TIB_Row;
                                          AColumn: TIB_Column ); virtual;
    procedure SysCursorOutputRowStateChanged( Sender: TIB_Row ); virtual;
    procedure SysBeforeCursorOutputDataChange( Sender: TIB_Row;
                                               AColumn: TIB_Column ); virtual;
    procedure SysAfterCursorOutputDataChange( Sender: TIB_Row;
                                              AColumn: TIB_Column ); virtual;
    procedure SysOutputRowStateChanged( Sender: TIB_Row ); virtual;
    procedure SysBeforeOutputDataChange( Sender: TIB_Row;
                                         AColumn: TIB_Column ); virtual;
    procedure SysAfterOutputDataChange( Sender: TIB_Row;
                                        AColumn: TIB_Column ); virtual;
  { Connection Link event handlers }
    procedure BeforeConnectionAssignment  ( OldLink: TIB_ConnectionLink;
                                            Old: TIB_Connection ); dynamic;
    procedure AfterConnectionAssignment   ( NewLink: TIB_ConnectionLink;
                                            New: TIB_Connection ); dynamic;
    procedure BeforeConnectionConnect     (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); dynamic;
    procedure BeforeConnectionDisconnect  (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); dynamic;
    procedure AfterConnectionConnect      (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); dynamic;
    procedure AfterConnectionDisconnect   (   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); dynamic;
    procedure OnConnectionConnectedChanged(   CLink: TIB_ConnectionLink;
                                              C: TIB_Connection ); dynamic;
  { Transaction Link event handlers }
    procedure BeforeTransactionAssignment( TLink: TIB_TransactionLink;
                                             Old: TIB_Transaction ); dynamic;
    procedure AfterTransactionAssignment ( TLink: TIB_TransactionLink;
                                             New: TIB_Transaction ); dynamic;
    procedure BeforeTransactionStart     ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure AfterTransactionStart      ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure BeforeTransactionEnd       ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure AfterTransactionEnd        ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure BeforeTransactionCommit    ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure AfterTransactionCommit     ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure BeforeTransactionRollback  ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure AfterTransactionRollback   ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure BeforeTransactionSavePoint ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure AfterTransactionSavePoint  ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
    procedure OnTransactionStatusChanged ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); dynamic;
  { System Methods }
    procedure API_Allocate; 
    procedure API_Deallocate; 
    function API_Prepare(     Text: PChar;
                          var InVar,
                              OutVar: smallint ): longint; 
    procedure API_Execute; 
    procedure API_Execute2; 
    procedure API_ExecuteImmediate( Statement:string; Input: PXSQLDA ); 
    procedure API_ExecImmed2( Statement: string; Input,
                                                 OutPut: PXSQLDA ); 
    procedure API_DSQL_SQL_INFO( var Items: array of Char;
                                 var Buffer: array of Char); 
  { Inherited methods }
    procedure Loaded; override;
  { Stored Internal Property Methods }
    procedure DefineProperties( Filer: TFiler ); override;
    procedure ReadOldParamData( Reader: TReader );
    procedure WriteOldParamData( Writer: TWriter );
  { Properties }
    property StatementLinkCount: integer read GetStatementLinkCount;
    property StatementLinks[ Index: integer ]: TIB_StatementLinkBase
        read GetStatementLinks;
    property SQLValid: boolean read FSQLValid;
  { Properties to be published }
    property SQL: TStrings read FSQL write SetSQL;
    property SQLHistoryCount: integer read GetSQLHistoryCount;
    property SQLHistory[ Index: integer ]: TStrings read GetSQLHistory;
    property SQLHistoryRef: integer read GetSQLHistoryRef
                                    write SetSQLHistoryRef;
    property KeepSQLHistory: boolean read FKeepSQLHistory
                                     write FKeepSQLHistory
                                     default false;
    property CursorOutputRow: TIB_Row read FCursorOutputRow;
    property CursorOutputCount: smallint read FCursorOutputCount;
  { Events to be published }
    property OnAllocatedChanged: TIB_StatementEvent read FOnAllocatedChanged
                                                    write FOnAllocatedChanged;
    property OnPrepareSQL: TIB_StatementEvent read FOnPrepareSQL
                                                 write FOnPrepareSQL;
    property OnPreparedChanged:  TIB_StatementEvent read FOnPreparedChanged
                                                    write FOnPreparedChanged;
    property OnActiveChanged: TIB_StatementEvent read FOnActiveChanged
                                                 write FOnActiveChanged;
    property OnInputRowStateChanged: TIB_RowStateEvent
        read FOnInputRowStateChanged                                                 
       write FOnInputRowStateChanged;                                                 
    property OnOutputRowStateChanged: TIB_RowStateEvent
        read FOnOutputRowStateChanged
       write FOnOutputRowStateChanged;
  { Events }
    property BeforeAllocate:   TIB_StatementEvent read FBeforeAllocate
                                                  write FBeforeAllocate;
    property AfterAllocate:    TIB_StatementEvent read FAfterAllocate
                                                  write FAfterAllocate;
    property BeforeDeallocate: TIB_StatementEvent read FBeforeDeallocate
                                                  write FBeforeDeallocate;
    property AfterDeallocate:  TIB_StatementEvent read FAfterDeallocate
                                                  write FAfterDeallocate;
    property BeforePrepare:    TIB_StatementEvent read FBeforePrepare
                                                  write FBeforePrepare;
    property AfterPrepare:     TIB_StatementEvent read FAfterPrepare
                                                  write FAfterPrepare;
    property BeforeUnprepare:  TIB_StatementEvent read FBeforeUnprepare
                                                  write FBeforeUnprepare;
    property AfterUnprepare:   TIB_StatementEvent read FAfterUnprepare
                                                  write FAfterUnprepare;
    property BeforeExecute:    TIB_StatementEvent read FBeforeExecute
                                                  write FBeforeExecute;
    property AfterExecute:     TIB_StatementEvent read FAfterExecute
                                                  write FAfterExecute;
    property BeforeExecDDL:    TIB_StatementEvent read FBeforeExecDDL
                                                  write FBeforeExecDDL;
    property AfterExecDDL:     TIB_StatementEvent read FAfterExecDDL
                                                  write FAfterExecDDL;
    property BeforeExecDML:    TIB_StatementEvent read FBeforeExecDML
                                                  write FBeforeExecDML;
    property AfterExecDML:     TIB_StatementEvent read FAfterExecDML
                                                  write FAfterExecDML;
  public
  { Inherited Methods }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  { System Methods }
    procedure Allocate; virtual;
    procedure Deallocate; virtual;
    procedure Prepare; virtual;
    procedure Unprepare; virtual;
    procedure Execute; virtual;
    procedure ExecuteImmediate( Statement: string; Input: PXSQLDA ); virtual;
    procedure ExecImmed2( Statement: string; Input, Output: PXSQLDA ); virtual;
    procedure Invalidate; dynamic;
    procedure DisableLinks; dynamic;
    procedure EnableLinks; dynamic;
  { New Properties }
    property IB_Session: TIB_Session read FIB_Session; 
    property Allocated: boolean read GetAllocated write SetAllocated;
    property Prepared: boolean read FPrepared write SetPrepared default false;
    property Active: boolean read GetActive write SetActive default false;
    property StatementType: TIB_StatementType read GetStatementType;
    property StatementPlan: string read GetStatementPlan;
    property OutputRow: TIB_Row read GetOutputRow;
    property OutputCount: smallint read GetOutputCount;
    property InputCount: smallint read GetInputCount;
    property InputRowState: TIB_RowState read GetInputRowState;
    property OutputRowState: TIB_RowState read GetOutputRowState;
    property stHandle: isc_stmt_handle read FstHandle;
    property PstHandle: pisc_stmt_handle read GetPstHandle;
    property PdbHandle: pisc_db_handle read GetPdbHandle;
    property PtrHandle: pisc_tr_handle read GetPtrHandle;
  published
  { Published properties }
{------------------------------------------------------------------------------}
    property _StatementLinkCount: integer read GetStatementLinkCount
                                          write flag_junk_value
                                          stored false;
{------------------------------------------------------------------------------}
    property IB_Connection: TIB_Connection read GetIB_Connection
                                           write SetIB_Connection;
    property IB_Transaction: TIB_Transaction read GetIB_Transaction
                                             write SetIB_Transaction;
    property InputRow: TIB_Row read FInputRow write SetInputRow;
  end; { TIB_Statement }

  TIB_DSQL = class( TIB_Statement )
  protected
    procedure SysAfterExecuteForOutput; override;
    procedure SysAfterExecute; override;
  public
    property SQLHistoryRef;
    property SQLHistoryCount;
    property SQLHistory;
  published
  { Properties }
    property SQL;
    property KeepSQLHistory;
  { Events }
    property OnAllocatedChanged;
    property OnPreparedChanged;
    property OnActiveChanged;
    property BeforeAllocate;
    property AfterAllocate;
    property BeforeDeallocate;
    property AfterDeallocate;
    property BeforePrepare;
    property AfterPrepare;
    property BeforeUnprepare;
    property AfterUnprepare;
    property BeforeExecute;
    property AfterExecute;
    property BeforeExecDDL;
    property AfterExecDDL;
    property BeforeExecDML;
    property AfterExecDML;
  end;

// IMP_IB_Statement
