
{                                                                              }
{ TIB_SessionLink                                                              }
{                                                                              }

  TIB_SessionLinkEvent = procedure( Sender: TIB_SessionLink;
                                    IB_Session: TIB_Session ) of object;

  TIB_SessionLink = class( TComponent )
  private
  { Property Access Methods }
    procedure SetIB_Session( AValue: TIB_Session ); virtual;
    function GetAttached: boolean; virtual;
  protected
  { Property Storage Fields }
    FIB_Session: TIB_Session;
  { Event Storage Fields }
    FBeforeAssignment: TIB_SessionLinkEvent;
    FAfterAssignment: TIB_SessionLinkEvent;
    FBeforeAttach: TIB_SessionLinkEvent;
    FAfterAttach: TIB_SessionLinkEvent;
    FBeforeDetach: TIB_SessionLinkEvent;
    FAfterDetach: TIB_SessionLinkEvent;
  { Event dispatch methods }
    procedure DoBeforeAssignment; virtual;
    procedure DoAfterAssignment; virtual;
    procedure DoBeforeAttach; virtual;
    procedure DoAfterAttach; virtual;
    procedure DoBeforeDetach; virtual;
    procedure DoAfterDetach; virtual;
  public
  { Inherited Methods }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  { Properties }
    property Attached: boolean read GetAttached;
  published
  { Properties }
    property IB_Session: TIB_Session read FIB_Session
                                           write SetIB_Session;
  { Events }
    property BeforeAssignment: TIB_SessionLinkEvent
        read FBeforeAssignment
       write FBeforeAssignment;
    property AfterAssignment: TIB_SessionLinkEvent
        read FAfterAssignment
       write FAfterAssignment;
    property BeforeAttach: TIB_SessionLinkEvent
        read FBeforeAttach
       write FBeforeAttach;
    property AfterAttach: TIB_SessionLinkEvent
        read FAfterAttach
       write FAfterAttach;
    property BeforeDetach: TIB_SessionLinkEvent
        read FBeforeDetach
       write FBeforeDetach;
    property AfterDetach: TIB_SessionLinkEvent
        read FAfterDetach
       write FAfterDetach;
  end; { TIB_SessionLink }

// IMP_IB_SessionLink
