
{                                                                              }
{ TIB_SESSION                                                                  }
{                                                                              }

TIB_SessionEvent = procedure( Sender: TIB_Session ) of object;

TIB_Session = class( TComponent )
  private
    function GetAttached: boolean;
    function GetSessionLinkCount: integer;
    function GetSessionLink( Index: integer ): TIB_SessionLink; 
  protected
  { General storage }
    GDS_Handle: THandle;
    FIB_SessionLinkList: TList;
  { Event Storage }
    FOnException:  TIB_ErrorEvent;
    FBeforeAttach: TIB_SessionEvent;
    FAfterAttach:  TIB_SessionEvent;
    FBeforeDetach: TIB_SessionEvent;
    FAfterDetach:  TIB_SessionEvent;
  { Link handling methods }
    procedure AddSessionLink   ( NewLink: TIB_SessionLink );
    procedure RemoveSessionLink( OldLink: TIB_SessionLink ); 
  { Event and Link management }
    procedure DoBeforeAttach; virtual;
    procedure DoAfterAttach; virtual;
    procedure DoBeforeDetach; virtual;
    procedure DoAfterDetach; virtual;
    procedure DoLinkBeforeAttach; virtual;
    procedure DoLinkAfterAttach; virtual;
    procedure DoLinkBeforeDetach; virtual;
    procedure DoLinkAfterDetach; virtual;
  public
  { Status storage }
    errcode: isc_status;
    status: status_vector;
  { Method Storage }
    isc_attach_database:          Tisc_attach_database;
    isc_detach_database:          Tisc_detach_database;
    isc_drop_database:            Tisc_drop_database;
    isc_create_database:          Tisc_create_database;
    isc_attach_service:           Tisc_attach_service;
    isc_detach_service:           Tisc_detach_service;
    isc_query_service:            Tisc_query_service;
    isc_array_gen_sdl:            Tisc_array_gen_sdl;
    isc_array_get_slice:          Tisc_array_get_slice;
    isc_array_lookup_bounds:      Tisc_array_lookup_bounds;
    isc_array_lookup_desc:        Tisc_array_lookup_desc;
    isc_array_set_desc:           Tisc_array_set_desc;
    isc_array_put_slice:          Tisc_array_put_slice;
    isc_blob_default_desc:        Tisc_blob_default_desc;
    isc_blob_gen_bpb:             Tisc_blob_gen_bpb;
    isc_blob_info:                Tisc_blob_info;
    isc_blob_lookup_desc:         Tisc_blob_lookup_desc;
    isc_blob_set_desc:            Tisc_blob_set_desc;
    isc_cancel_blob:              Tisc_cancel_blob;
    isc_cancel_events:            Tisc_cancel_events;
    isc_close_blob:               Tisc_close_blob;
    isc_commit_retaining:         Tisc_commit_retaining;
    isc_commit_transaction:       Tisc_commit_transaction;
  //isc_compile_request:          Tisc_compile_request;
  //isc_compile_request2:         Tisc_compile_request2;
    isc_create_blob:              Tisc_create_blob;
    isc_create_blob2:             Tisc_create_blob2;
    isc_database_info:            Tisc_database_info;
  //isc_ddl:                      Tisc_ddl;
    isc_decode_date:              Tisc_decode_date;
    isc_encode_date:              Tisc_encode_date;
    isc_event_block:              Tisc_event_block;
    isc_event_counts:             Tisc_event_counts;
  //isc_expand_dpb:               Tisc_expand_dpb;
  //isc_modify_dpb:               Tisc_modify_dpb;
    isc_free:                     Tisc_free;
    isc_get_segment:              Tisc_get_segment;
    isc_get_slice:                Tisc_get_slice;
    isc_interprete:               Tisc_interprete;
    isc_open_blob:                Tisc_open_blob;
    isc_open_blob2:               Tisc_open_blob2;
  //isc_prepare_transaction:      Tisc_prepare_transaction;
  //isc_prepare_transaction2:     Tisc_prepare_transaction2;
  //isc_print_sqlerror:           Tisc_print_sqlerror;
  //isc_print_status:             Tisc_print_status;
    isc_put_segment:              Tisc_put_segment;
    isc_put_slice:                Tisc_put_slice;
    isc_que_events:               Tisc_que_events;
  //isc_receive:                  Tisc_receive;
  //isc_reconnect_transaction:    Tisc_reconnect_transaction;
  //isc_release_request:          Tisc_release_request;
  //isc_request_info:             Tisc_request_info;
    isc_rollback_transaction:     Tisc_rollback_transaction;
  //isc_seek_blob:                Tisc_seek_blob;
  //isc_send:                     Tisc_send;
  //isc_start_and_send:           Tisc_start_and_send;
    isc_start_multiple:           Tisc_start_multiple;
  //isc_start_request:            Tisc_start_request;
    isc_sqlcode:                  Tisc_sqlcode;
    isc_transaction_info:         Tisc_transaction_info;
    isc_transact_request:         Tisc_transact_request;
  //isc_unwind_request:           Tisc_unwind_request;
    isc_wait_for_event:           Tisc_wait_for_event;
  //isc_ftof:                     Tisc_ftof;
  //isc_print_blr:                Tisc_print_blr;
  //isc_set_debug:                Tisc_set_debug;
  //isc_qtoq:                     Tisc_qtoq;
    isc_vax_integer:              Tisc_vax_integer;
  //isc_vtof:                     Tisc_vtof;
  //isc_vtov:                     Tisc_vtov;
  //isc_version:                  Tisc_version;
    isc_dsql_execute:             Tisc_dsql_execute;
    isc_dsql_execute2:            Tisc_dsql_execute2;
    isc_dsql_execute_immediate:   Tisc_dsql_execute_immediate;
    isc_dsql_exec_immed2:         Tisc_dsql_exec_immed2;
    isc_dsql_allocate_statement:  Tisc_dsql_allocate_statement;
    isc_dsql_alloc_statement2:    Tisc_dsql_alloc_statement2;
    isc_dsql_free_statement:      Tisc_dsql_free_statement;
    isc_dsql_prepare:             Tisc_dsql_prepare;
    isc_dsql_insert:              Tisc_dsql_insert;
    isc_dsql_set_cursor_name:     Tisc_dsql_set_cursor_name;
    isc_dsql_describe:            Tisc_dsql_describe;
    isc_dsql_describe_bind:       Tisc_dsql_describe_bind;
    isc_dsql_fetch:               Tisc_dsql_fetch;
    isc_dsql_fetch2:              Tisc_dsql_fetch2;
    isc_dsql_sql_info:            Tisc_dsql_sql_info;
  //isc_event_block_asm:          Tisc_event_block_asm;

  { Protected properties }
    property SessionLinkCount: integer read GetSessionLinkCount;
    property SessionLinks[ index: integer ]: TIB_SessionLink
        read GetSessionLink;
  public
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
    procedure Attach; dynamic;
    procedure Detach; dynamic;
    procedure HandleException( Sender: TObject;
                               Handler: TIB_ErrorEvent ); dynamic;
    property Attached: boolean read GetAttached;
  published
    property OnException:  TIB_ErrorEvent read FOnException
                                          write FOnException;
    property BeforeAttach: TIB_SessionEvent read FBeforeAttach
                                            write FBeforeAttach;
    property AfterAttach: TIB_SessionEvent  read FAfterAttach
                                            write FAfterAttach;
    property BeforeDetach: TIB_SessionEvent read FBeforeDetach
                                            write FBeforeDetach;
    property AfterDetach: TIB_SessionEvent  read FAfterDetach
                                            write FAfterDetach;
end;

// IMP_IB_Session
