
{                                                                              }
{ TIB_Script                                                                   }
{                                                                              }

  EIB_ScriptError = class( EIB_Error );

  TIB_ScriptEvent = procedure( Sender: TIB_Script ) of object;

  TIB_Script = class( TComponent )
  private
  { Property storage variables }
    FIB_Connection: TIB_Connection;
    FIB_Transaction: TIB_Transaction;
    FSQL: TStrings;
    FBeginPosNo: longint;
    FEndPosNo: longint;
    FTermKeyWord: string;
    FBeforeExecute: TIB_ScriptEvent;
    FAfterExecute: TIB_ScriptEvent;
  { Property Access Methods }
    procedure SetSQL( NewScript: TStrings ); virtual;
    procedure SetIB_Connection( AValue: TIB_Connection ); virtual;
    procedure SetIB_Transaction( AValue: TIB_Transaction ); virtual;
  protected
    procedure Notification( AComponent: TComponent;
                            Operation: TOperation ); override;
    procedure SysExecute; virtual;
    procedure DoBeforeExecute; virtual;
    procedure DoAfterExecute; virtual;
  public
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
    procedure Execute; virtual;
  published
  { Properties }
    property SQL: TStrings read FSQL write SetSQL;
    property IB_Connection: TIB_Connection read FIB_Connection
                                           write SetIB_Connection;
    property IB_Transaction: TIB_Transaction read FIB_Transaction
                                             write SetIB_Transaction;
  { Events }
    property BeforeExecute: TIB_ScriptEvent read FBeforeExecute
                                            write FBeforeExecute;
    property AfterExecute: TIB_ScriptEvent read FAfterExecute
                                           write FAfterExecute;
  end;

// IMP_IB_Script