
{                                                                              }
{ TIB_Row                                                                      }
{                                                                              }

  TIB_RowEvent = procedure( ARow: TIB_Row ) of object;
  TIB_RowChangedEvent = procedure( ARow: TIB_Row;
                                   AColumn: TIB_Column) of object;

  TIB_Row = class( TObject )
  private
  { Property Access Methods }
    function GetSQLda: XSQLDA; virtual;
    function GetSQLdaID: string; virtual;
    function GetColumn( Index: smallint ): XSQLVAR; virtual;
    function GetSQLdaBC: isc_LONG; virtual;
    function GetVersion: smallint; virtual;
    function GetSQLn: smallint; virtual;
    function GetSQLd: smallint; virtual;
    function GetColumnCount: smallint; virtual;
    function GetColumns( Index: smallint ): TIB_Column; virtual;
    function GetRelationCount: integer; virtual;
    function GetRelationName( Index: integer ): string; virtual;
    function GetFocusedRelationNo: integer; virtual;
    function GetFocusedRelationName: string; virtual;
    procedure SetFocusedRelationNo( AValue: integer ); virtual;
    procedure SetFocusedRelationName( AValue: string ); virtual;
    function GetByAlias( Index: string ): TIB_Column; virtual;
    procedure SetRowState( AValue: TIB_RowState ); virtual;
  protected
  { Property Stroage fields }
    FIB_Statement: TIB_Statement;
    FBlobList: TList;
    FArrayList: TList;
    FColumnCount: smallint;
    FPSQLDA: PXSQLDA;
    FRowType: TIB_RowType;
    FRowState: TIB_RowState;
    FColumnList: TList;
    FVarsCreated: boolean;
    FCursorName: string;
  { Record buffer storage fields }
    FFetchBufferLength: integer;
    FOldFetchBuffer: pointer;
    FNewFetchBuffer: pointer;
  { Info property storage fields }
    FFocusedRelationNo: integer;
    FRelationList: TStringList;
  { Event storage fields }
    FBeforeModify: TIB_RowChangedEvent;
    FAfterModify: TIB_RowChangedEvent;
    FOnRowStateChanged: TIB_RowEvent;
  { Utility Methods }
    procedure CreateVARList; virtual;
    procedure BindVARList; virtual;
    procedure FreeVARList; virtual;
    procedure UpdateVarList; virtual;
  { System Methods }
    procedure SysClearFetchBuffer( FetchBuffer: pointer ); virtual;
    procedure SysRowStateChanged; virtual;
    procedure SysBeforeColumnModify( IB_Column: TIB_Column ); virtual;
    procedure SysAfterColumnModify( IB_Column: TIB_Column ); virtual;
    procedure SysBeforeModify( IB_Column: TIB_Column ); virtual;
    procedure SysAfterModify( IB_Column: TIB_Column ); virtual;
  { Event Dispatch Methods }
    procedure DoBeforeModify( IB_Column: TIB_Column ); virtual;
    procedure DoAfterModify( IB_Column: TIB_Column ); virtual;
  { System Methods }
    procedure SysUpdate( NewColumnCount: smallint ); virtual;
    procedure SysClose; virtual;
  { API function calls }
    procedure API_Describe; virtual;
    procedure API_Describe_Bind; virtual;
  { Properties }
    property SQLdaID: string read GetSQLdaID;
    property SQLdaBC: isc_LONG read GetSQLdaBC;
  public
    constructor Create( Statement: TIB_Statement;
                        DescType: TIB_RowType ); virtual;
    destructor Destroy; override;
  { Utility Methods }
    procedure ClearBuffers; virtual;
    procedure PostBuffers; virtual;
    procedure CancelBuffers; virtual;
    procedure RefreshBuffers; virtual;
    procedure MergeBuffers; virtual;
    function GetColumnByName(     ColumnName: string;
                              var IB_Column: TIB_Column ): boolean;
    procedure DefaultColumnCreation(     NewIndex: smallint;
                                     var NewIB_Column: TIB_Column ); virtual;
  { Properties }
    property IB_Statement: TIB_Statement read FIB_Statement;
    property RowType: TIB_RowType read FRowType;
    property RowState: TIB_RowState read FRowState;
    property SQLda: XSQLDA read GetSQLDA;
    property PSQLda: PXSQLDA read FPSQLDA;
    property Version: smallint read GetVersion;
    property SQLn: smallint read GetSQLn;
    property SQLd: smallint read GetSQLd;
    property ColumnCount: smallint read GetColumnCount;
    property Columns[ Index: smallint ]: TIB_Column read GetColumns; default;
    property ByAlias[ Index: string ]: TIB_Column read GetByAlias;
    property FetchBufferLength: integer read FFetchBufferLength;
    property FetchBuffer: pointer read FNewFetchBuffer write FNewFetchBuffer;
    property RelationCount: integer read GetRelationCount;
    property RelationNames[ Index: integer ]: string read GetRelationName;
    property FocusedRelationNo: integer read GetFocusedRelationNo
                                        write SetFocusedRelationNo;
    property FocusedRelationName: string read GetFocusedRelationName
                                         write SetFocusedRelationName;
    property CursorName: string read FCursorname;
  { Events }
    property BeforeModify: TIB_RowChangedEvent read FBeforeModify
                                               write FBeforeModify;
    property AfterModify: TIB_RowChangedEvent read FAfterModify
                                              write FAfterModify;
    property OnRowStateChanged: TIB_RowEvent read FOnRowStateChanged
                                             write FOnRowStateChanged;
  end;

// IMP_IB_Row
