
{                                                                              }
{ TIB_DataSetLink                                                              }
{                                                                              }

  TIB_DataChangeEvent = procedure( Sender: TObject;
                                   AIB_DataSet: TIB_DataSet;
                                   AColumn: TIB_Column) of object;

  TIB_DataSetLinkEvent = procedure( Sender: TIB_DataSetLink;
                                    AIB_DataSet: TIB_DataSet ) of object;

  TIB_DataSetLink = class( TIB_StatementLinkBase )
  private
  { Inhertied }
    procedure SetIB_Statement( AValue: TIB_Statement ); override;
  { Property Access Methods }
    function GetDataLinkCount: integer; 
    function GetDataLink( Index: integer ): TIB_DataLink;
    function GetIB_DataSet: TIB_DataSet; virtual;
    procedure SetIB_DataSet( AValue: TIB_DataSet ); virtual;
    function GetDataSetState: TIB_DataSetState; virtual;
    function GetRowState: TIB_RowState; virtual;
    function GetReadOnly: boolean; virtual;
    function GetCanModify: boolean; virtual;
    procedure SetEnabled( AValue: boolean ); virtual;
    function GetNeedToPost: boolean; virtual;
  protected
  { Utility Storage Fields }
    FIB_DataLinkList: TList;
  { Property Storage Fields }
    FAutoUpdate: boolean;
    FAutoInsert: boolean;
    FAnnounceFocus: boolean;
    FEnabled: boolean;
  { Flag for testing }
    flag_junk_value: integer;
  { Event Storage Fields }
    FOnGainFocus: TIB_DataSetLinkEvent;
    FOnLoseFocus: TIB_DataSetLinkEvent;
    FOnStateChanged: TIB_DataSetLinkEvent;
  { Utility Methods }
    procedure AddIB_DataLink(IB_DataLink: TIB_DataLink); virtual;
    procedure RemoveIB_DataLink(IB_DataLink: TIB_DataLink); virtual;
  { Inherited Methods }
    procedure SysPrepareSQL; override;
    procedure SysBeforeUpdateDescriptors; override;
    procedure SysAfterUpdateDescriptors; override;
    procedure DoPreparedChanged; override;
    procedure DoBeforeExecute; override;
    procedure DoAfterExecute; override;
    procedure DoActiveChanged; override;
    procedure DoAfterAssignment; override;
    procedure DoOutputRowUpdateData( AColumn: TIB_Column ); override;
    procedure DoOutputRowDataChanged( AColumn: TIB_Column ); override;
  { System Methods }
    procedure SysStateChanged; virtual;
  { Event Dispatch Methods  }
    procedure DoGainFocus; virtual;
    procedure DoLoseFocus; virtual;
    procedure DoStateChanged; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  { Methods }
    function IsLinkedTo(IB_DataSet: TIB_DataSet): boolean;
    function Update: boolean; virtual;
    function Insert: boolean; virtual;
    function Modify: boolean; virtual;
    function Modifying: boolean; virtual;
    procedure Reset; virtual;
    procedure SetFocus; virtual;
  { Properties }
    property DataLinkCount: integer read GetDatalinkCount;
    property DataLinks[ Index: integer ]: TIB_DataLink read GetDatalink;
    property DataSetState: TIB_DataSetState read GetDataSetState;
    property RowState: TIB_RowState read GetRowState;
    property StatementType: TIB_StatementType read GetStatementType;
    property ReadOnly: boolean read GetReadOnly;
    property CanModify: boolean read GetCanModify;
    property NeedToPost: boolean read GetNeedToPost;
  published
  { Properties }
    property AnnounceFocus: boolean read FAnnounceFocus
                                    write FAnnounceFocus
                                    default false;
    property AutoUpdate: boolean read FAutoUpdate
                                 write FAutoUpdate
                                 default true;
    property AutoInsert: boolean read FAutoInsert
                                 write FAutoInsert
                                 default true;
    property Enabled: boolean read FEnabled write SetEnabled default true;
    property IB_DataSet: TIB_DataSet read GetIB_DataSet write SetIB_DataSet;
{------------------------------------------------------------------------------}
    property _DataLinkCount: integer read GetDatalinkCount
                                     write flag_junk_value
                                     stored false;
{------------------------------------------------------------------------------}
  { Inherited Events }
    property OnPrepareSQL;
    property OnDataChanged: TIB_ColLinkEvent read FOnOutputDataChanged
                                             write FOnOutputDataChanged;
    property OnUpdateData: TIB_ColLinkEvent read FOnOutputUpdateData
                                            write FOnOutputUpdateData;
  { Events }
    property OnStateChanged: TIB_DataSetLinkEvent read FOnStateChanged
                                                  write FOnStateChanged;
    property OnGainFocus: TIB_DataSetLinkEvent read FOnGainFocus
                                               write FOnGainFocus;
    property OnLoseFocus: TIB_DataSetLinkEvent read FOnLoseFocus
                                               write FOnLoseFocus;
  end; { TIB_DataSetLink }

// IMP_IB_DataSetLink
