
{                                                                              }
{ TIB_DATASET                                                                  }
{                                                                              }

  EIB_DataSetError = class( EIB_Error );

  TIB_DataSetEvent = procedure( IB_DataSet: TIB_DataSet ) of object;
  TIB_FetchCallbackStatus = ( csInit, csRefresh, csFinal );
  TIB_FetchCallbackEvent = procedure( IB_DataSet: TIB_DataSet;
                                      Status: TIB_FetchCallbackStatus;
                                      CursorRowNum: longint ) of object;
  TIB_DataSetState = (dsNone

                     ,dsPrepared
                     ,dsInserting

                     ,dsSearching

                     ,dsActive
                     ,dsUpdating
                     ,dsDeleting

                     ,dsCalculating
                     ,dsLookingUp
                     ,dsFiltering

                     );

  TIB_DataSet = class( TIB_Statement )
  protected
  { Property Storage Fields }
    FIB_DataLink: TIB_DataLink;
    FIB_DataSetLinkList: TList;
    FDataSetState: TIB_DataSetState;
    FOrderingItemNo: integer;
    FOrderingItems: TStrings;
    FParameterLinks: TStrings;
    FGeneratorLinks: TStrings;
    FParamColumnLinks: TStrings;
    FParentSearching: boolean;
    FChildDataSetList: TList;
    FParentWhereClause: string;
    FSQLWhereChanged: boolean;
    FSQLOrderChanged: boolean;
    FDisplayNames: TStrings;
    FDisplayMasks: TStrings;
    FRetreiveServerDefaults: boolean;
    FPessimisticLocking: boolean;
    FLockTransaction: TIB_TransactionSingle;
    FIsRowLocked: boolean;
    FFetchCallbackInc: cardinal;
    FFetchCallbackActive: boolean;
    FFetchAborted: boolean;
    FIsPosting: boolean;
    FReadOnly: boolean;
    FPreventUpdating: boolean;
    FPreventInserting: boolean;
    FPreventDeleting: boolean;
    FPreventSearching: boolean;
    FCursorName: string;
    FCursorEOF: boolean;
    FCursorRowNum: longint;
    FCursorRowCount: longint;
    FCursorRowCountValid: boolean;
    FWhereClauseItemsLow: TStrings;
    FWhereClauseItemsMed: TStrings;
    FWhereClauseItemsHigh: TStrings;
    FWhereClauseParams: TStrings;
    FSQLSelect:      TStrings;
    FSQLFrom:        TStrings;
    FSQLWhere:       TStrings;
    FSQLGroup:       TStrings;
    FSQLHaving:      TStrings;
    FSQLUnion:       TStrings;
    FSQLPlan:        TStrings;
    FSQLOrder:       TStrings;
    FSQLForUpdate:   TStrings;
    FHintInsert,
    FHintUpdate,
    FHintDelete,
    FHintPost,
    FHintCancel,
    FHintFirst,
    FHintLast,
    FHintNext,
    FHintPrior,
    FHintSearch: string;
    dlgCancelQuery: TdlgCancelQuery;
  { Optimization/System Flags }
    flag_open_after_load: boolean;
    flag_junk_value: integer;
  { Event Storage Fields }
    FBeforeOpen: TIB_DataSetEvent;
    FAfterOpen: TIB_DataSetEvent;
    FBeforeClose: TIB_DataSetEvent;
    FAfterClose: TIB_DataSetEvent;
    FBeforeSearch: TIB_DataSetEvent;
    FAfterSearch: TIB_DataSetEvent;
    FBeforeUpdate: TIB_DataSetEvent;
    FAfterUpdate: TIB_DataSetEvent;
    FBeforeInsert: TIB_DataSetEvent;
    FAfterInsert: TIB_DataSetEvent;
    FBeforeDelete: TIB_DataSetEvent;
    FAfterDelete: TIB_DataSetEvent;
    FBeforeCancel: TIB_DataSetEvent;
    FAfterCancel: TIB_DataSetEvent;
    FBeforePost: TIB_DataSetEvent;
    FAfterPost: TIB_DataSetEvent;
    FOnFetchCallback: TIB_FetchCallbackEvent;
  { Inherited Property Access Methods }
    procedure SetIB_Connection( AValue: TIB_Connection ); override;
    procedure SetIB_Transaction( AValue: TIB_Transaction ); override;
    procedure SetActive( Value: boolean ); override;
  { Property Access Methods }
    function GetCursorEOF: boolean; virtual;
    function GetCursorBOF: boolean; virtual;
    function GetEOF: boolean; virtual;
    function GetBOF: boolean; virtual;
    function GetCanModify: boolean; virtual;
    function GetCanUpdate: boolean; virtual;
    function GetCanInsert: boolean; virtual;
    function GetCanDelete: boolean; virtual;
    function GetCanSearch: boolean; virtual;
    function GetNeedToPost: boolean; virtual;
    function GetDataSetLinkCount: integer; virtual;
    function GetDataSetLinks( Index: integer ): TIB_DataSetLink; virtual;
    function GetDataSetState: TIB_DataSetState; virtual;
    procedure SetDataSetState( AValue: TIB_DataSetState ); virtual;
    procedure SetIB_DataSetLink( AValue: TIB_DataSetLink ); virtual;
    function GetIB_DataSetLink: TIB_DataSetLink; virtual;
    function GetRowNum: longint; virtual;
    procedure SetRowNum( AValue: longint ); virtual;
    function GetCursorRowCount: longint; virtual;
    function GetUnidirectional: boolean; virtual;
    procedure SetReadOnly( AValue: boolean ); virtual;
    function GetReadOnly: boolean; virtual;
    procedure SetPreventUpdating( AValue: boolean ); virtual;
    procedure SetPreventInserting( AValue: boolean ); virtual;
    procedure SetPreventDeleting( AValue: boolean ); virtual;
    procedure SetPreventSearching( AValue: boolean ); virtual;
    function GetIsRowLocked: boolean; virtual;
  { General methods }
    procedure AfterTransactionEnd        ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); override;
    procedure AfterTransactionSavePoint  ( TLink: TIB_TransactionLink;
                                               T: TIB_Transaction ); override;
    function GetParameterLinkCount: integer; virtual;
    procedure SetParameterLinks( Value: TStrings ); virtual;
    function GetOrderingItems: TStrings; virtual;
    procedure SetOrderingItems( Value: TStrings ); virtual;
    procedure SetOrderingItemNo( Value: integer ); virtual;
    function GetGeneratorLinks: TStrings; virtual;
    procedure SetGeneratorLinks( Value: TStrings ); virtual;
    function GetDisplayNames: TStrings; virtual;
    procedure SetDisplayNames( Value: TStrings ); virtual;
    function GetDisplayMasks: TStrings; virtual;
    procedure SetDisplayMasks( Value: TStrings ); virtual;
    function GetParameterLink( ParamName: string ): string; virtual;
    procedure SetParameterLink( ParamName: string; TableName: string); virtual;
    procedure ExecFieldLinks; virtual;
    function GetParentDataSet: TIB_DataSet; virtual;
    function GetParentRelation( LinkNo: integer ): string; virtual;
    function GetParentColumn( LinkNo: integer ): string; virtual;
    function GetChildRelation( LinkNo: integer ): string; virtual;
    function GetChildColumn( LinkNo: integer ): string; virtual;
    function GetSQLSection( Index: integer ): TStrings;
    procedure SetSQLSection( Index: integer; Value: TStrings );
    procedure SQLSelectChange( Sender: TObject );
    procedure SQLFromChange( Sender: TObject );
    procedure SQLWhereChange( Sender: TObject );
    procedure SQLGroupChange( Sender: TObject );
    procedure SQLHavingChange( Sender: TObject );
    procedure SQLUnionChange( Sender: TObject );
    procedure SQLPlanChange( Sender: TObject );
    procedure SQLOrderChange( Sender: TObject );
  { Inherited Methods }
    procedure Loaded; override;
    procedure SysAfterPrepare; override;
    procedure SysPreparedChanged; override;
    procedure SysAfterUnprepare; override;
    procedure BeforeConnectionDisconnect( CLink: TIB_ConnectionLink;
                                          C: TIB_Connection ); override;
    procedure BeforeTransactionAssignment( TLink: TIB_TransactionLink;
                                             Old: TIB_Transaction ); override;
    procedure SysExecSelect; override;
    procedure SysExecute; override;
    procedure SysClose; override;
    procedure SysBeforeOutputDataChange( Sender: TIB_Row;
                                         AColumn: TIB_Column); override;
    procedure SysBeforeExecuteForOutput; override;
    procedure SysAfterExecuteForOutput; override;
    procedure SysActiveChanged; override;
    procedure SysPrepareSQL; override;
    procedure SysPrepareFailed; override;
    function SysPrepare: boolean; override;
    procedure SysUnprepare; override;
    procedure SysUpdateDescriptors; override;
    procedure SysGetCursorName; virtual;
    function SysGetCursorRowCount: longint; virtual;
    procedure OnSQLChange( Sender: TObject ); override;
  { System Methods }
    function SysOpen: boolean; virtual;
    function SysCount: longint; virtual;
    procedure SysOpenAfterLoad; virtual;
    procedure SysUpdate; virtual;
    procedure SysUpdateRow; virtual;
    procedure SysInsert; virtual;
    procedure SysInsertRow; virtual;
    procedure SysGetDefaults; virtual;
    procedure SysDelete; virtual;
    procedure SysDeleteRow; virtual;
    procedure SysPost; virtual;
    procedure SysPostRow; virtual;
    procedure SysPostUpdatedRow; virtual;
    procedure SysPostInsertedRow; virtual;
    procedure SysPostDeletedRow; virtual;
    procedure SysCancel; virtual;
    procedure SysCancelRow; virtual;
    procedure SysCancelUpdatedRow; virtual;
    procedure SysCancelInsertedRow; virtual;
    procedure SysCancelDeletedRow; virtual;
    procedure SysClearLock; virtual;
    procedure SysLast; virtual;
    procedure SysBeforeLast; virtual;
    procedure SysLastRow; virtual;
    procedure SysAfterLast; virtual;
    procedure SysFirst; virtual;
    procedure SysBeforeFirst; virtual;
    procedure SysFirstRow; virtual;
    procedure SysAfterFirst; virtual;
    procedure SysMoveBy( JumpRecs: longint ); virtual;
    procedure SysCursorMoveByRow( JumpRecs: longint ); virtual;
    procedure SysBeforeMoveBy( JumpRecs: longint ); virtual;
    procedure SysMoveByRow( JumpRecs: longint ); virtual;
    procedure SysAfterMoveBy( JumpRecs: longint ); virtual;
    procedure SysBeforeNavigate; virtual;
    procedure SysAfternavigate; virtual;
    procedure SysDataSetStateChanged; virtual;
    procedure SysProcessCallback( Status: TIB_FetchCallbackStatus ); virtual;
    procedure SysExecParameterLinks; virtual;
    procedure SysExecParentLinks; virtual;
  { Internal method handlers }
    procedure SysBeforeOpen; virtual;
    procedure SysAfterOpen; virtual;
    procedure SysBeforeClose; virtual;
    procedure SysAfterClose; virtual;
    procedure SysBeforeSearch; virtual;
    procedure SysAfterSearch; virtual;
    procedure SysBeforeUpdate; virtual;
    procedure SysAfterUpdate; virtual;
    procedure SysBeforeInsert; virtual;
    procedure SysAfterInsert; virtual;
    procedure SysBeforeDelete; virtual;
    procedure SysAfterDelete; virtual;
    procedure SysBeforePost; virtual;
    procedure SysAfterPost; virtual;
    procedure SysBeforeCancel; virtual;
    procedure SysAfterCancel; virtual;
  { System Cursor handling methods }
    procedure SysFetchFirst; virtual;
    procedure SysFetchNext; virtual;
    procedure SysFetchAll; virtual;
    procedure SysUpdateCursorRow; virtual;
    procedure SysInsertCursorRow; virtual;
    procedure SysDeleteCursorRow; virtual;
    procedure SysBeforeFetchCursorRow; virtual;
    procedure SysFetchedCursorRow; virtual;
    procedure SysFetchedCursorEOF; virtual;
    procedure SysAfterFetchCursorRow; virtual;
    procedure SysAfterFetchCursorEOF; virtual;
  { Parent DataSet Linking Methods }
    procedure ParentPrepareSQL( Sender: TIB_DataLink;
                                  IB_DataSetLink: TIB_DataSetLink ); virtual;
    procedure ParentStateChanged( Sender: TIB_DataLink;
                                  IB_DataSetLink: TIB_DataSetLink ); virtual;
    procedure ParentDataChanged( Sender: TIB_DataLink;
                                 IB_DataSetLink: TIB_DataSetLink;
                                 IB_Column: TIB_Column ); virtual;
  { API Function Calls }
    procedure API_CreateCursor; virtual;
    function API_FetchRow: integer; virtual;
    procedure API_FreeCursor; virtual;
  { SQL Generator procedures }
    procedure SQL_CursorUpdate; virtual;
    function SQL_CursorLock: boolean; virtual;
    procedure SQL_CursorInsert; virtual;
    procedure SQL_CursorDelete; virtual;
  { Event Dispatch Methods }
    procedure DoBeforeOpen; virtual;
    procedure DoAfterOpen; virtual;
    procedure DoBeforeClose; virtual;
    procedure DoAfterClose; virtual;
    procedure DoBeforeSearch; virtual;
    procedure DoAfterSearch; virtual;
    procedure DoBeforeUpdate; virtual;
    procedure DoAfterUpdate; virtual;
    procedure DoBeforeInsert; virtual;
    procedure DoAfterInsert; virtual;
    procedure DoAfterDelete; virtual;
    procedure DoBeforeDelete; virtual;
    procedure DoBeforePost; virtual;
    procedure DoAfterPost; virtual;
    procedure DoBeforeCancel; virtual;
    procedure DoAfterCancel; virtual;
    procedure DoProcessCallback( Status: TIB_FetchCallbackStatus ); virtual;
  { Link Event Dispatch Methods }
    procedure DoLinkDataSetStateChanged; virtual;
    procedure DoLinkProcessCallback( Status: TIB_FetchCallbackStatus ); virtual;
  { Properties }
    property DataSetLinkCount: integer read GetDataSetLinkCount;
    property DataSetLinks[ Index: integer ]: TIB_DataSetLink
        read GetDataSetLinks;
    property CursorRowNum: longint read FCursorRowNum;
    property CursorBOF: boolean read GetCursorBOF;
    property CursorEOF: boolean read GetCursorEOF;
    property SQLSelect: TStrings Index 1 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLFrom:   TStrings Index 2 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLWhere:  TStrings Index 3 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLGroup:  TStrings Index 4 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLHaving: TStrings Index 5 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLUnion:  TStrings Index 6 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLPlan:   TStrings Index 7 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property SQLOrder:  TStrings Index 8 read GetSQLSection
                                         write SetSQLSection
                                         stored false;
    property IsRowLocked: boolean read GetIsRowLocked;  
    property PessimisticLocking: boolean read FPessimisticLocking
                                         write FPessimisticLocking
                                         default false;
  { Events }
    property OnFetchCallback: TIB_FetchCallbackEvent read FOnFetchCallback
                                                     write FOnFetchCallback;
    property BeforeOpen:  TIB_DataSetEvent read FBeforeOpen
                                           write FBeforeOpen;
    property AfterOpen:   TIB_DataSetEvent read FAfterOpen
                                           write FAfterOpen;
    property BeforeClose: TIB_DataSetEvent read FBeforeClose
                                           write FBeforeClose;
    property AfterClose:  TIB_DataSetEvent read FAfterClose
                                           write FAfterClose;
    property BeforeSearch: TIB_DataSetEvent read FBeforeSearch
                                            write FBeforeSearch;
    property AfterSearch:  TIB_DataSetEvent read FAfterSearch
                                            write FAfterSearch;
    property BeforeUpdate: TIB_DataSetEvent read FBeforeUpdate
                                            write FBeforeUpdate;
    property AfterUpdate:  TIB_DataSetEvent read FAfterUpdate
                                            write FAfterUpdate;
    property BeforeInsert: TIB_DataSetEvent read FBeforeInsert
                                            write FBeforeInsert;
    property AfterInsert:  TIB_DataSetEvent read FAfterInsert
                                            write FAfterInsert;
    property BeforeDelete: TIB_DataSetEvent read FBeforeDelete
                                            write FBeforeDelete;
    property AfterDelete:  TIB_DataSetEvent read FAfterDelete
                                            write FAfterDelete;
    property BeforePost:   TIB_DataSetEvent read FBeforePost
                                            write FBeforePost;
    property AfterPost:    TIB_DataSetEvent read FAfterPost
                                            write FAfterPost;
    property BeforeCancel: TIB_DataSetEvent read FBeforeCancel
                                            write FBeforeCancel;
    property AfterCancel:  TIB_DataSetEvent read FAfterCancel
                                            write FAfterCancel;
  public
  { Inherited Methods }
    constructor Create( AOwner : TComponent ); override;
    destructor Destroy; override;
    procedure Execute; override;
    procedure Unprepare; override;
    procedure SetFocus; virtual;
    procedure Invalidate; override;
  { Methods }
    procedure Open; virtual;
    procedure Close; virtual;
    procedure First; virtual;
    procedure Last; virtual;
    procedure Next; virtual;
    procedure Prior; virtual;
    procedure MoveBy( JumpRecs: longint ); virtual;
    procedure Update; virtual;
    procedure Insert; virtual;
    procedure Delete; virtual;
    procedure Post; virtual;
    procedure Cancel; virtual;
    procedure Abort; virtual;
    function Count: longint; virtual;
    procedure Search; virtual;
    procedure SaveSearch; virtual;
    procedure ClearSearch; virtual;
    procedure RecallSearch; virtual;
    procedure AddSQLWhereClause( WhereClause: string ); virtual;
    function IsLinkedTo( IB_DataSetLink: TIB_DataSetLink ): boolean; virtual;
    procedure UpdateData; virtual;
    procedure DataChanged; virtual;
    procedure GetOrderingItemsList( const OrderingItemsList: TStrings );
  { Properties }
    property DataSetState: TIB_DataSetState read GetDataSetState;
    property Unidirectional: boolean read GetUnidirectional;
    property EOF: boolean read GetEOF;
    property BOF: boolean read GetBOF;
    property RowNum: longint read GetRowNum write SetRowNum;
    property CursorRowCount: longint read GetCursorRowCount;
    property CanModify: boolean read GetCanModify;
    property CanUpdate: boolean read GetCanUpdate;
    property CanInsert: boolean read GetCanInsert;
    property CanDelete: boolean read GetCanDelete;
    property CanSearch: boolean read GetCanSearch;
    property NeedToPost: boolean read GetNeedToPost;
    property IsPosting: boolean read FIsPosting;
    property ReadOnly: boolean read GetReadOnly write SetReadOnly default false;
    property PreventUpdating: boolean read FPreventUpdating
                                      write SetPreventUpdating
                                      default false;
    property PreventInserting: boolean read FPreventInserting
                                       write SetPreventInserting
                                       default false;
    property PreventDeleting: boolean read FPreventDeleting
                                      write SetPreventDeleting
                                      default false;
    property PreventSearching: boolean read FPreventSearching
                                       write SetPreventSearching
                                       default false;
    property FetchCallbackInc: cardinal read FFetchCallbackInc
                                        write FFetchCallbackInc
                                        default 256;
    property FetchCallbackActive: boolean read FFetchCallbackActive;
    property FetchAborted: boolean read FFetchAborted;
    property WhereClauseItemsLow:  TStrings read FWhereClauseItemsLow;
    property WhereClauseItemsMed:  TStrings read FWhereClauseItemsMed;
    property WhereClauseItemsHigh: TStrings read FWhereClauseItemsHigh;
    property WhereClauseParams: TStrings read FWhereClauseParams;
    property ParentDataSet: TIB_DataSet read GetParentDataSet;
    property ParameterLinkCount: integer read GetParameterLinkCount;
    property ParameterLink[ Index: string ]: string read GetParameterLink
                                                    write SetParameterLink;
    property ParentRelation[ Index: integer ]: string read GetParentRelation;
    property ParentColumn  [ Index: integer ]: string read GetParentColumn;
    property ChildRelation [ Index: integer ]: string read GetChildRelation;
    property ChildColumn   [ Index: integer ]: string read GetChildColumn;
    property SQLWhereChanged: boolean read FSQLWhereChanged;
    property SQLOrderChanged: boolean read FSQLOrderChanged;
  published
{------------------------------------------------------------------------------}
    property _DataSetLinkCount: integer read GetDataSetLinkCount
                                        write flag_junk_value
                                        stored false;
{------------------------------------------------------------------------------}
    property HintInsert: string read FHintInsert write FHintInsert;
    property HintUpdate: string read FHintUpdate write FHintUpdate;
    property HintDelete: string read FHintDelete write FHintDelete;
    property HintPost:   string read FHintPost   write FHintPost;
    property HintCancel: string read FHintCancel write FHintCancel;
    property HintFirst:  string read FHintFirst  write FHintFirst;
    property HintLast:   string read FHintLast   write FHintLast;
    property HintNext:   string read FHintNext   write FHintNext;
    property HintPrior:  string read FHintPrior  write FHintPrior;
    property HintSearch: string read FHintSearch write FHintSearch;
    property IB_DataSetLink: TIB_DataSetLink read GetIB_DataSetLink
                                             write SetIB_DataSetLink;
    property ParentSearching: boolean read FParentSearching
                                      write FParentSearching
                                      default false;
    property ParameterLinks: TStrings read FParameterLinks
                                      write SetParameterLinks;
    property OrderingItems: TStrings read GetOrderingItems
                                     write SetOrderingItems;
    property OrderingItemNo: integer read FOrderingItemNo
                                     write SetOrderingItemNo
                                     default -1;
    property GeneratorLinks: TStrings read GetGeneratorLinks
                                      write SetGeneratorLinks;
    property DisplayNames: TStrings read GetDisplayNames
                                    write SetDisplayNames;
    property DisplayMasks: TStrings read GetDisplayMasks
                                    write SetDisplayMasks;
    property RetreiveServerDefaults: boolean read FRetreiveServerDefaults
                                             write FRetreiveServerDefaults
                                             default false;
  end;

// IMP_IB_DATASET
