
{                                                                              }
{ TIB_DataLink                                                                 }
{                                                                              }

  TIB_DataLinkEvent = procedure( Sender: TIB_DataLink;
                                 IB_DataSetLink: TIB_DataSetLink ) of object;

  TIB_ColumnDataLinkEvent = procedure( Sender: TIB_DataLink;
                                       IB_DataSetLink: TIB_DataSetLink;
                                       IB_Column: TIB_Column ) of object;

  TIB_DataLink = class( TComponent )
  private
    FIB_DataSetLink: TIB_DataSetLink;
    FReceiveFocus: boolean;
    FControl: TWinControl;
    FSearchBuffer: string;    { Store Select clause info. }
    FSearchSaved: string;
    FSearchLast: string;
    procedure SetIB_DataSetLink( AValue: TIB_DataSetLink ); virtual;
    function GetIB_DataSetLink: TIB_DataSetLink; virtual;
    function GetIB_DataSet: TIB_DataSet; virtual;
    function GetPrepared: boolean; virtual;
    function GetActive: boolean; virtual;
    function GetNeedToPost: boolean; virtual;
    function GetDataSetState: TIB_DataSetState; virtual;
    function GetRowState: TIB_RowState; virtual;
    function GetCanModify: boolean; virtual;
    function GetReadOnly: boolean; virtual;
    function GetPreventUpdating: boolean; virtual;
    function GetPreventInserting: boolean; virtual;
    function GetPreventSearching: boolean; virtual;
    procedure SetSearchBuffer( AValue: string ); virtual;
    function GetSearchBuffer: string; virtual;
    function GetColor: TColor; virtual;
    function GetUpdatingColor: TColor; virtual;
    function GetInsertingColor: TColor; virtual;
    function GetSearchingColor: TColor; virtual;
    function GetInvalidColor: TColor; virtual;
    function GetActiveColor: TColor; virtual;
  protected
  { System Methods }
    procedure SysPrepareSQL; virtual;
    procedure SysBeforeUpdateDescriptors; virtual;
    procedure SysAfterUpdateDescriptors; virtual;
    procedure SysPreparedChanged; virtual;
    procedure SysBeforeExecute; virtual;
    procedure SysAfterExecute; virtual;
    procedure SysActiveChanged; virtual;
    procedure SysStateChanged; virtual;
    procedure SysDataChanged( AColumn: TIB_Column ); virtual;
    procedure SysUpdateData( AColumn: TIB_Column ); virtual;
  { Focusing stuff }
    procedure DoReceiveFocus( DS: TIB_DataSetLink ); virtual;
  { Event Dispatch methods }
    procedure DoBeforeAssignment; virtual;
    procedure DoAfterAssignment; virtual;
    procedure DoPrepareSQL; virtual;
    procedure DoPreparedChanged; virtual;
    procedure DoBeforeExecute; virtual;
    procedure DoAfterExecute; virtual;
    procedure DoActiveChanged; virtual;
    procedure DoStateChanged; virtual;
    procedure DoDataChanged( AColumn: TIB_Column ); virtual;
    procedure DoUpdateData( AColumn: TIB_Column ); virtual;
  public
  { Control Property Storage }
    ControlIsModified: boolean;
    ControlIsReadOnly: boolean;
    ControlPreventsUpdating: boolean;
    ControlPreventsInserting: boolean;
    ControlPreventsSearching: boolean;
  { Event Hooks }
    BeforeAssignment: TIB_DataLinkEvent;
    AfterAssignment: TIB_DataLinkEvent;
    OnReceiveFocus: TIB_DataLinkEvent;
    OnPrepareSQL: TIB_DataLinkEvent;
    OnPreparedChanged: TIB_DataLinkEvent;
    BeforeExecute: TIB_DataLinkEvent;
    AfterExecute: TIB_DataLinkEvent;
    OnActiveChanged: TIB_DataLinkEvent;
    OnStateChanged: TIB_DataLinkEvent;
    OnDataChanged: TIB_ColumnDataLinkEvent;
    OnUpdateData: TIB_ColumnDataLinkEvent;
  { Inherited Methods }
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
  { New methods }
    procedure Update; virtual;
    procedure Insert; virtual;
    function Modify: boolean; virtual;
    function Modifying: boolean; virtual;
    procedure SaveSearch; virtual;
    procedure ClearSearch; virtual;
    procedure RecallSearch; virtual;
    procedure UpdateValue; virtual;
    procedure SetFocus; virtual;
  { Properties }
    property IB_DataSetLink: TIB_DataSetLink read GetIB_DataSetLink
                                             write SetIB_DataSetLink;
    property IB_DataSet: TIB_DataSet read GetIB_DataSet;
    property Prepared: boolean read GetPrepared;
    property Active: boolean read GetActive;
    property DataSetState: TIB_DataSetState read GetDataSetState;
    property RowState: TIB_RowState read GetRowState;
    property CanModify: boolean read GetCanModify;
    property Control: TWinControl read FControl write FControl;
    property Color: TColor read GetColor;
    property ReadOnly: boolean read GetReadOnly;
    property NeedToPost: boolean read GetNeedToPost;
    property PreventUpdating:  boolean read GetPreventUpdating;
    property PreventInserting: boolean read GetPreventInserting;
    property PreventSearching: boolean read GetPreventSearching;
    property SearchBuffer: string read GetSearchBuffer write SetSearchBuffer;
    property ReceiveFocus: boolean read FReceiveFocus write FReceiveFocus;
  end;

// IMP_IB_DataLink
