
{                                                                              }
{ TIB_Cursor                                                                   }
{                                                                              }

  TIB_Cursor = class( TIB_DataSet )
  private
    function GetCanUpdate: boolean; override;
    function GetCanDelete: boolean; override;
  protected
    FAfterFetchRow: TIB_DataSetEvent;
    FAfterFetchEof: TIB_DataSetEvent;
    procedure SysInsertRow; override;
    procedure SysAfterFetchCursorRow; override;
    procedure SysAfterFetchCursorEOF; override;
    procedure DoAfterFetchCursorRow; virtual;
    procedure DoAfterFetchCursorEOF; virtual;
  public
    property IsRowLocked;  
  published
  { Published properties }
    property SQL;
    property SQLSelect;
    property SQLFrom;
    property SQLWhere;
    property SQLGroup;
    property SQLHaving;
    property SQLUnion;
    property SQLPlan;
    property SQLOrder;
//    property CursorName;
    property Active;
    property Prepared;
    property ReadOnly;
    property PessimisticLocking;
    property PreventUpdating;
    property PreventInserting;
    property PreventDeleting;
    property PreventSearching;
    property FetchCallbackInc;
  { Published Events }
    property AfterFetchRow: TIB_DataSetEvent read FAfterFetchRow
                                             write FAfterFetchRow;
    property AfterFetchEof: TIB_DataSetEvent read FAfterFetchEof
                                             write FAfterFetchEof;
    property OnActiveChanged;
    property OnPreparedChanged;
    property OnFetchCallback; 
    property BeforePrepare;
    property AfterPrepare;
    property BeforeUnprepare;
    property AfterUnprepare;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeUpdate;
    property AfterUpdate;
    property BeforeSearch;
    property AfterSearch;
    property BeforeInsert;
    property AfterInsert;
    property BeforeDelete;
    property AfterDelete;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
  end;  { TIB_Cursor }

  // IMP_IB_Cursor
