
{                                                                              }
{ TIB_ConnectionLink                                                           }
{                                                                              }

  TIB_ConnectionLinkEvent = procedure( Sender: TIB_ConnectionLink;
                                       IB_Connection: TIB_Connection) of object;

  TIB_ConnectionLink = class( TComponent )
  private
  { Property Access Methods }
    function GetConnected: boolean;
    function GetConnectionStatus: TIB_ConnectionStatus; 
  protected
  { Property Storage Fields }
    FIB_Connection: TIB_Connection;
    FReceiveFocus: boolean;
  { Event Storage Fields }
    FBeforeAssignment: TIB_ConnectionLinkEvent;
    FAfterAssignment: TIB_ConnectionLinkEvent;
    FBeforeExecDDL: TIB_ConnectionLinkEvent;
    FAfterExecDDL: TIB_ConnectionLinkEvent;
    FBeforeConnect: TIB_ConnectionLinkEvent;
    FAfterConnect: TIB_ConnectionLinkEvent;
    FBeforeDisconnect: TIB_ConnectionLinkEvent;
    FAfterDisconnect: TIB_ConnectionLinkEvent;
    FBeforeCreateDatabase: TIB_ConnectionLinkEvent;
    FAfterCreateDatabase: TIB_ConnectionLinkEvent;
    FBeforeDropDatabase: TIB_ConnectionLinkEvent;
    FAfterDropDatabase: TIB_ConnectionLinkEvent;
    FOnConnectedChanged: TIB_ConnectionLinkEvent;
    FOnReceiveFocus: TIB_ConnectionLinkEvent;
  { Property Access Methods }
    procedure SetIB_Connection( AValue: TIB_Connection ); virtual;
  { Event dispatch methods }
    procedure DoBeforeAssignment; virtual;
    procedure DoAfterAssignment; virtual;
    procedure DoBeforeExecDDL; virtual;
    procedure DoAfterExecDDL; virtual;
    procedure DoBeforeConnect; virtual;
    procedure DoAfterConnect; virtual;
    procedure DoBeforeDisconnect; virtual;
    procedure DoAfterDisconnect; virtual;
    procedure DoBeforeCreateDatabase; virtual;
    procedure DoAfterCreateDatabase; virtual;
    procedure DoBeforeDropDatabase; virtual;
    procedure DoAfterDropDatabase; virtual;
    procedure DoConnectedChanged; virtual;
    procedure DoReceiveFocus( C: TIB_Connection ); virtual;
  public
  { Inherited Methods }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  { Properties }
    property Connected: boolean read GetConnected;
    property ConnectionStatus: TIB_ConnectionStatus read GetConnectionStatus;
  published
  { Properties }
    property IB_Connection: TIB_Connection read FIB_Connection
                                           write SetIB_Connection;
    property ReceiveFocus: boolean read FReceiveFocus
                                   write FReceiveFocus;
  { Events }
    property BeforeAssignment: TIB_ConnectionLinkEvent
        read FBeforeAssignment
       write FBeforeAssignment;
    property AfterAssignment: TIB_ConnectionLinkEvent
        read FAfterAssignment
       write FAfterAssignment;
    property BeforeExecDDL: TIB_ConnectionLinkEvent
        read FBeforeExecDDL
       write FBeforeExecDDL;
    property AfterExecDDL: TIB_ConnectionLinkEvent
        read FAfterExecDDL
       write FAfterExecDDL;
    property BeforeConnect: TIB_ConnectionLinkEvent
        read FBeforeConnect
       write FBeforeConnect;
    property AfterConnect: TIB_ConnectionLinkEvent
        read FAfterConnect
       write FAfterConnect;
    property BeforeDisconnect: TIB_ConnectionLinkEvent
        read FBeforeDisconnect
       write FBeforeDisconnect;
    property AfterDisconnect: TIB_ConnectionLinkEvent
        read FAfterDisconnect
       write FAfterDisconnect;
    property BeforeCreateDatabase: TIB_ConnectionLinkEvent
        read FBeforeCreateDatabase
       write FBeforeCreateDatabase;
    property AfterCreateDatabase: TIB_ConnectionLinkEvent
        read FAfterCreateDatabase
       write FAfterCreateDatabase;
    property BeforeDropDatabase: TIB_ConnectionLinkEvent
        read FBeforeDropDatabase
       write FBeforeDropDatabase;
    property AfterDropDatabase: TIB_ConnectionLinkEvent
        read FAfterDropDatabase
       write FAfterDropDatabase;
    property OnConnectedChanged: TIB_ConnectionLinkEvent
        read FOnConnectedChanged
       write FOnConnectedChanged;
    property OnReceiveFocus: TIB_ConnectionLinkEvent
        read FOnReceiveFocus
       write FOnReceiveFocus;
  end; { TIB_ConnectionLink }

// IMP_IB_ConnectionLink
