
{                                                                              }
{ TIB_Connection                                                               }
{                                                                              }

  TIB_ConnectionStatus = ( csDisconnected,        csConnected,
                           csDisconnectPending,   csConnectPending,
                           csDropDatabasePending, csCreateDatabasePending,
                           csForcedConnectPending );
                           
  TIB_Protocol = ( cpLocal, cpNetBEUI, cpTCP_IP, cpNovell, cpOther );
  EIB_ConnectionError = class( EIB_Error );
  TIB_ConnectionEvent = procedure( Sender: TIB_Connection ) of object;
  TIB_LoginEvent = procedure(     Sender: TIB_Connection;
                              var Abort: boolean ) of object;

  TIB_ConnectCharacteristics = packed record
    dbAllocation: longint;
    dbLevelPrefix: byte;
    dbBase_Level: byte;
    dbFilePrefix: byte;
    dbFile: string;
    dbSite: string;
    dbImplementationPrefix: byte;
    dbImplementation: byte;
    dbClass: byte;
    dbNo_Reserve: byte;
    dbODS_Minor_Version: word;
    dbODS_Version: word;
    dbPage_Size: word;
    dbVersionPrefix: byte;
    dbVersion: string;
  end;

  TIB_Connection = class( TComponent )
  private
  { Property Access Methods }
    procedure SetIB_Parameters( Value: TStringList );
    function GetPrm( Index: integer ): string;
    procedure SetPrm( Index: integer; Value: string );
    function GetIB_Parameter( Parameter: string ): string;
    procedure SetIB_Parameter( Parameter: string; Value: string );
    function GetForcedWrites: boolean;
    procedure SetForcedWrites( AValue: boolean );
    function GetReservePageSpace: boolean;
    procedure SetReservePageSpace( AValue: boolean );
    function GetBuffers: byte;
    procedure SetBuffers( AValue: byte );
    function GetPageSize: word;
    procedure SetPageSize( AValue: word );
    function GetTransactionCount: integer;
    function GetTransaction( Index: integer ): TIB_Transaction;
    function GetStatementCount: integer;
    function GetStatement( Index: integer ): TIB_Statement;
    function GetDataSetCount: integer;
    function GetDataSet( Index: integer ): TIB_DataSet;
    function GetConnectionLinkCount: integer;
    function GetConnectionLink( Index: integer ): TIB_ConnectionLink;
    function GetPdbHandle: pisc_db_handle;
    procedure SetdbHandle( AValue: isc_db_handle );
    function GetDomainNames: TStrings;
    function GetTableNames: TStrings;
    function GetViewNames: TStrings;
    function GetProcedureNames: TStrings;
    function GetConstraintNames: TStrings;
    function GetTriggerNames: TStrings;
    function GetIndexNames: TStrings;
    function GetPrimaryKeys: TStrings;
    function GetForeignKeys: TStrings;
    function GetRequired: TStrings;
    function GetDefaults: TStrings;
    procedure SetDomainNames( AValue: TStrings );
    procedure SetTableNames( AValue: TStrings );
    procedure SetViewNames( AValue: TStrings );
    procedure SetProcedureNames( AValue: TStrings );
    procedure SetConstraintNames( AValue: TStrings );
    procedure SetTriggerNames( AValue: TStrings );
    procedure SetIndexNames( AValue: TStrings );
    procedure SetPrimaryKeys( AValue: TStrings );
    procedure SetForeignKeys( AValue: TStrings );
    procedure SetRequired( AValue: TStrings );
    procedure SetDefaults( AValue: TStrings );
    function GetProtocol: TIB_Protocol;
    procedure SetProtocol( AValue: TIB_Protocol );
    function GetCharacteristics: TIB_ConnectCharacteristics;
    function GetIB_Session: TIB_Session;
    procedure SetIB_Session( AValue: TIB_Session ); 
  protected
  { Utility storage }
    flag_connect_after_load: boolean;
    flag_domain_name_info_invalid: boolean;
    flag_table_name_info_invalid: boolean;
    flag_view_name_info_invalid: boolean;
    flag_procedure_name_info_invalid: boolean;
    flag_constraint_name_info_invalid: boolean;
    flag_trigger_name_info_invalid: boolean;
    flag_index_name_info_invalid: boolean;
    flag_primary_key_info_invalid: boolean;
    flag_foreign_key_info_invalid: boolean;
    flag_required_info_invalid: boolean;
    flag_defaults_info_invalid: boolean;
    flag_characteristics_info_invalid: boolean;
    flag_junk_value: integer;
  { Property storage fields }
    FdbHandle: isc_db_Handle;
    FIB_SessionLink: TIB_SessionLink; 
    FParameters: TStringList;
    FDomainNames: TStringList;
    FTableNames: TStringList;
    FViewNames: TStringList;
    FProcedureNames: TStringList;
    FConstraintNames: TStringList;
    FTriggerNames: TStringList;
    FIndexNames: TStringList;
    FPrimaryKeys: TStringList;
    FForeignKeys: TStringList;
    FRequired: TStringList;
    FDefaults: TStringList;
    FStatementList: TList;
    FDataSetList: TList;
    FTransactionList: TList;
    FConnectionLinkList: TList;
    FConnectionStatus: TIB_ConnectionStatus;
    FAnnounceFocus: boolean;
    FLoginPrompt: boolean;
    FLoginAttempts: word;
    FLoginAborted: boolean;
    FLoginDBReadOnly: boolean;
    FIB_Session: TIB_Session;
    FPrivateDir: string;
  { Database characteristics }
    FCharacteristics: TIB_ConnectCharacteristics;
  { Event Storage }
    FBeforeExecDDL: TIB_ConnectionEvent;
    FAfterExecDDL: TIB_ConnectionEvent;
    FBeforeConnect: TIB_ConnectionEvent;
    FAfterConnect: TIB_ConnectionEvent;
    FBeforeDisconnect: TIB_ConnectionEvent;
    FAfterDisconnect: TIB_ConnectionEvent;
    FBeforeCreateDatabase: TIB_ConnectionEvent;
    FAfterCreateDatabase: TIB_ConnectionEvent;
    FBeforeDropDatabase: TIB_ConnectionEvent;
    FAfterDropDatabase: TIB_ConnectionEvent;
    FOnConnectedChanged: TIB_ConnectionEvent;
    FOnLogin: TIB_LoginEvent;
    FOnLoginFailure: TIB_ConnectionEvent;
    FOnGainFocus: TIB_ConnectionEvent;
    FOnLoseFocus: TIB_ConnectionEvent;
  { Inherited Methods }
    procedure Loaded; override;
  { Property Access methods }
    function GetDatabase: string; virtual;
    procedure SetDatabase( AValue: string ); virtual;
    procedure SetConnected( Value: boolean); virtual;
    function GetConnected: boolean; virtual;
  { System Methods }
    procedure SysInvalidateOptimizationFlags; virtual;
    procedure SysUpdateDomainNames; virtual;
    procedure SysUpdateTableNames; virtual;
    procedure SysUpdateViewNames; virtual;
    procedure SysUpdateProcedureNames; virtual;
    procedure SysUpdateConstraintNames; virtual;
    procedure SysUpdateTriggerNames; virtual;
    procedure SysUpdateIndexNames; virtual;
    procedure SysUpdatePrimaryKeys; virtual;
    procedure SysUpdateForeignKeys; virtual;
    procedure SysUpdateRequiredColumns; virtual;
    procedure SysUpdateDefaultedColumns; virtual;
    procedure SysUpdateCharacteristics; virtual;
    procedure SysConnectAfterLoad; virtual;
    procedure SysCheckTransactionsAfterLoad; virtual;
    procedure SysCheckStatementsAfterLoad; virtual;
    procedure SysBeforeExecDDL; virtual;
    procedure SysAfterExecDDL; virtual;
    procedure SysCheckSession; virtual;
    procedure SysBeforeConnect; virtual;
    procedure SysLogin; virtual;
    procedure SysBeforeDisconnect; virtual;
    function SysConnect: boolean; virtual;
    procedure SysDisconnect; virtual;
    procedure SysAfterConnect; virtual;
    procedure SysAfterDisconnect; virtual;
    procedure SysCloseTransactions; virtual;
    procedure SysDeallocateStatements; virtual;
    procedure SysStartTransactions; virtual;
    procedure SysCreateDatabase; virtual;
    procedure SysDropDatabase; virtual;
    procedure SysBeforeCreateDatabase; virtual;
    procedure SysBeforeDropDatabase; virtual;
    procedure SysAfterCreateDatabase; virtual;
    procedure SysAfterDropDatabase; virtual;
  { Link handling methods }
    procedure AddConnectionLink( NewLink: TIB_ConnectionLink );
    procedure RemoveConnectionLink( OldLink: TIB_ConnectionLink ); 
  { API level calls }
    procedure API_Connect;
    procedure API_Disconnect;
    procedure API_Database_Info( var Items:  array of Char;
                                 var Buffer: array of Char );
    procedure SQL_CreateDatabase; 
  { Event Dispatch Methods }
    procedure DoBeforeExecDDL; virtual;
    procedure DoAfterExecDDL; virtual;
    procedure DoLogin; virtual;
    procedure DoLoginFailure; virtual;
    procedure DoBeforeConnect; virtual;
    procedure DoAfterConnect; virtual;
    procedure DoBeforeDisconnect; virtual;
    procedure DoAfterDisconnect; virtual;
    procedure DoBeforeCreateDatabase; virtual;
    procedure DoAfterCreateDatabase; virtual;
    procedure DoBeforeDropDatabase; virtual;
    procedure DoAfterDropDatabase; virtual;
    procedure DoConnectedChanged; virtual;
    procedure DoGainFocus; virtual;
    procedure DoLoseFocus; virtual;
  { Link Dispatch Methods }
    procedure DoLinkBeforeExecDDL;
    procedure DoLinkAfterExecDDL;
    procedure DoLinkBeforeConnect;
    procedure DoLinkAfterConnect;
    procedure DoLinkBeforeDisconnect;
    procedure DoLinkAfterDisconnect;
    procedure DoLinkConnectedChanged;
    procedure DoLinkBeforeCreateDatabase;
    procedure DoLinkAfterCreateDatabase;
    procedure DoLinkBeforeDropDatabase;
    procedure DoLinkAfterDropDatabase; 
  { Protected properties }
    property ConnectionLinkCount: integer read GetConnectionLinkCount;
    property ConnectionLinks[ index: integer ]: TIB_ConnectionLink
        read GetConnectionLink;
  { Session stuff }
    procedure BeforeSessionAssignment( OldLink: TIB_SessionLink;
                                       Old: TIB_Session ); 
    procedure BeforeSessionDetach( IB_SessionLink: TIB_SessionLink;
                                   IB_Session: TIB_Session );
  public
  { Inherited Methods }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  { New methods }
    procedure Connect; dynamic;
    procedure Disconnect; dynamic;
    procedure CreateDatabase; dynamic;
    procedure DropDatabase; dynamic;
    procedure SetFocus; dynamic;
  { properties }
    property dbHandle: isc_db_Handle read FdbHandle write SetdbHandle;
    property PdbHandle: pisc_db_Handle read GetPdbHandle;
    property TransactionCount: integer read GetTransactionCount;
    property Transactions[index: integer]: TIB_Transaction read GetTransaction;
    property StatementCount: integer read GetStatementCount;
    property Statements[index: integer]: TIB_Statement read GetStatement;
    property DataSetCount: integer read GetDataSetCount;
    property DataSets[index: integer]: TIB_DataSet read GetDataSet;
    property Parameter[index: string]: string read GetIB_Parameter
                                              write SetIB_Parameter;
    property ConnectionStatus: TIB_ConnectionStatus read FConnectionStatus
                                                    write FConnectionStatus;
    property Characteristics: TIB_ConnectCharacteristics
        read GetCharacteristics;
  published
  { Properties }
{------------------------------------------------------------------------------}
    property _ConnectionLinkCount: integer read GetConnectionLinkCount
                                           write flag_junk_value
                                           stored false;
    property _TransactionCount: integer read GetTransactionCount
                                        write flag_junk_value
                                        stored false;
    property _StatementCount: integer read GetStatementCount
                                      write flag_junk_value
                                      stored false;
    property _DataSetCount: integer read GetDataSetCount
                                    write flag_junk_value
                                    stored false;
{------------------------------------------------------------------------------}
    property IB_Session: TIB_Session read GetIB_Session
                                     write SetIB_Session
                                     stored true; 
    property AnnounceFocus: boolean read FAnnounceFocus  write FAnnounceFocus;
    property LoginPrompt: boolean  read FLoginPrompt write FLoginPrompt;
    property LoginAborted: boolean read FLoginAborted;
    property LoginAttempts: word read FLoginAttempts
                                 write FLoginAttempts
                                 default 3;
    property LoginDBReadOnly: boolean read FLoginDBReadOnly
                                      write FLoginDBReadOnly
                                      default false;
    property Username:    string index  1 read GetPrm write SetPrm stored false;
    property Password:    string index  2 read GetPrm write SetPrm stored false;
    property Server:      string index  3 read GetPrm write SetPrm stored false;
    property Path:        string index  5 read GetPrm write SetPrm stored false;
    property License:     string index  6 read GetPrm write SetPrm stored false;
    property SysDBA:      string index  7 read GetPrm write SetPrm stored false;
    property EncryptKey:  string index  8 read GetPrm write SetPrm stored false;
    property CharSet:     string index  9 read GetPrm write SetPrm stored false;
    property MessageFile: string index 10 read GetPrm write SetPrm stored false;
    property ShadowFile:  string index 11 read GetPrm write SetPrm stored false;
    property Protocol: TIB_Protocol read GetProtocol
                                    write SetProtocol
                                    stored false;
    property ForcedWrites: boolean read GetForcedWrites
                                   write SetForcedWrites
                                   stored false;
    property ReservePageSpace: boolean read GetReservePageSpace
                                       write SetReservePageSpace
                                       stored false;
    property Database: string read GetDatabase write SetDatabase stored false;
    property Buffers: byte read GetBuffers write SetBuffers stored false;
    property PageSize: word read GetPageSize write SetPageSize stored false;
    property Parameters: TStringList read FParameters write SetIB_Parameters;
    property Connected: Boolean read GetConnected write SetConnected;
    property PrivateDir: string read FPrivateDir write FPrivateDir;
    property Info_DomainNames: TStrings read GetDomainNames
                                        write SetDomainNames
                                        stored false;
    property Info_TableNames: TStrings read GetTableNames
                                       write SetTableNames
                                       stored false;
    property Info_ViewNames: TStrings read GetViewNames
                                      write SetViewNames
                                      stored false;
    property Info_ProcedureNames: TStrings read GetProcedureNames
                                           write SetProcedureNames
                                           stored false;
    property Info_ConstraintNames: TStrings read GetConstraintNames
                                            write SetConstraintNames
                                            stored false;
    property Info_TriggerNames: TStrings read GetTriggerNames
                                         write SetTriggerNames
                                         stored false;
    property Info_IndexNames: TStrings read GetIndexNames
                                       write SetIndexNames
                                       stored false;
    property Info_PrimaryKeys: TStrings read GetPrimaryKeys
                                        write SetPrimaryKeys
                                        stored false;
    property Info_ForeignKeys: TStrings read GetForeignKeys
                                        write SetForeignKeys
                                        stored false;
    property Info_Required: TStrings read GetRequired
                                     write SetRequired
                                     stored false;
    property Info_Defaults: TStrings read GetDefaults
                                     write SetDefaults
                                     stored false;
  { New Events }
    property BeforeExecDDL: TIB_ConnectionEvent
       read FBeforeExecDDL
      write FBeforeExecDDL;
    property AfterExecDDL: TIB_ConnectionEvent
       read FAfterExecDDL
      write FAfterExecDDL;
    property BeforeConnect: TIB_ConnectionEvent
       read FBeforeConnect
      write FBeforeConnect;
    property AfterConnect: TIB_ConnectionEvent
       read FAfterConnect
      write FAfterConnect;
    property BeforeDisconnect: TIB_ConnectionEvent
       read FBeforeDisconnect
      write FBeforeDisconnect;
    property AfterDisconnect: TIB_ConnectionEvent
       read FAfterDisconnect
      write FAfterDisconnect;
    property BeforeCreateDatabase: TIB_ConnectionEvent
       read FBeforeCreateDatabase
      write FBeforeCreateDatabase;
    property AfterCreateDatabase: TIB_ConnectionEvent
       read FAfterCreateDatabase
      write FAfterCreateDatabase;
    property BeforeDropDatabase: TIB_ConnectionEvent
       read FBeforeDropDatabase
      write FBeforeDropDatabase;
    property AfterDropDatabase: TIB_ConnectionEvent
       read FAfterDropDatabase
      write FAfterDropDatabase;
    property OnConnectedChanged: TIB_ConnectionEvent
       read FOnConnectedChanged
      write FOnConnectedChanged;
    property OnLogin: TIB_LoginEvent
       read FOnLogin
      write FOnLogin;
    property OnLoginFailure: TIB_ConnectionEvent
       read FOnLoginFailure
      write FOnLoginFailure;
    property OnGainFocus: TIB_ConnectionEvent read FOnGainFocus
                                              write FOnGainFocus;     
    property OnLoseFocus: TIB_ConnectionEvent read FOnLoseFocus
                                              write FOnLoseFocus;
  end; { TIB_Connection }

// IMP_IB_CONNECTION
