
{                                                                              }
{ TIB_Column_Blob                                                              }
{                                                                              }

// I had to grab this out of DBTables.PAS from the VCL.
// I modified it so that there wouldn't be a conflict.
  TIB_GraphicHeader = record
    Count: Word;                { Fixed at 1 }
    HType: Word;                { Fixed at $0100 }
    Size: Longint;              { Size not including header }
  end;

  TIB_Column_Blob = class( TIB_Column )
  private
  { Inherited Property Access methods }
    function GetIsModified: boolean; override;
    procedure SetIsModified( AValue: boolean ); virtual;
    function GetIsBlob: boolean; override;
    function GetOldAsString: string; override;
    function GetAsString: string; override;
    function GetAsVariant: Variant; override;
    procedure SetAsString( NewValue: string); override;
  { Property Access methods }
    function GetBlob_ID: isc_quad; virtual;
    function GetPBlob_ID: pisc_quad; virtual;
    function GetPBlob_Handle: pisc_blob_handle; virtual;
    function GetPBlob_Desc: pisc_blob_desc; virtual;
    procedure SetAutoLoad( AValue: boolean ); virtual;
    procedure SetSegmentBufferSize( NewSize: short ); virtual;
    function GetAsStream: TStream; virtual;
    function GetOldAsStream: TStream; virtual; 
    function GetIsText: boolean; virtual; 
    function GetSQLTypeSource: string; override;
  protected
  { General storage }
    FIB_Session: TIB_Session;
    FBlob_Desc: isc_blob_desc;
    FBlob_Handle: isc_blob_handle;
    FBlob_Parameter_Block: array [0..255] of char;
    FAutoLoad: boolean;
    FIsLoaded: boolean;
    FIsModified: boolean;
    FIsOldLoaded: boolean;
    FLoaded_Blob_ID: isc_quad;
    FSegmentBufferSize: short;
    FValidSegmentSize: short;
    FSegmentBuffer: pointer;
    FNumOfSegments: longint;    // total number of segments.
    FMaxSegmentSize: longint;   // Size, in bytes, of the longest segment.
    FTotalSize: longint;        // total size, in bytes, of BLOB.
    FBlobType: smallint;        // type of BLOB.0 (segmented)1 (reserved)
    FStream: TStream;
    FOldStream: TStream;
  { Inherited methods }
    procedure SysBeforeModify; override;
    procedure SysAfterModify; override;
  { Abstract Methods }
    procedure SysClearSegments; virtual;
  { Row synchronization methods }
    procedure ClearBuffers; virtual;
    procedure PostBuffers; virtual;
    procedure CancelBuffers; virtual;
    procedure RefreshBuffers; virtual;
  { System Methods }
    procedure SysLoad; virtual;
    procedure SysStore; virtual;
    procedure SysCancel; virtual;
  { API calls }
    procedure API_get_segments;
    procedure API_put_segments;
    procedure API_open_blob;
    procedure API_open_blob2;
    procedure API_create_blob2;
    procedure API_blob_default_desc;
    procedure API_blob_gen_bpb;
    procedure API_blob_info;
    procedure API_blob_lookup_desc;
    procedure API_blob_set_desc;
    procedure API_cancel_blob;
    procedure API_close_blob; 
  { Utility methods }
    procedure LoadFromBlob( Blob: TIB_Column_Blob );
    procedure LoadFromBitmap( Bitmap: TBitmap );
    procedure LoadFromStrings( Strings: TStrings );
    procedure LoadFromFile( const FileName: string );
    procedure LoadFromStream( Stream: TStream );
    procedure SaveToFile( const FileName: string );
    procedure SaveToStream( Stream: TStream );
    procedure SaveToBitmap( Bitmap: TBitmap );
    procedure SaveToStrings( Strings: TStrings );
  { Properties }
    property SegmentBufferSize: short read FSegmentBufferSize
                                      write SetSegmentBufferSize;
  public
    constructor Create( AIB_Row: TIB_Row; AIndex: smallint ); override;
    destructor Destroy; override;
  { Methods }
    procedure Load; virtual;
    procedure Store; virtual;
    procedure Clear; override;
    procedure AssignTo( Dest: TObject ); virtual;
    procedure Assign( Source: TObject ); virtual;
  { Properties }
    property IB_Session: TIB_Session read FIB_Session;
    property Blob_ID: isc_quad read GetBlob_ID;
    property PBlob_ID: pisc_quad read GetPBlob_ID;
    property Blob_Handle: isc_blob_handle read FBlob_Handle;
    property PBlob_Handle: pisc_blob_handle read GetPBlob_Handle;
    property Blob_Desc: isc_blob_desc read FBlob_Desc;
    property PBlob_Desc: pisc_blob_desc read GetPBlob_Desc;
    property IsLoaded: boolean read FIsLoaded;
    property NumOfSegments: longint read FNumOfSegments;
    property MaxSegmentSize: longint read FMaxSegmentSize;
    property TotalSize: longint read FTotalSize;
    property BlobType: smallint read FBlobType;
    property IsText: boolean read GetIsText;
    property AsStream: TStream read GetAsStream;
    property OldAsStream: TStream read GetOldAsStream;
  published
    property AutoLoad: boolean read FAutoLoad write SetAutoLoad;
  end;

{                                                                              }
{ TIB_Column_Binary                                                            }
{                                                                              }

  TIB_Column_Binary = class( TIB_Column_Blob )
  end;

{                                                                              }
{ TIB_Column_Memo                                                              }
{                                                                              }

  TIB_Column_Memo = class( TIB_Column_Blob )
  private
    function GetIsText: boolean; override;
  end;

// IMP_IB_COLUMN_BLOB
