
{                                                                              }
{   TIB_ColumnLink                                                             }
{                                                                              }

  TIB_ColumnLink = class( TIB_DataLink )
  private
    FColumnName: string;
    FColumnType: integer;
    FColumn: TIB_Column;
    procedure SetColumnName( AValue: string ); virtual;
    procedure SetColumnText( AValue: string ); virtual;
    function GetColumnText: string; virtual;
    function GetInvalidText: string; virtual;
    function GetColumnAlignment: TAlignment; virtual;
    function GetColumnEditmask: string; virtual;
    function GetColumnMaxLength: integer; virtual;
    function GetReadOnly: boolean; override;
    function GetColor: TColor; override;
    function GetUpdatingColor: TColor; override;
    function GetInsertingColor: TColor; override;
    procedure SetSearchBuffer( AValue: string ); override;
  protected
    procedure SysDataChanged( AColumn: TIB_Column ); override;
    procedure SysUpdateData( AColumn: TIB_Column ); override;
    procedure SysAfterUpdateDescriptors; override;
    procedure DoPrepareSQL; override;
    procedure DoAfterAssignment; override;
    function Modify: boolean; override;
    procedure SysAssignColumn; virtual;
    procedure DoAssignColumn; virtual;
  public
  { Events }
    OnAssignColumn: TIB_ColumnDataLinkEvent;
  { Methods }
    procedure UpdateValue; override;
  { Properties }
    property ColumnName: string read FColumnName write SetColumnName;
    property ColumnType: integer read FColumnType;
    property Column: TIB_Column read FColumn;
    property ColumnText: string read GetColumnText write SetColumnText;
    property ColumnAlignment: TAlignment read GetColumnAlignment;
    property ColumnEditMask: string read GetColumnEditmask;
    property ColumnMaxLength: integer read GetColumnMaxLength;
  end;

// IMP_IB_ColumnLink
