
{                                                                              }
{ TIB_Column                                                                   }
{                                                                              }

  TIB_ColumnEvent = procedure( Sender: TIB_Column ) of object;

  TIB_Column = class( TObject )
  private
  { Property access methods }
    function GetSQLName:    string;
    function GetRelName:    string;
    function GetOwnerName:  string;
    function GetAliasName:  string;
    function GetDomainName: string;
    function GetSQLType:    smallInt;
    function GetSQLScale:   smallInt;
    function GetSQLSubType: smallInt;
    function GetSQLLen:     smallInt;
    function GetReadOnly: boolean; virtual;
    function GetIsModified: boolean; virtual;
    function GetIsCalculated: boolean; virtual;
    function GetIsRequired: boolean; virtual;
    function GetIsNullable: boolean; virtual;
    function GetIsPrimary: boolean; virtual;
    function GetIsForeign: boolean; virtual;
    function GetIsDefaulted: boolean; virtual;
    function GetIsIndexed: boolean; virtual;
    function GetIsAlternate: boolean; virtual;
    function GetOldIsNull: boolean; virtual;
    function GetOldAsString: string; virtual;
    function GetIsNull: boolean; virtual;
    function GetAsString: string; virtual;
    function GetAsDateTime: TDateTime; virtual;
    function GetAsInteger: integer; virtual;
    function GetAsFloat: real; virtual;
    function GetAsSmallInt: smallint; virtual;
    function GetAsDouble: double; virtual;
    function GetAsExtended: extended; virtual;
    function GetAsVariant: Variant; virtual;
    function GetIsBlob: boolean; virtual;
  { Property Manipulation Methods }
    procedure SetAliasName( AValue: string ); virtual;
    procedure SetIsNull( NewValue: boolean); virtual;
    procedure SetAsString( NewValue: string); virtual;
    procedure SetAsDateTime( NewValue: TDateTime); virtual;
    procedure SetAsInteger( NewValue: integer); virtual;
    procedure SetAsFloat( NewValue: real); virtual;
    procedure SetAsSmallInt( NewValue: smallint); virtual;
    procedure SetAsDouble( NewValue: double); virtual;
    procedure SetAsExtended( NewValue: extended); virtual;
    procedure SetAsVariant( NewValue: Variant ); virtual;
    procedure SetAlignment( AValue: TAlignment ); virtual;
    procedure SetDisplayMask( AValue: string ); virtual;
    function GetDisplayName: string; virtual;
    function GetSQLTypeSource: string; virtual;
  protected
    FIB_Session: TIB_Session;
    FIB_Row: TIB_Row;
    FSQLIndex: smallint;
    FReadOnly: boolean;    { User definable storage field. }
    FAlignment: TAlignment;
    FDisplayMask: string;
    FDisplayName: string;
    FSysReadOnly: boolean; { System flag used to lock down columns. }
    FPXSQLVAR: PXSQLVAR;
    FFieldBufferLength: word;
    FOldFieldInd: ^smallint;
    FNewFieldInd: ^smallint;
    FOldFieldBuffer: pointer;
    FNewFieldBuffer: pointer;
    FDomainName: string;
    FOnBeforeModify: TIB_ColumnEvent;
    FOnAfterModify: TIB_ColumnEvent;
  { System methods }
    procedure SysInitBuffer; virtual;
    procedure SysFreeBuffer; virtual;
    procedure SysBeforeModify; virtual;
    procedure SysAfterModify; virtual;
    procedure SysSetIsNull( NewValue: boolean ); virtual;
  { Event dispatch methods }
    procedure DoBeforeModify; virtual;
    procedure DoAfterModify; virtual;
  public
    constructor Create( AIB_Row: TIB_Row; ASQLIndex: smallint ); virtual;
    destructor Destroy; override;
  { Methods }
    function IsValidChar( AChar: Char ): boolean; virtual;
    procedure Clear; virtual; 
  { Properties }
    property IB_Session: TIB_Session read FIB_Session;
    property IB_Row: TIB_Row read FIB_Row;
    property SQLIndex: smallint read FSQLIndex;
    property PSQLVAR: PXSQLVAR read FPXSQLVAR;
    property SQLName:    string read GetSQLName;
    property RelName:    string read GetRelName;
    property OwnerName:  string read GetOwnerName;
    property AliasName:  string read GetAliasName;
    property DomainName: string read GetDomainName;
    property SQLTypeSource: string read GetSQLTypeSource;
    property SQLType:    smallInt read GetSQLtype;
    property SQLScale:   smallInt read GetSQLscale;
    property SQLSubType: smallInt read GetSQLsubtype;
    property SQLLen:     smallInt read GetSQLLen;
    property IsModified:   boolean read GetIsModified;
    property IsCalculated: boolean read GetIsCalculated;
    property IsDefaulted:  boolean read GetIsDefaulted;
    property IsRequired:   boolean read GetIsRequired;
    property IsNullable:   boolean read GetIsNullable;
    property IsPrimary:    boolean read GetIsPrimary;
    property IsForeign:    boolean read GetIsForeign;
    property IsIndexed:    boolean read GetIsIndexed;
    property IsAlternate:  boolean read GetIsAlternate;
    property AsString: string read GetAsString write SetAsString;
    property AsDateTime: TDateTime read GetAsDateTime write SetAsDateTime;
    property AsInteger: integer read GetAsInteger write SetAsInteger;
    property AsFloat: real read GetAsFloat write SetAsFloat;
    property IsNull: boolean read GetIsNull write SetIsNull;
    property OldAsString: string read GetOldAsString;
    property OldIsNull: boolean read GetOldIsNull;
    property IsBlob: boolean read GetIsBlob;
  published
  { Properties }
    property Alignment: TAlignment read FAlignment write SetAlignment;
    property DisplayName: string read GetDisplayName write FDisplayName;
    property DisplayMask: string read FDisplayMask write SetDisplayMask;
    property ReadOnly: boolean read GetReadOnly;
  { Events }
    property OnBeforeModify: TIB_ColumnEvent read FOnBeforeModify
                                             write FOnBeforeModify;
    property OnAfterModify: TIB_ColumnEvent read FOnBeforeModify
                                            write FOnBeforeModify;
  end;

  TIB_Column_Numeric = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: extended; virtual;
    procedure SetValue( NewValue: extended ); virtual;
    function GetSQLTypeSource: string; override;
  public
    property Value: extended read GetValue write SetValue;
  end;

  TIB_Column_Float = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: single; virtual;
    procedure SetValue( NewValue: single ); virtual;
  public
    property Value: single read GetValue write SetValue;
  end;

  TIB_Column_Double = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: double; virtual;
    procedure SetValue( NewValue: double ); virtual;
  public
    property Value: double read GetValue write SetValue;
  end;

  TIB_Column_SmallInt = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: smallint; virtual;
    procedure SetValue( NewValue: smallint ); virtual;
  public
    property Value: smallint read GetValue write SetValue;
  end;

  TIB_Column_Integer = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: integer; virtual;
    procedure SetValue( NewValue: integer ); virtual;
  public
    property Value: integer read GetValue write SetValue;
  end;

  TIB_Column_DateTime = class( TIB_Column )
  protected
//    FYear:  word;
//    FMonth: word;
//    FDay:   word;
//    FHour:  word;
//    FMin:   word;
//    FSec:   word;
//    FMSec:  word;
//    FTMSec: word;
//    FCDateTime: TM;
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: TDateTime; virtual;
    procedure SetValue( NewValue: TDateTime ); virtual;
  public
    property Value: TDateTime read GetValue write SetValue;
//    property Year:  word read FYear;
//    property Month: word read FMonth;
//    property Day:   word read FDay;
//    property Hour:  word read FHour;
//    property Min:   word read FMin;
//    property Sec:   word read FSec;
//    property MSec:  word read FMSec;
//    property TMSec: word read FTMsec;
//    property CDateTime: TM read FCDateTime;
  end;

  TIB_Column_Text = class( TIB_Column )
  protected
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
    function GetValue: string; virtual;
    procedure SetValue( NewValue: string ); virtual;
  public
    property Value: string read GetValue write SetValue;
  end;

  TIB_Column_VarText = class( TIB_Column_Text )
  protected
    function GetValue: string; override;
    procedure SetValue( NewValue: string ); override;
  end;

// IMP_IB_Column
