
  PIB_Bookmark = ^TIB_Bookmark;
  TIB_Bookmark = record
    Prev,
    Next: PIB_Bookmark;
    KeyData,
    RecordData: Pointer;
    RecordValid: boolean;
  end;

  TIB_BookmarkList = class
  private
    FKeyDataLength: word;
    FRecordDataLength: word;
    FItemCount: longint;
    FFreeCount: longint;
    FListHead,
    FListTail: TIB_Bookmark;
    FFreeList,
    FCurrent: PIB_Bookmark;
    FPosition: longint;
  { Property Access Methods }
    procedure SetPosition( AValue: longint );
  protected
  { Utility Methods }
    procedure Initialize;
    function CreateNode: PIB_Bookmark;
    procedure DestroyNode( AValue: PIB_Bookmark );
    function GetNode: PIB_Bookmark;
    procedure FreeNode( AValue: PIB_Bookmark );
  public
    constructor Create( NewKeyDataLength,
                        NewRecordDataLength: word ); virtual;
    destructor Destroy; override;
    function Add: PIB_Bookmark;
    procedure Remove( Pos: longint );
    procedure RemoveAll;
    function Append( var PNewBookmark: PIB_Bookmark ): longint;
    function Insert: PIB_Bookmark;
    procedure Delete;
    procedure Clear;
    function PositionOf( KeyData: Pointer ): longint;
    function BookmarkOf( Pos: longint ): PIB_Bookmark;
  { Properties }
    property Position: longint read FPosition write SetPosition;
    property Current: PIB_Bookmark read FCurrent;
    property ItemCount: longint read FItemCount;
    property FreeCount: longint read FFreeCount;
    property KeyDataLength: word read FKeyDataLength;
    property RecordDataLength: word read FRecordDataLength;
  end;

//  IMP_IB_Bookmark