{------------------------------------------------------------------------------}
{   TIB_Column_Blob                                                            }
{------------------------------------------------------------------------------}

  TIB_Column_Blob = class( TIB_Column )
  private
  { Inherited Property Access methods }
    function GetOldAsString: string; override;
    function GetNowAsString: string; override;
    function GetAsString: string; override;
    procedure SetAsString( NewValue: string); override;
  { Property Access methods }
    function GetBlob_ID: isc_quad; virtual;
    function GetPBlob_ID: pisc_quad; virtual;
    function GetPBlob_Handle: pisc_blob_handle; virtual;
    function GetPBlob_Desc: pisc_blob_desc; virtual;
    function GetBlob_Opened: boolean; virtual;
    function GetNeedToOpen: boolean; virtual;
    function GetNeedToClose: boolean; virtual;
    function GetNeedToRead: boolean; virtual;
    function GetNeedToWrite: boolean; virtual;
    procedure SetAutoOpen( AValue: boolean ); virtual;
  protected
  { General storage }
    FBlob_Desc: isc_blob_desc;
    FBlob_Handle: isc_blob_handle;
    FAutoOpen: boolean;
    FBlob_Open: boolean;
    FBlob_Read_Blob_ID: isc_quad;
    FBlob_Write_Blob_ID: isc_quad;
    FBlob_Info_Buffer:     array [0..255] of char;
    FBlob_Result_Buffer:   array [0..255] of char;
    FBlob_Parameter_Block: array [0..255] of char;
    FSegmentBufferLength: short;
    FReturnedSegmentLength: short;
    FSubmittingSegmentLength: short;
    FSegmentBuffer: pointer;
  { System Methods }
    procedure SysOpenBlob; virtual;
    procedure SysCloseBlob; virtual;
    procedure SysCancelBlob; virtual;
    procedure SysLookupBlobDesc; virtual;
    procedure SysAllocateSegmentBuffer; virtual;
    procedure SysFreeSegmentBuffer; virtual;
  { API calls }
    procedure API_get_segment; virtual;
    procedure API_put_segment; virtual;
    procedure API_open_blob; virtual;
    procedure API_open_blob2; virtual;
    procedure API_blob_default_desc; virtual;
    procedure API_blob_gen_bpb; virtual;
    procedure API_blob_info; virtual;
    procedure API_blob_lookup_desc; virtual;
    procedure API_blob_set_desc; virtual;
    procedure API_cancel_blob; virtual;
    procedure API_close_blob; virtual;
  { Properties }
    property NeedToOpen: boolean read GetNeedToOpen;
    property NeedToClose: boolean read GetNeedToClose;
    property Blob_Opened: boolean read GetBlob_Opened;
  public
    constructor Create( AOwner: TIB_Row; AIndex: smallint ); override;
    destructor Destroy; override;
  { Methods }
    procedure OpenBlob; virtual;
    procedure CloseBlob; virtual;
  { Properties }
    property Blob_ID: isc_quad read GetBlob_ID;
    property PBlob_ID: pisc_quad read GetPBlob_ID;
    property Blob_Handle: isc_blob_handle read FBlob_Handle;
    property PBlob_Handle: pisc_blob_handle read GetPBlob_Handle;
    property Blob_Desc: isc_blob_desc read FBlob_Desc;
    property PBlob_Desc: pisc_blob_desc read GetPBlob_Desc;
  published
    property AutoOpen: boolean read FAutoOpen write SetAutoOpen;
  end;

// IMP_IB_BLOB
