{------------------------------------------------------------------------------}

{$INCLUDE INT_IB_Bookmark}

  TIB_BDataSet = class( TIB_DataSet )
  private
    FCursor: TIB_Cursor;
    FHaveCursor: boolean;
    FBookmarkList: TIB_BookmarkList;
    FRowNum: longint;
    FRowCount: longint;
    FRowsInsertedCount: longint;
    FRowsDeletedCount: longint;
    FCacheRecordData: boolean;
    procedure SetIB_Connection( AValue: TIB_Connection ); override;
    procedure SetIB_Transaction( AValue: TIB_Transaction ); override;
    function GetCanUpdate: boolean; override;
    function GetCanInsert: boolean; override;
    function GetCanDelete: boolean; override;
    function GetOutputRow: TIB_Row; override;
    function GetRowNum: longint; override;
    procedure SetRowNum( AValue: longint ); override;
    function GetUnidirectional: boolean; override;
    function GetBOF: boolean; override;
    function GetEOF: boolean; override;
  protected
    procedure SysPrepareSQL; override;
    procedure SysUpdateDescriptors; override;
    procedure SysAfterUnprepare; override;
    procedure SysAfterFetchCursorRow; override;
    procedure SysAfterClose; override;
    procedure SysFirstRow; override;
    procedure SysMoveByRow( IncRows: longint ); override;
    procedure SysLastRow; override;
    procedure SysUpdateCursorRow; override;
    procedure SysUpdateRow; override;
    procedure SysInsertRow; override;
    procedure SysDeleteRow; override;
  protected
    procedure SysScroll( NeedCursor: boolean ); virtual;
    property HaveCursor: boolean read FHaveCursor;
  public
    constructor Create( AOwner: TComponent ); override;
    destructor Destroy; override;
    property IsRowLocked;
  published
  { Published properties }
    property CacheRecordData: boolean read FCacheRecordData
                                      write FCacheRecordData
                                      default false;
{}
    property SQL;
    property SQLSelect;
    property SQLFrom;
    property SQLWhere;
    property SQLGroup;
    property SQLHaving;
    property SQLUnion;
    property SQLPlan;
    property SQLOrder;
    property Active;
    property Prepared;
{}
  end;  { TIB_BDataSet }

// IMP_IB_BDataSet
