
  TIB_Text = class( TCustomLabel )
  private
    FIB_ColumnLink: TIB_ColumnLink;
    function GetDataColumnName: string;
    function GetDataSetLink: TIB_DataSetLink;
    function GetColumn: TIB_Column;
    procedure SetDataColumnName(const Value: string);
    procedure SetDataSetLink(Value: TIB_DataSetLink);
    procedure DataChanged( Sender: TIB_DataLink;
                           IB_DataSetLink: TIB_DataSetLink;
                           IB_Column: TIB_Column );
  protected
    function GetLabelText: string; override;
    procedure SysDataChanged; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Column: TIB_Column read GetColumn;
  published
    property Align;
    property Alignment;
    property AutoSize default false;
    property Color;
    property DataColumnName: string read GetDataColumnName
                                    write SetDataColumnName;
    property DataSetLink: TIB_DataSetLink read GetDataSetLink
                                          write SetDataSetLink;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property Transparent;
    property ShowHint;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

// IMP_IBC_TEXT
