
{ TIB_RichEdit }

  TIB_RichEdit = class(TCustomRichEdit)
  private
    FIB_ColumnLink: TIB_ColumnLink;
    FAutoDisplay: boolean;
    FFocused: boolean;
    FMemoLoaded: boolean;
    FPaintControl: TPaintControl;
    FIgnoreChange: boolean;
    procedure StateChanged( Sender: TIB_DataLink;
                            IB_DataSetLink: TIB_DataSetLink );
    procedure DataChanged( Sender: TIB_DataLink;
                           IB_DataSetLink: TIB_DataSetLink;
                           IB_Column: TIB_Column );
    procedure UpdateData( Sender: TIB_DataLink;
                          IB_DataSetLink: TIB_DataSetLink;
                          IB_Column: TIB_Column );
    procedure SetSearchBuffer( AValue: string );
    function GetSearchBuffer: string;
    procedure SetDataColumnName( const AValue: string );
    function GetDataColumnName: string;
    procedure SetDataSetLink( AValue: TIB_DataSetLink );
    function GetDataSetLink: TIB_DataSetLink;
    function GetColumn: TIB_Column;
    procedure SetReadOnly(Value: Boolean);
    procedure SetPreventUpdating( Value: Boolean );
    procedure SetPreventInserting( Value: Boolean );
    procedure SetPreventSearching( Value: Boolean );
    function GetReadOnly: Boolean;
    function GetPreventUpdating: Boolean;
    function GetPreventInserting: Boolean;
    function GetPreventSearching: Boolean;
    procedure SetOnPrepareSQL( AValue: TIB_DataLinkEvent); virtual;
    function GetOnPrepareSQL: TIB_DataLinkEvent; virtual;
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetFocused(Value: Boolean);
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure CMGetDataLink(var Message: TMessage); message CM_GETDATALINK;
  protected
  { Inherited Methods }
    procedure Loaded; override;
    procedure Change; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure WndProc(var Message: TMessage); override;
  { System Methods }
    procedure SysDataChanged; virtual;
    procedure SysStateChanged; virtual;
    procedure SysUpdateData; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure LoadMemo;
    property Column: TIB_Column read GetColumn;
    property MemoLoaded: boolean read FMemoLoaded;
    property SearchBuffer: string read GetSearchBuffer write SetSearchBuffer;
  published
    property Align;
    property Alignment;
    property BorderStyle;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property MaxLength;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ScrollBars;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property WantTabs;
    property WordWrap;

    property AutoDisplay: Boolean read FAutoDisplay
                                  write SetAutoDisplay
                                  default true;
    property DataColumnName: string read GetDataColumnName
                                    write SetDataColumnName;
    property DataSetLink: TIB_DataSetLink read GetDataSetLink
                                          write SetDataSetLink;
    property ReadOnly: boolean read GetReadOnly
                               write SetReadOnly
                               default false;
    property PreventUpdating: boolean read GetPreventUpdating
                                      write SetPreventUpdating
                                      default false;
    property PreventInserting: boolean read GetPreventInserting
                                       write SetPreventInserting
                                       default false;
    property PreventSearching: boolean read GetPreventSearching
                                       write SetPreventSearching
                                       default false;

    property OnPrepareSQL: TIB_DataLinkEvent read GetOnPrepareSQL
                                             write SetOnPrepareSQL;

    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

// IMP_IBC_RichEdit
