
{ TIB_ListBox }

  TIB_ListBox = class(TCustomListBox)
  private
    FIB_ColumnLink: TIB_ColumnLink;
    procedure StateChanged( Sender: TIB_DataLink;
                            IB_DataSetLink: TIB_DataSetLink );
    procedure DataChanged( Sender: TIB_DataLink;
                           IB_DataSetLink: TIB_DataSetLink;
                           IB_Column: TIB_Column );
    procedure UpdateData( Sender: TIB_DataLink;
                          IB_DataSetLink: TIB_DataSetLink;
                          IB_Column: TIB_Column );
    function GetSearchBuffer: string;
    procedure SetSearchBuffer( AValue: string );
    procedure SetDataColumnName( const AValue: string );
    procedure SetDataSetLink( AValue: TIB_DataSetLink );
    function GetReadOnly: Boolean;
    function GetPreventUpdating: Boolean;
    function GetPreventInserting: Boolean;
    function GetPreventSearching: Boolean;
    procedure SetReadOnly(Value: Boolean);
    procedure SetPreventUpdating( Value: Boolean );
    procedure SetPreventInserting( Value: Boolean );
    procedure SetPreventSearching( Value: Boolean );
    function GetDataColumnName: string;
    function GetDataSetLink: TIB_DataSetLink;
    function GetColumn: TIB_Column;
    procedure SetOnPrepareSQL( AValue: TIB_DataLinkEvent); virtual;
    function GetOnPrepareSQL: TIB_DataLinkEvent; virtual;
    procedure SetItems(Value: TStrings);
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    procedure Click; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Loaded; override;
    procedure SysDataChanged; virtual;
    procedure SysStateChanged; virtual;
    procedure SysUpdateData; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property SearchBuffer: string read GetSearchBuffer write SetSearchBuffer;
    property Column: TIB_Column read GetColumn;
  published
    property Align;
    property BorderStyle;
    property Color;
    property Ctl3D default true;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property IntegralHeight;
    property ItemHeight;
    property Items write SetItems;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Style;
    property TabOrder;
    property TabStop;
    property Visible;

    property DataColumnName: string read GetDataColumnName
                                    write SetDataColumnName;
    property DataSetLink: TIB_DataSetLink read GetDataSetLink
                                          write SetDataSetLink;
    property ReadOnly: boolean read GetReadOnly
                               write SetReadOnly
                               default false;
    property PreventUpdating: boolean read GetPreventUpdating
                                      write SetPreventUpdating
                                      default false;
    property PreventInserting: boolean read GetPreventInserting
                                       write SetPreventInserting
                                       default false;
    property PreventSearching: boolean read GetPreventSearching
                                       write SetPreventSearching
                                       default false;

    property OnPrepareSQL: TIB_DataLinkEvent read GetOnPrepareSQL
                                             write SetOnPrepareSQL;

    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawItem;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMeasureItem;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

// IMP_IBC_LISTBOX
