
{ TIB_Image }

  TIB_Image = class(TCustomControl)
  private
    FIB_ColumnLink: TIB_ColumnLink;
    FPicture: TPicture;
    FBorderStyle: TBorderStyle;
    FAutoDisplay: boolean;
    FStretch: boolean;
    FCenter: boolean;
    FPictureLoaded: boolean;
    FBlobIDLoaded: isc_quad; 
    FQuickDraw: boolean;
    procedure DataChanged( Sender: TIB_DataLink;
                           IB_DataSetLink: TIB_DataSetLink;
                           IB_Column: TIB_Column );
    procedure UpdateData( Sender: TIB_DataLink;
                          IB_DataSetLink: TIB_DataSetLink;
                          IB_Column: TIB_Column );
    function GetSearchBuffer: string;
    procedure SetSearchBuffer( AValue: string );
    procedure SetDataColumnName( const AValue: string );
    procedure SetDataSetLink( AValue: TIB_DataSetLink );
    function GetReadOnly: Boolean;
    function GetPreventUpdating: Boolean;
    function GetPreventInserting: Boolean;
    procedure SetReadOnly(Value: Boolean);
    procedure SetPreventUpdating( Value: Boolean );
    procedure SetPreventInserting( Value: Boolean );
    function GetDataColumnName: string;
    function GetDataSetLink: TIB_DataSetLink;
    function GetColumn: TIB_Column;
    procedure PictureChanged(Sender: TObject);
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetCenter(Value: Boolean);
    procedure SetPicture(Value: TPicture);
    procedure SetStretch(Value: Boolean);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Paint; override;
    procedure Loaded; override;
    procedure SysDataChanged;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyToClipboard;
    procedure CutToClipboard;
    procedure LoadPicture;
    procedure PasteFromClipboard;
    property Column: TIB_Column read GetColumn;
    property Picture: TPicture read FPicture write SetPicture;
    property SearchBuffer: string read GetSearchBuffer write SetSearchBuffer;
  published
    property Align;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;

    property AutoDisplay: Boolean read FAutoDisplay
                                  write SetAutoDisplay
                                  default True;
    property BorderStyle: TBorderStyle read FBorderStyle
                                       write SetBorderStyle
                                       default bsSingle;
    property Center: Boolean read FCenter
                             write SetCenter
                             default True;
    property DataColumnName: string read GetDataColumnName
                                    write SetDataColumnName;
    property DataSetLink: TIB_DataSetLink read GetDataSetLink
                                          write SetDataSetLink;
    property ReadOnly: boolean read GetReadOnly
                               write SetReadOnly
                               default false;
    property PreventUpdating: boolean read GetPreventUpdating
                                      write SetPreventUpdating
                                      default false;
    property PreventInserting: boolean read GetPreventInserting
                                       write SetPreventInserting
                                       default false;

    property QuickDraw: Boolean read FQuickDraw
                                write FQuickDraw
                                default True;
    property ShowHint;
    property Stretch: Boolean read FStretch
                              write SetStretch
                              default False;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

// IMP_IBC_Image