{ TIB_Edit }

  TIB_Edit = class(TCustomMaskEdit)
  private
    FIB_ColumnLink: TIB_ColumnLink;
    FCanvas: TControlCanvas;
    FAlignment: TAlignment;
    FFocused: boolean;
    procedure StateChanged( Sender: TIB_DataLink;
                            IB_DataSetLink: TIB_DataSetLink );
    procedure DataChanged( Sender: TIB_DataLink;
                           IB_DataSetLink: TIB_DataSetLink;
                           IB_Column: TIB_Column );
    procedure UpdateData( Sender: TIB_DataLink;
                          IB_DataSetLink: TIB_DataSetLink;
                          IB_Column: TIB_Column );
    procedure SetSearchBuffer( AValue: string );
    function GetSearchBuffer: string;
    procedure SetDataColumnName( const AValue: string );
    function GetDataColumnName: string;
    procedure SetDataSetLink( AValue: TIB_DataSetLink );
    function GetDataSetLink: TIB_DataSetLink;
    function GetColumn: TIB_Column;
    procedure SetReadOnly(Value: Boolean);
    procedure SetPreventUpdating( Value: Boolean );
    procedure SetPreventInserting( Value: Boolean );
    procedure SetPreventSearching( Value: Boolean );
    function GetReadOnly: Boolean;
    function GetPreventUpdating: Boolean;
    function GetPreventInserting: Boolean;
    function GetPreventSearching: Boolean;
    procedure SetOnPrepareSQL( AValue: TIB_DataLinkEvent); virtual;
    function GetOnPrepareSQL: TIB_DataLinkEvent; virtual;
    function GetTextMargins: TPoint;
    procedure SetFocused(Value: Boolean);
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
  protected
    function EditCanModify: Boolean; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Reset; override;
    procedure Loaded; override;
    procedure Change; override;
    procedure SysDataChanged; virtual;
    procedure SysStateChanged; virtual;
    procedure SysUpdateData; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Column: TIB_Column read GetColumn;
    property SearchBuffer: string read GetSearchBuffer write SetSearchBuffer;
  published
    property AutoSelect;
    property AutoSize;
    property BorderStyle;
    property CharCase;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property MaxLength;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PasswordChar;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;

    property DataColumnName: string read GetDataColumnName
                                    write SetDataColumnName;
    property DataSetLink: TIB_DataSetLink read GetDataSetLink
                                          write SetDataSetLink;
    property ReadOnly: boolean read GetReadOnly
                               write SetReadOnly
                               default false;
    property PreventUpdating: boolean read GetPreventUpdating
                                      write SetPreventUpdating
                                      default false;
    property PreventInserting: boolean read GetPreventInserting
                                       write SetPreventInserting
                                       default false;
    property PreventSearching: boolean read GetPreventSearching
                                       write SetPreventSearching
                                       default false;

    property OnPrepareSQL: TIB_DataLinkEvent read GetOnPrepareSQL
                                             write SetOnPrepareSQL;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

// IMP_IBC_Edit
