// INT_IBC_Text 

constructor TIB_Text.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  AutoSize := false;
  ShowAccelChar := false;
  FIB_ColumnLink := TIB_ColumnLink.Create( Self );
  with FIB_ColumnLink do begin
    OnDataChanged := DataChanged;
  end;
end;

destructor TIB_Text.Destroy;
begin
  DataSetLink := nil;
  with FIB_ColumnLink do begin
    OnDataChanged  := nil;
  end;
  inherited Destroy;
end;

{------------------------------------------------------------------------------}

procedure TIB_Text.DataChanged( Sender: TIB_DataLink;
                                IB_DataSetLink: TIB_DataSetLink;
                                IB_Column: TIB_Column );
begin
  SysDataChanged;
end;

procedure TIB_Text.SysDataChanged;
begin
  Caption := FIB_ColumnLink.ColumnText;
end;

{------------------------------------------------------------------------------}

function TIB_Text.GetDataSetLink: TIB_DataSetLink;
begin
  Result := FIB_ColumnLink.IB_DataSetLink;
end;

procedure TIB_Text.SetDataSetLink(Value: TIB_DataSetLink);
begin
  FIB_ColumnLink.IB_DataSetLink := Value;
end;

function TIB_Text.GetDataColumnName: string;
begin
  Result := FIB_ColumnLink.ColumnName;
end;

procedure TIB_Text.SetDataColumnName(const Value: string);
begin
  FIB_ColumnLink.ColumnName := Value;
end;

function TIB_Text.GetColumn: TIB_Column;
begin
  Result := FIB_ColumnLink.Column;
end;

function TIB_Text.GetLabelText: string;
begin
  if csPaintCopy in ControlState then begin
    Result := FIB_ColumnLink.ColumnText;
  end else begin
    Result := Caption;
  end;
end;
