// INT_IBC_LISTBOX

constructor TIB_ListBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIB_ColumnLink := TIB_ColumnLink.Create( Self );
  with FIB_ColumnLink do begin
    Control := Self;
    OnStateChanged := StateChanged;
    OnDataChanged  := DataChanged;
    OnUpdateData   := UpdateData;
  end;
end;

destructor TIB_ListBox.Destroy;
begin
  DataSetLink := nil;
  with FIB_ColumnLink do begin
    Control := nil;
    OnStateChanged := nil;
    OnDataChanged  := nil;
    OnUpdateData   := nil;
  end;
  inherited Destroy;
end;

procedure TIB_ListBox.Loaded;
begin
  inherited Loaded;
  SysStateChanged;
  SysDataChanged;
end;

{------------------------------------------------------------------------------}

procedure TIB_ListBox.StateChanged( Sender: TIB_DataLink;
                                    IB_DataSetLink: TIB_DataSetLink );
begin
  SysStateChanged;
end;

procedure TIB_ListBox.DataChanged( Sender: TIB_DataLink;
                                   IB_DataSetLink: TIB_DataSetLink;
                                   IB_Column: TIB_Column );
begin
  SysDataChanged;
end;

procedure TIB_ListBox.UpdateData( Sender: TIB_DataLink;
                                  IB_DataSetLink: TIB_DataSetLink;
                                  IB_Column: TIB_Column );
begin
  SysUpdateData;
end;

{------------------------------------------------------------------------------}

function TIB_ListBox.GetOnPrepareSQL: TIB_DataLinkEvent;
begin
  Result := FIB_ColumnLink.OnPrepareSQL;
end;

procedure TIB_ListBox.SetOnPrepareSQL( AValue: TIB_DataLinkEvent);
begin
  FIB_ColumnLink.OnPrepareSQL := AValue;
end;

function TIB_ListBox.GetDataSetLink: TIB_DataSetLink;
begin
  Result := FIB_ColumnLink.IB_DataSetLink;
end;

function TIB_ListBox.GetColumn: TIB_Column;
begin
  Result := FIB_ColumnLink.Column;
end;

function TIB_ListBox.GetDataColumnName: string;
begin
  Result := FIB_ColumnLink.ColumnName;
end;

function TIB_ListBox.GetReadOnly: Boolean;
begin
  Result := FIB_ColumnLink.ControlIsReadOnly;
end;

function TIB_ListBox.GetPreventUpdating: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsUpdating;
end;

function TIB_ListBox.GetPreventInserting: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsInserting;
end;

function TIB_ListBox.GetPreventSearching: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsSearching;
end;

{------------------------------------------------------------------------------}

procedure TIB_ListBox.SetReadOnly( Value: Boolean );
begin
  if ReadOnly <> Value then begin
    FIB_ColumnLink.ControlIsReadOnly := Value;
    SysStateChanged;
  end;
end;

procedure TIB_ListBox.SetPreventUpdating( Value: Boolean );
begin
  if PreventUpdating <> Value then begin
    FIB_ColumnLink.ControlPreventsUpdating := Value;
    SysStateChanged;
  end;
end;

procedure TIB_ListBox.SetPreventInserting( Value: Boolean );
begin
  if PreventInserting <> Value then begin
    FIB_ColumnLink.ControlPreventsInserting := Value;
    SysStateChanged;
  end;
end;

procedure TIB_ListBox.SetPreventSearching( Value: Boolean );
begin
  if PreventSearching <> Value then begin
    FIB_ColumnLink.ControlPreventsSearching := Value;
    SysStateChanged;
  end;
end;

function TIB_ListBox.GetSearchBuffer: string;
begin
  if FIB_ColumnLink <> nil then begin
    Result := FIB_ColumnLink.SearchBuffer;
  end else begin
    Result := '';
  end;
end;

procedure TIB_ListBox.SetSearchBuffer( AValue: string );
begin
  if FIB_ColumnLink <> nil then begin
    FIB_ColumnLink.SearchBuffer := AValue;
  end;
end;

procedure TIB_ListBox.SetDataSetLink(AValue: TIB_DataSetLink);
begin
  FIB_ColumnLink.IB_DataSetLink := AValue;
end;

procedure TIB_ListBox.SetDataColumnName(const AValue: string);
begin
  FIB_ColumnLink.ColumnName := AValue;
end;

{------------------------------------------------------------------------------}

procedure TIB_ListBox.SysStateChanged;
begin
  inherited Color := FIB_ColumnLink.Color;
end;

procedure TIB_ListBox.SysDataChanged;
begin
  if FIB_ColumnLink.Column <> nil then begin
    ItemIndex := Items.IndexOf(FIB_ColumnLink.ColumnText)
  end else begin
    ItemIndex := -1;
  end;
end;

procedure TIB_ListBox.SysUpdateData;
begin
  if ItemIndex >= 0 then begin
    FIB_ColumnLink.ColumnText := Items[ ItemIndex ]
  end else begin
    FIB_ColumnLink.ColumnText := '';
  end;
end;

{------------------------------------------------------------------------------}

procedure TIB_ListBox.Click;
begin
  if FIB_ColumnLink.Modify then begin
    inherited Click;
    FIB_ColumnLink.ControlIsModified := true;
  end;
end;

procedure TIB_ListBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  if Key in [VK_PRIOR, VK_NEXT, VK_END, VK_HOME, VK_LEFT, VK_UP,
    VK_RIGHT, VK_DOWN] then
    if not FIB_ColumnLink.Modify then Key := 0;
end;

procedure TIB_ListBox.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    #32..#255:
      if not FIB_ColumnLink.Modify then Key := #0;
    #27:
      SysDataChanged;
  end;
end;

procedure TIB_ListBox.WMLButtonDown(var Message: TWMLButtonDown);
begin
  if FIB_ColumnLink.Modify then begin
    inherited
  end else begin
    SetFocus;
    with Message do MouseDown(mbLeft, KeysToShiftState(Keys), XPos, YPos);
  end;
end;

procedure TIB_ListBox.CMEnter(var Message: TCMEnter);
begin
  FIB_ColumnLink.SetFocus;
  inherited;
end;

procedure TIB_ListBox.CMExit(var Message: TCMExit);
begin
  try
    SysUpdateData;  
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

procedure TIB_ListBox.SetItems(Value: TStrings);
begin
  Items.Assign(Value);
  SysDataChanged;
end;

