// INT_IBC_CHECKBOX

{ TIB_CheckBox }

constructor TIB_CheckBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  FIB_ColumnLink := TIB_ColumnLink.Create( Self );
  with FIB_ColumnLink do begin
    Control := Self;
    OnStateChanged := StateChanged;
    OnDataChanged := DataChanged;
    OnUpdateData := UpdateData;
  end;
  FPaintControl := TPaintControl.Create(Self, 'BUTTON');
  FPaintControl.Ctl3DButton := True;
  FValueChecked := 'T';
  FValueUncheck := 'F';
  FBorderStyle := bsSingle;
  State := cbUnchecked;
end;

destructor TIB_CheckBox.Destroy;
begin
  DataSetLink := nil;
  with FIB_ColumnLink do begin
    Control := nil;
    OnStateChanged := nil;
    OnDataChanged  := nil;
    OnUpdateData   := nil;
  end;
  Destroying;
  FPaintControl.Free;
  FPaintControl := nil;
  inherited Destroy;
end;

procedure TIB_CheckBox.Loaded;
begin
  inherited Loaded;
  SysStateChanged;
  SysDataChanged;
end;

{------------------------------------------------------------------------------}

function TIB_CheckBox.GetOnPrepareSQL: TIB_DataLinkEvent;
begin
  Result := FIB_ColumnLink.OnPrepareSQL;
end;

procedure TIB_CheckBox.SetOnPrepareSQL( AValue: TIB_DataLinkEvent );
begin
  FIB_ColumnLink.OnPrepareSQL := AValue;
end;

{------------------------------------------------------------------------------}

procedure TIB_CheckBox.StateChanged( Sender: TIB_DataLink;
                                     IB_DataSetLink: TIB_DataSetLink );
begin
  SysStateChanged;
end;

procedure TIB_CheckBox.DataChanged( Sender: TIB_DataLink;
                                    IB_DataSetLink: TIB_DataSetLink;
                                    IB_Column: TIB_Column );
begin
  SysDataChanged;
end;

procedure TIB_CheckBox.UpdateData( Sender: TIB_DataLink;
                                   IB_DataSetLink: TIB_DataSetLink;
                                   IB_Column: TIB_Column );
begin
  SysUpdateData;
end;

{------------------------------------------------------------------------------}

function TIB_CheckBox.GetDataSetLink: TIB_DataSetLink;
begin
  Result := FIB_ColumnLink.IB_DataSetLink;
end;

function TIB_CheckBox.GetColumn: TIB_Column;
begin
  Result := FIB_ColumnLink.Column;
end;

function TIB_CheckBox.GetDataColumnName: string;
begin
  Result := FIB_ColumnLink.ColumnName;
end;

function TIB_CheckBox.GetReadOnly: Boolean;
begin
  Result := FIB_ColumnLink.ControlIsReadOnly;
end;

function TIB_CheckBox.GetPreventUpdating: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsUpdating;
end;

function TIB_CheckBox.GetPreventInserting: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsInserting;
end;

function TIB_CheckBox.GetPreventSearching: Boolean;
begin
  Result := FIB_ColumnLink.ControlPreventsSearching;
end;

{------------------------------------------------------------------------------}

procedure TIB_CheckBox.SetDataSetLink(AValue: TIB_DataSetLink);
begin
  FIB_ColumnLink.IB_DataSetLink := AValue;
end;

procedure TIB_CheckBox.SetDataColumnName( const AValue: string );
begin
  FIB_ColumnLink.ColumnName := AValue;
end;

procedure TIB_CheckBox.SetReadOnly( Value: Boolean );
begin
  if ReadOnly <> Value then begin
    FIB_ColumnLink.ControlIsReadOnly := Value;
    SysStateChanged;
  end;
end;

procedure TIB_CheckBox.SetPreventUpdating( Value: Boolean );
begin
  if PreventUpdating <> Value then begin
    FIB_ColumnLink.ControlPreventsUpdating := Value;
    SysStateChanged;
  end;
end;

procedure TIB_CheckBox.SetPreventInserting( Value: Boolean );
begin
  if PreventInserting <> Value then begin
    FIB_ColumnLink.ControlPreventsInserting := Value;
    SysStateChanged;
  end;
end;

procedure TIB_CheckBox.SetPreventSearching( Value: Boolean );
begin
  if PreventSearching <> Value then begin
    FIB_ColumnLink.ControlPreventsSearching := Value;
    SysStateChanged;
  end;
end;

function TIB_CheckBox.GetSearchBuffer: string;
begin
  if FIB_ColumnLink <> nil then begin
    Result := FIB_ColumnLink.SearchBuffer;
  end else begin
    Result := '';
  end;
end;

procedure TIB_CheckBox.SetSearchBuffer( AValue: string );
begin
  if FIB_ColumnLink <> nil then begin
    FIB_ColumnLink.SearchBuffer := AValue;
  end;
end;

{------------------------------------------------------------------------------}

procedure TIB_CheckBox.SysStateChanged;
begin
  inherited Color := FIB_ColumnLink.Color;
end;

procedure TIB_CheckBox.SysDataChanged;
begin
  State := GetColumnState;
end;

procedure TIB_CheckBox.SysUpdateData;
begin
  with FIB_ColumnLink do begin
    if State = cbGrayed then begin
      ColumnText := '';
    end else if Checked then begin
      ColumnText := FValueChecked
    end else begin
      ColumnText := FValueUncheck;
    end;
  end;
end;

{------------------------------------------------------------------------------}

function TIB_CheckBox.GetColumnState: TCheckBoxState;
begin
  with FIB_ColumnLink do begin
    if Column = nil then begin
      Result := cbUnchecked;
    end else if FValueChecked = ColumnText then begin
      Result := cbChecked;
    end else if FValueUncheck = ColumnText then begin
      Result := cbUnchecked;
    end else begin
      Result := cbGrayed;
    end;
  end;
end;

procedure TIB_CheckBox.Toggle;
begin
  if FIB_ColumnLink.Modify then begin
    inherited Toggle;
    FIB_ColumnLink.ControlIsModified := true;
  end;
end;

procedure TIB_CheckBox.SetValueCheck( const Value: string );
begin
  if FValueChecked <> Value then begin
    FValueChecked := Value;
    SysDataChanged;
  end;
end;

procedure TIB_CheckBox.SetValueUncheck( const Value: string );
begin
  if FValueUncheck <> Value then begin
    FValueUncheck := Value;
    SysDataChanged;
  end;
end;

procedure TIB_CheckBox.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    #8, ' ':
      if FIB_ColumnLink.Modify then begin
        FIB_ColumnLink.ControlIsModified := true;
      end;
    #27:
      SysDataChanged;
  end;
end;

procedure TIB_CheckBox.WndProc(var Message: TMessage);
begin
  if csDestroying in ComponentState then Exit;
  with Message do
    if ( Msg = WM_CREATE           ) or
       ( Msg = WM_WINDOWPOSCHANGED ) or
       ( Msg = CM_TEXTCHANGED      ) or
       ( Msg = CM_FONTCHANGED      ) then FPaintControl.DestroyHandle;
  inherited;
end;

procedure TIB_CheckBox.WMPaint(var Message: TWMPaint);
begin
  if not (csPaintCopy in ControlState) then inherited else begin
    SendMessage(FPaintControl.Handle, BM_SETCHECK, Ord(GetColumnState), 0);
    SendMessage(FPaintControl.Handle, WM_PAINT, Message.DC, 0);
  end;
end;

procedure TIB_CheckBox.CMEnter(var Message: TCMEnter);
begin
  FIB_ColumnLink.SetFocus;
  inherited;
end;

procedure TIB_CheckBox.CMExit(var Message: TCMExit);
begin
  try
    FIB_ColumnLink.UpdateValue;
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

{------------------------------------------------------------------------------}

procedure TIB_CheckBox.CreateParams(var Params: TCreateParams);
const
  BorderStyles: array[TBorderStyle] of Longint = (0, WS_BORDER);
begin
  inherited CreateParams(Params);
  with Params do begin
    Style := Style or BorderStyles[FBorderStyle];
    if NewStyleControls and Ctl3D and (FBorderStyle = bsSingle) then begin
      Style := Style and not WS_BORDER;
      ExStyle := ExStyle or WS_EX_CLIENTEDGE;
    end;
  end;
end;

procedure TIB_CheckBox.SetBorderStyle(Value: TBorderStyle);
begin
  if FBorderStyle <> Value then begin
    FBorderStyle := Value;
    RecreateWnd;
  end;
end;

