unit
  IB_Registration;

interface

procedure Register;

implementation

{$R IB_Controls.DCR }

uses
  Classes, DsgnIntf,
  
  IB_Monitor,
  IB_Components,
  IB_Events,
  IB_Controls,
  IB_StatementGrid,
  IB_CursorGrid,
  IB_ConnectionBar,
  IB_TransactionBar,
  IB_StatementBar,
  IB_DataSetBar,
  IB_SearchBar,
  IB_NavigationBar,
  IB_UpdateBar;

{                                                                              }
{   Component Registration                                                     }
{                                                                              }

procedure Register;
begin
  RegisterComponents( 'IB Access', [ TIB_Session,
                                     TIB_Connection,
                                     TIB_ConnectionLink,
                                     TIB_TransactionSingle,
                                     TIB_TransactionDouble,
                                     TIB_TransactionMultiple,
                                     TIB_TransactionLink,
                                     TIB_DSQL,
                                     TIB_StatementLink,
                                     TIB_Cursor,
                                     TIB_BDataSet,
                                     TIB_DataSetLink,
                                     TIB_Script,
                                     TIB_Events,
                                     TIB_Monitor ] );

  RegisterComponents( 'IB Controls', [ TIB_StatementGrid,
                                       TIB_CursorGrid,
                                       TIB_Text,
                                       TIB_Edit,
                                       TIB_Memo,
                                       TIB_RichEdit,
                                       TIB_Image,
                                       TIB_ListBox,
                                       TIB_ComboBox,
                                       TIB_CheckBox,
                                       TIB_RadioGroup ] );

  RegisterComponents( 'IB Control Bars', [ TIB_ConnectionBar,
                                           TIB_TransactionBar,
                                           TIB_StatementBar,
                                           TIB_DataSetBar,
                                           TIB_SearchBar,
                                           TIB_NavigationBar,
                                           TIB_UpdateBar ] );
end;

end.
