unit IB_ParametersEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, 
  StdCtrls, ExtCtrls, Grids, Buttons, Dialogs, ComCtrls, DsgnIntf, 

  IB_Header,
  IB_Components,
  IB_StatementGrid;

type
  TfrmIB_Parameters_Editor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    sgParameters: TIB_StatementGrid;
    procedure sgParametersExit(Sender: TObject);
  private
  public
  end;

var
  frmIB_InputRow_Editor: TfrmIB_Parameters_Editor;

type
  TParametersPropertyEditor = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

implementation

{$R *.DFM}

procedure TfrmIB_Parameters_Editor.sgParametersExit(Sender: TObject);
begin
  sgParameters.PostChanges;
end;

{------------------------------------------------------------------------------}

type
  THackStatement = class( TIB_Statement )
  end;

function TParametersPropertyEditor.GetValue: string;
begin
  Result := '(TIB_XSQLDA)';
end;

function TParametersPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TParametersPropertyEditor.Edit;
var
  Statement: TIB_Statement;
  IsChanged: boolean;
begin
  Statement := GetComponent(0) as TIB_Statement;
  IsChanged := false;
  if not Statement.Prepared then begin
    try
      Statement.Prepare;
    except
      { Do not show any exception! }
    end;
  end;
  if Statement.Prepared then begin
    if Statement.InputCount > 0 then begin
      with TfrmIB_Parameters_Editor.Create( Application ) do try
        Caption := Statement.Owner.Name + '.' +
                   Statement.Name       + ' - ' +
                   Caption;
        sgParameters.IB_Statement := Statement;
        ShowModal;
        sgParameters.IB_Statement := nil;
        IsChanged := true;
      finally
        Free;
      end;
    end else begin
      MessageBeep( 1 );
      ShowMessage( 'Statement has no InputRow.' );
    end;
    if IsChanged then begin
      Designer.Modified;
    end;
  end else begin
    MessageBeep( 1 );
    ShowMessage( 'Statement failed to prepare.' );
  end;
end;

end.


