unit
  IB_Editors;

interface

uses
  Classes, SysUtils, DsgnIntf, TypInfo, Forms, Consts, 
  
  IB_Components,
  IB_ConnectionEditor,
  IB_ParametersEditor;

type

{ TIB_DataColumnProperty
  The default property editor for all enumerated properties (e.g. TShape =
  (sCircle, sTriangle, sSquare), etc.). }

  TIB_DataColumnProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

procedure Register;

implementation

{                                                                              }
{   Component Registration                                                     }
{                                                                              }

{ TIB_DataColumnProperty }

function TIB_DataColumnProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paValueList, paSortList, paRevertable];
end;

function TIB_DataColumnProperty.GetValue: string;
var
  L: Longint;
begin
  L := GetOrdValue;
  with GetTypeData(GetPropType)^ do
    if (L < MinValue) or (L > MaxValue) then L := MaxValue;
  Result := GetEnumName(GetPropType, L);
end;

procedure TIB_DataColumnProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  EnumType: PTypeInfo;
begin
  EnumType := GetPropType;
  with GetTypeData(EnumType)^ do
    for I := MinValue to MaxValue do Proc(GetEnumName(EnumType, I));
end;

procedure TIB_DataColumnProperty.SetValue(const Value: string);
var
  I: Integer;
begin
  I := GetEnumValue(GetPropType, Value);
  if I < 0 then begin
    SysUtils.Abort; //raise EPropertyError.CreateRes(SInvalidPropertyValue);
  end;
  SetOrdValue(I);
end;

procedure Register;
begin
  RegisterComponentEditor( TIB_Connection, TIB_Connection_Editor);
  RegisterPropertyEditor( TypeInfo( TIB_Row ),
                          TIB_Statement,
                          'InputRow',
                          TParametersPropertyEditor );
end;

end.
