unit IB_ConnectionEditor;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, DsgnIntf, IB_Components, Dialogs;

type
  TdlgTIB_Connection_Editor = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    lbDatabase: TLabel;
    lbUserName: TLabel;
    lbPassword: TLabel;
    edDatabase: TEdit;
    edUserName: TEdit;
    edPassword: TEdit;
    cbConnected: TCheckBox;
    IB_Connection: TIB_Connection;
    OpenGDB: TOpenDialog;
    SpeedButton1: TSpeedButton;
    procedure edChange(Sender: TObject);
    procedure cbConnectedClick(Sender: TObject);
    procedure IB_ConnectionBeforeConnect(Sender: TIB_Connection);
    procedure IB_ConnectionAfter(Sender: TIB_Connection);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgTIB_Connection_Editor: TdlgTIB_Connection_Editor;

type
  TIB_Connection_Editor = class(TComponentEditor)
  private
  public
    procedure Edit; override;
  end;

implementation

{$R *.DFM}

procedure TdlgTIB_Connection_Editor.edChange(Sender: TObject);
begin
  IB_Connection.Connected := false;
end;

procedure TdlgTIB_Connection_Editor.cbConnectedClick(Sender: TObject);
begin
  with IB_Connection do begin
    try
      Connected := cbConnected.Checked;
    finally
      cbConnected.Checked := Connected;
    end;
  end;
end;

procedure TdlgTIB_Connection_Editor.IB_ConnectionBeforeConnect(Sender: TIB_Connection);
begin
  with IB_Connection do begin
    Database := edDatabase.Text;
    UserName := edUserName.Text;
    Password := edPassword.Text;
  end;
end;

procedure TdlgTIB_Connection_Editor.IB_ConnectionAfter(Sender: TIB_Connection);
begin
  cbConnected.Checked := IB_Connection.Connected;
end;

{------------------------------------------------------------------------------}

procedure TIB_Connection_Editor.Edit;
begin

  if FileExists( 'IB_WISQL.EXE' ) then begin
    with Component as TIB_Connection do begin
      WinExec( PChar( 'IB_WISQL.EXE ' +
                      Database + ' ' +
                      UserName + ' ' +
                      Password ),
               SW_SHOWNORMAL );
    end;
  end else begin

    with TdlgTIB_Connection_Editor.Create( Application ) do try
      Caption := Component.Owner.Name + '.' +
                 Component.Name       + ' - ' +
                 Caption;
      with Component as TIB_Connection do begin
        edDatabase.Text := Database;
        edUserName.Text := UserName;
        edPassword.Text := Password;
        cbConnected.Checked := Connected;
        ShowModal;
        if ModalResult = mrOk then begin
          Database  := edDatabase.Text;
          UserName  := edUserName.Text;
          Password  := edPassword.Text;
          Connected := cbConnected.Checked;
        end;
      end;
    finally
      Free;
    end;
    Designer.Modified;
  end;
end;

procedure TdlgTIB_Connection_Editor.SpeedButton1Click(Sender: TObject);
begin
  if edDatabase.Text <> '' then begin
    IB_Connection.Database := edDatabase.Text;
    OpenGDB.FileName := IB_Connection.Path;
  end else begin
    OpenGDB.FileName := '*.GDB';
  end;
  if OpenGDB.Execute then begin
    IB_Connection.Database := OpenGDB.FileName;
    edDatabase.Text := IB_Connection.Database;
  end;
end;

end.
