unit Module_Contact;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Registry,

  IB_Components;

type
  TdmContact = class(TDataModule)
    trContact: TIB_TransactionSingle;
    crContact: TIB_Cursor;
    crType: TIB_Cursor;
    cnContact: TIB_Connection;
    crHistory: TIB_Cursor;
    crUser: TIB_Cursor;
    dslContact: TIB_DataSetLink;
    procedure cnContactBeforeConnect(Sender: TIB_Connection);
    procedure dmContactCreate(Sender: TObject);
    procedure cnContactLoginFailure(Sender: TIB_Connection);
    procedure crContactBeforePost(IB_DataSet: TIB_DataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dmContact: TdmContact;

implementation

uses Form_Main;

{$R *.DFM}

procedure TdmContact.cnContactBeforeConnect(Sender: TIB_Connection);
begin
  with cnContact, TRegINIFile.Create( 'Contact' ) do try
    if ReadString( 'Contact', 'Connection', '' ) = '' then begin
      WriteString( 'Contact',
                   'Connection',
            '\PROGRAM FILES\INTERBASE OBJECTS\SAMPLES\CONTACT\CONTACT.GDB' );
    end;
    Database := ReadString( 'Contact',
                            'Connection',
            '\PROGRAM FILES\INTERBASE OBJECTS\SAMPLES\CONTACT\CONTACT.GDB' );
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TdmContact.dmContactCreate(Sender: TObject);
begin
  if not cnContact.Connected then begin
    cnContact.Connect;
  end;
  if cnContact.Connected then begin
    crHistory.Prepare;
  end else begin
    ShowMessage( 'Unable to connect to server.'#13#10 +
                 'See your system administrator.');
    Application.Terminate;
  end;
end;

procedure TdmContact.cnContactLoginFailure(Sender: TIB_Connection);
begin
  Application.Terminate;
end;

procedure TdmContact.crContactBeforePost(IB_DataSet: TIB_DataSet);
begin
  with crContact, OutputRow do begin
    if DataSetState = dsInserting then begin
      ByAlias[ 'ADDUSER' ].AsString :=
        crUser.OutputRow.ByAlias[ 'USERID' ].AsString;
    end;
    if DataSetState in [ dsInserting, dsUpdating ] then begin
      ByAlias[ 'CHGUSER' ].AsString :=
        crUser.OutputRow.ByAlias[ 'USERID' ].AsString;
      with ByAlias[ 'ADDUSER' ] do begin
        if AsString = '' then begin
          AsString := crUser.OutputRow.ByAlias[ 'USERID' ].AsString;
        end;
      end;
    end;
  end;
end;

end.
