unit
  Form_Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Registry,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls, Mask, Grids,
  
  IB_Components,
  IB_Controls,
  IB_TransactionBar,
  IB_SearchBar,
  IB_UpdateBar,
  IB_NavigationBar,
  IB_DataSetBar,
  IB_CursorGrid,
  IB_Monitor;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileExitItem: TMenuItem;
    StatusLine: TStatusBar;
    SpeedBar: TPanel;
    SpeedButton2: TSpeedButton;
    IB_NavigationBar1: TIB_NavigationBar;
    IB_UpdateBar1: TIB_UpdateBar;
    IB_SearchBar1: TIB_SearchBar;
    IB_SearchBar2: TIB_SearchBar;
    Panel2: TPanel;
    Panel3: TPanel;
    dsContact: TIB_DataSetLink;
    Panel1: TPanel;
    Label1: TLabel;
    Label32: TLabel;
    EditID: TIB_Edit;
    EditADDDATE: TIB_Edit;
    PageControl: TPageControl;
    tsGeneral: TTabSheet;
    ScrollBox1: TScrollBox;
    Label3: TLabel;
    Label4: TLabel;
    Label19: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    EditFIRSTNAME: TIB_Edit;
    EditLASTNAME: TIB_Edit;
    EditADDR1: TIB_Edit;
    EditCITY: TIB_Edit;
    EditZIP: TIB_Edit;
    EditPHONE: TIB_Edit;
    TabSheet3: TTabSheet;
    tsContactBrowse: TTabSheet;
    cgContact: TIB_CursorGrid;
    tsHistory: TTabSheet;
    cgHistoryBrowse: TIB_CursorGrid;
    dslHistory: TIB_DataSetLink;
    Label43: TLabel;
    Label44: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    EditBUSNAME: TIB_Edit;
    EditBUSADDR1: TIB_Edit;
    EditBUSCITY: TIB_Edit;
    EditBUSZIP: TIB_Edit;
    EditBUSPHONE: TIB_Edit;
    Label13: TLabel;
    EditBUSSTATE: TIB_Edit;
    Label7: TLabel;
    EditCHGDATE: TIB_Edit;
    SpeedButton1: TSpeedButton;
    TabSheet1: TTabSheet;
    Memo1: TMemo;
    Panel4: TPanel;
    Button1: TButton;
    Button2: TButton;
    SaveDialog1: TSaveDialog;
    pnHistorySearch: TPanel;
    Label25: TLabel;
    Label26: TLabel;
    IB_Edit1: TIB_Edit;
    IB_Edit2: TIB_Edit;
    Label35: TLabel;
    miRefresh: TMenuItem;
    miUserSettings: TMenuItem;
    miN1: TMenuItem;
    miN2: TMenuItem;
    Label2: TLabel;
    edPhone: TIB_Edit;
    Label8: TLabel;
    edSTATE: TIB_Edit;
    Label5: TLabel;
    cbTYPE: TIB_ComboBox;
    tsPicture: TTabSheet;
    imPicture: TIB_Image;
    btLoadPicture: TButton;
    OpenDialog: TOpenDialog;
    rgGender: TIB_RadioGroup;
    IB_Monitor: TIB_Monitor;
    Label6: TLabel;
    EditCOMMENT: TIB_RichEdit;
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure dsContactDataSetStateChanged(Sender: TIB_DataSetLink;
      AIB_DataSet: TIB_DataSet);
    procedure dsContactOutputRowDataChanged(Sender: TIB_StatementLinkBase;
      Statement: TIB_Statement; Column: TIB_Column);
    procedure cgContactDblClick(Sender: TObject);
    procedure IB_NavigationBar1BeforeAction(Sender: TObject);
    procedure IB_SearchBar1BeforeAction(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure IB_NavigationBar1AfterAction(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure sqlMonMonitorOutputItem(Sender: TObject; NewString: string);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure miUserSettingsClick(Sender: TObject);
    procedure dslHistoryDataSetStateChanged(Sender: TIB_DataSetLink;
      AIB_DataSet: TIB_DataSet);
    procedure miRefreshClick(Sender: TObject);
    procedure btLoadPictureClick(Sender: TObject);
  private
  { Private Declarations }
    IdleStartTime: TDateTime;
    procedure UpdateCaption;
    procedure AppIsIdle( Sender: TObject; var Done: Boolean );
    procedure LoginTheUser;
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
  Module_Contact,
  Dialog_Login,
  Dialog_Order,
  Dialog_Settings;

{------------------------------------------------------------------------------}
{  MainForm                                                                    } 
{------------------------------------------------------------------------------}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  IdleStartTime := now;
  Application.OnIdle := AppIsIdle;
  SetBounds( 0, 0, 640, 480 );
  PageControl.ActivePage := tsGeneral;
// Have the user sign-on to the system.
  LoginTheUser;
// Populate the TYPE's list box options.  
  with dmContact, crType, cbtYPE.Items do begin
    Active := true;
    Clear;
    First;
    while not EOF do begin
      Add( OutputRow[0].AsString );
      Next;
    end;
    Deallocate;
// Clear the monitor results memo.    
    Memo1.Lines.Clear;
// Staart up in search mode.
    crContact.Search;
  end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// Make sure the user saves their changes before exiting the application.
  if dmContact.trContact.CloseWithConfirm <> mrOk then begin
    Action := caNone;
  end;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.SimpleText := Application.Hint;
end;

procedure TMainForm.AppIsIdle( Sender: TObject; var Done: Boolean );
begin
//  Make this program automatically remove itself from memory in 30 minutes.
//  But, only after about 6:00 PM.
  if ( now - IdleStartTime >= ( 1/48 )) and
     ( Trunc( now ) > 0.75 ) then begin
    Application.Terminate;
  end;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.UpdateCaption;
begin
// Use this as a means to determine the beginning of idle time.
  IdleStartTime := now;
// Refresh the form's caption.
  Caption := 'Contact';
  btLoadPicture.Enabled := false;
  with dmContact, crContact, OutputRow do begin
    case DataSetState of
      dsNone: ;// Do nothing here.
      dsUpdating: begin
        Caption := Caption + ': Updating ' +
                              ByAlias[ 'FIRSTNAME' ].AsString + ' ' +
                              ByAlias[ 'LASTNAME' ].AsString;
        btLoadPicture.Enabled := true;
      end;
      dsInserting: begin
        btLoadPicture.Enabled := true;
        Caption := Caption + ': Inserting ' + ByAlias[ 'ID' ].AsString;
      end;
      dsSearching: begin
        Caption := Caption + ': Searching';
      end else begin
        if ByAlias[ 'ID' ] <> nil then begin
          if ByAlias[ 'ID' ].AsString <> '' then begin
            btLoadPicture.Enabled := dsContact.AutoUpdate;
            Caption := Caption + ': ' + ByAlias[ 'FIRSTNAME' ].AsString +
                                 ' '  + ByAlias[ 'LASTNAME' ].AsString;
          end;
        end;
      end;
    end;
  end;
// Fetch all of the history records for the current contact.  
  if PageControl.ActivePage = tsHistory then begin
    with dmContact, crHistory do begin
      if DataSetState <> dsSearching then begin
        First;  // This actually closes & reopens the cursor too. 
        while not Eof do begin
          Next;
        end;
      end;
    end;
  end;
end;

procedure TMainForm.dsContactDataSetStateChanged(Sender: TIB_DataSetLink;
  AIB_DataSet: TIB_DataSet);
begin
// Refresh the form's caption.
  UpdateCaption;
end;

procedure TMainForm.dsContactOutputRowDataChanged(
  Sender: TIB_StatementLinkBase; Statement: TIB_Statement;
  Column: TIB_Column);
begin
// Refresh the form's caption.
  UpdateCaption;
end;

procedure TMainForm.cgContactDblClick(Sender: TObject);
begin
// When a user double clicks on any record in the browse grid this code will
// pull up that record as the current record. This will then enable updates
// to be performed in the data entry fields.
 with dmContact, cgContact do begin
    if Cells[ 0, Row ] <> '' then begin
      crContact.SaveSearch;
       crContact.ClearSearch;
      EditID.SearchBuffer := Cells[ 0, Row ];
      crContact.Invalidate;
      crContact.First;
      crContact.RecallSearch;
      PageControl.ActivePage := tsGeneral;
    end;
  end;
end;

procedure TMainForm.IB_NavigationBar1BeforeAction(Sender: TObject);
begin
  if IB_NavigationBar1.FocusedButton = nbLast then begin
// Before all records are fetched, unlock the cursor grid so that
// it will receive and buffer the newly fetched records.
    if cgContact.Frozen then begin
      dmContact.crContact.Active := false;
      cgContact.Frozen := false;
      dmContact.crContact.First;
    end;
// Go to the Browse tab page when all records are being fetched.
    PageControl.ActivePage := tsContactBrowse;
  end;
end;

procedure TMainForm.IB_NavigationBar1AfterAction(Sender: TObject);
begin
// After all records have been fetched, lock them into the cursor grid so that
// they can be used as a selection list in order to work with this set to make
// updates, deletes or whatever.
  if IB_NavigationBar1.FocusedButton = nbLast then begin
    if dmContact.crContact.EOF then begin
      cgContact.Frozen := true;
    end;
  end;
end;

procedure TMainForm.IB_SearchBar1BeforeAction(Sender: TObject);
begin
// When the user goes into search mode take them to the General tab page .
  if IB_SearchBar1.FocusedButton = sbSearch then begin
    PageControl.ActivePage := tsGeneral;
  end;
end;

procedure TMainForm.PageControlChange(Sender: TObject);
begin
// This makes sure that there is an accurate display of history records.
  UpdateCaption;
end;

procedure TMainForm.dslHistoryDataSetStateChanged(Sender: TIB_DataSetLink;
  AIB_DataSet: TIB_DataSet);
begin
// This makes the panel containins the search fields appear only when searching.
// Otherwise, the cursor grid showing the actual history records is visible.
  pnHistorySearch.Visible := dmContact.crHistory.DataSetState = dsSearching;
end;

procedure TMainForm.miRefreshClick(Sender: TObject);
begin
// Save all changes and then establish a new connection and transaction. 
  with dmContact do begin
    if trContact.CloseWithConfirm = mrOk then begin
      cnContact.Connected := false;
      crUser.Prepare;
      crUser.First;
      crContact.Search;
    end;
  end;
end;

procedure TMainForm.btLoadPictureClick(Sender: TObject);
begin
  with OpenDialog do begin
    FileName := '*.BMP';
    if Execute then begin
      imPicture.Picture.LoadFromFile( OpenDialog.FileName );
    end;
  end;
end;

{------------------------------------------------------------------------------}
{  Login                                                                       }
{------------------------------------------------------------------------------}

procedure TMainForm.LoginTheUser;
var
  Attempts: integer;
begin
// Launch a fresh instance of the login dialog. Allow three attempts.
  with TdlgUserLogin.Create( Application ) do try
    with TRegINIFile.Create( 'Contact' ) do try
      edUserID.Text := ReadString( 'Contact', 'LastUser', '' );
      Attempts := 0;
      while Attempts < 3 do begin
        if ShowModal = mrOk then begin
          WriteString( 'Contact', 'LastUser', edUserID.Text );
          with dmContact.crUser.OutputRow.ByAlias['USERTYPE'] do begin
            miN1.Visible := AsString <> 'PUB';
            miN2.Visible := AsString <> 'PUB';
            miUserSettings.Visible := AsString <> 'PUB';
          end;
          Break;
        end else begin
          Inc( Attempts );
          if Attempts = 3 then begin
            Application.Terminate;
          end;
        end;
      end;
    finally
      Free;
    end;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}
{  Ordering                                                                    }
{------------------------------------------------------------------------------}

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
// Launch a fresh new instance of the Ordering selection dialog.
  with dmContact, crContact, TdlgOrdering.Create( Self ) do try
    GetOrderingItemsList( lbOrdering.Items );
    lbOrdering.ItemIndex := OrderingItemNo;
    if ShowModal = mrOk then begin
      crContact.OrderingItemNo := lbOrdering.ItemIndex;
    end;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}
{  Settings                                                                    } 
{------------------------------------------------------------------------------}

procedure TMainForm.miUserSettingsClick(Sender: TObject);
begin
// Launch a fresh new instance of the user settings dialog.
  if dmContact.crContact.NeedToPost then begin
    dmContact.crContact.Post;
  end;
  with TdlgUserSettings.Create( Application ) do try
    with dmContact, crUser.OutputRow do begin
      if ByAlias[ 'USERTYPE' ].AsString = 'MGR' then begin
        sbUsers.Enabled := true;
        nbUsers.Enabled := true;
        cbUsersPriv.ReadOnly := false;
        edUsersID.ReadOnly := false;
        cbUsersType.ReadOnly := false;
        crUsers.PreventInserting := false;
        crUsers.PreventDeleting := false;
        cbUsersType.Items.Text := 'MGR'#13#10'USR'#13#10'PUB'#13#10;
      end else if ByAlias[ 'USERTYPE' ].AsString = 'USR' then begin
        sbUsers.Enabled := false;
        nbUsers.Enabled := false;
        cbUsersPriv.ReadOnly := true;
        edUsersID.ReadOnly := true;
        cbUsersType.ReadOnly := true;
        crUsers.PreventInserting := true;
        crUsers.PreventDeleting := true;
        cbUsersType.Items.Text := 'USR'#13#10'PUB'#13#10;
      end else begin
        SysUtils.Abort;
      end;
      trUsers.Started := true;
      crUsers.Search;
      crUsers.ClearSearch;
      edUsersID.SearchBuffer := ByAlias[ 'USERID' ].AsString;
      crUsers.First;
      crUsers.SaveSearch;
      crUsers.ClearSearch;
      crUsers.Invalidate;
      if not crUsers.EOF then begin
        ShowModal;
        crUser.First;
        crContact.Active := false;
        crContact.ReadOnly :=
          crUser.OutputRow.ByAlias[ 'USERPRIV' ].AsString <> 'W';
      end;
    end;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}
{  Monitor                                                                     } 
{------------------------------------------------------------------------------}

procedure TMainForm.sqlMonMonitorOutputItem(Sender: TObject;
  NewString: string);
begin
  Memo1.Lines.Add( NewString );
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  Memo1.Clear;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  with SaveDialog1 do begin
    if Execute then begin
      Memo1.Lines.SaveToFile( Filename );
    end;
  end;
end;

{------------------------------------------------------------------------------}

end.



