unit Dialog_Settings;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, Mask,

  IB_Components,
  IB_SearchBar,
  IB_UpdateBar,
  IB_NavigationBar,
  IB_Controls, ComCtrls, Grids, IB_CursorGrid;

type
  TdlgUsersettings = class(TForm)
    dsUsers: TIB_DataSetLink;
    crUsers: TIB_Cursor;
    trUsers: TIB_TransactionSingle;
    Panel1: TPanel;
    nbUsers: TIB_NavigationBar;
    ubUsers: TIB_UpdateBar;
    sbUsers: TIB_SearchBar;
    Panel2: TPanel;
    OKBtn: TButton;
    CancelBtn: TButton;
    pcUsers: TPageControl;
    tsUsers: TTabSheet;
    ScrollBox1: TScrollBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    edUSERsID: TIB_Edit;
    edPassword: TIB_Edit;
    cbUSERsType: TIB_ComboBox;
    tsBrowse: TTabSheet;
    cgUsers: TIB_CursorGrid;
    cbUSERsPriv: TIB_CheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure cgUsersDblClick(Sender: TObject);
    procedure nbUSERsAfterAction(Sender: TObject);
    procedure nbUSERsBeforeAction(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgUsersettings: TdlgUsersettings;

implementation

{$R *.DFM}

uses
  Form_Main, Module_Contact;

procedure TdlgUsersettings.OKBtnClick(Sender: TObject);
begin
  trUsers.Commit;
end;

procedure TdlgUsersettings.CancelBtnClick(Sender: TObject);
begin
  trUsers.Rollback;
end;

procedure TdlgUserSettings.cgUsersDblClick(Sender: TObject);
begin
// When a user double clicks on any record in the browse grid this code will
// pull up that record as the current record. This will then enable updates
// to be performed in the data entry fields.
 with dmContact, crUsers, cgUsers do begin
    if Cells[ 0, Row ] <> '' then begin
      SaveSearch;
      ClearSearch;
      edUSERsID.SearchBuffer := Cells[ 0, Row ];
      Invalidate;
      First;
      RecallSearch;
      pcUsers.ActivePage := tsUsers;
    end;
  end;
end;

procedure TdlgUserSettings.nbUSERsAfterAction(Sender: TObject);
begin
// After all records have been fetched, lock them into the cursor grid so that
// they can be used as a selection list in order to work with this set to make
// updates, deletes or whatever.
  if nbUsers.FocusedButton = nbLast then begin
    if crUsers.EOF then begin
      cgUsers.Frozen := true;
    end;
  end;
end;

procedure TdlgUserSettings.nbUSERsBeforeAction(Sender: TObject);
begin
  if nbUsers.FocusedButton = nbLast then begin
// Before all records are fetched, unlock the cursor grid so that
// it will receive and buffer the newly fetched records.
    if cgUsers.Frozen then begin
      crUsers.Active := false;
      cgUsers.Frozen := false;
      crUsers.First;
    end;
// Go to the Browse tab page when all records are being fetched.
    pcUsers.ActivePage := tsBrowse;
  end;
end;

end.


