unit Dialog_Login;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, Dialogs, ExtCtrls;

type
  TdlgUserLogin = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    edPassword: TEdit;
    edUserID: TEdit;
    Bevel1: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgUserLogin: TdlgUserLogin;

implementation

uses
  Module_Contact;

{$R *.DFM}

procedure TdlgUserLogin.OKBtnClick(Sender: TObject);
begin
  ModalResult := mrCancel;
  with dmContact.crUser do begin
    Prepared := true;
    if Prepared then begin
      InputRow.ByAlias[ 'USERID'   ].AsString := edUserID.Text;
      InputRow.ByAlias[ 'USERPASS' ].AsString := edPassword.Text;
      First;
      if Eof then begin
        ShowMessage( 'Incorrect login information.'#13#10 +
                     'Please see the system administrator.' );
      end else begin
        dmContact.crContact.Active := false;
        dmContact.crContact.ReadOnly :=
          OutputRow.ByAlias[ 'USERPRIV' ].AsString <> 'W';
        ModalResult := mrOk;
      end;
    end;
  end;
end;

procedure TdlgUserLogin.CancelBtnClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TdlgUserLogin.FormActivate(Sender: TObject);
begin
  if edUserID.Text <> '' then begin
    edPassword.SetFocus;
  end else begin
    edUserID.SetFocus;
  end;
end;

end.
 
