// Please specify your desired path for the application.

CREATE DATABASE "\Program Files\InterBase Objects\Samples\Contact\CONTACT.GDB"
       USER     "SYSDBA"
       PASSWORD "masterkey";

//------------------------------------------------------------------------------

CREATE DOMAIN NAME AS VARCHAR(35);

CREATE DOMAIN USERNAME AS VARCHAR(15);

CREATE DOMAIN ADDR AS VARCHAR(60);

CREATE DOMAIN GENDER AS CHAR(1)
       CHECK ( VALUE IN ('M','F') OR
               VALUE IS NULL );

CREATE DOMAIN USASTATE AS VARCHAR(2)
       CHECK ( VALUE LIKE ('__') OR
               VALUE IS NULL );

CREATE DOMAIN USAZIP AS VARCHAR(10)
       CHECK ( VALUE LIKE ('_____-____') OR
               VALUE LIKE ('_____') OR
               VALUE IS NULL );

CREATE DOMAIN USAPHONE AS VARCHAR(13)
       CHECK ( VALUE LIKE ('(___)___-____') OR
               VALUE LIKE ('___-___-____') OR
               VALUE LIKE ('___-____') OR
               VALUE IS NULL );

CREATE DOMAIN BOOLEAN AS CHARACTER(1)
       CHECK ( VALUE IN (' ', 'Y', 'N') OR
               VALUE IS NULL );

CREATE DOMAIN CNTCT_TYPE AS VARCHAR(10);

COMMIT;

//------------------------------------------------------------------------------

CREATE TABLE CONTACT_TYPE (
       CON_TYP_NAME CNTCT_TYPE  NOT NULL,
       CONSTRAINT CONTACT_TYPE_PK PRIMARY KEY ( CON_TYP_NAME )
);
COMMIT;

INSERT INTO CONTACT_TYPE ( CON_TYP_NAME ) VALUES ( 'BUSINESS' );
INSERT INTO CONTACT_TYPE ( CON_TYP_NAME ) VALUES ( 'CHURCH'   );
INSERT INTO CONTACT_TYPE ( CON_TYP_NAME ) VALUES ( 'DOCTOR'   );
INSERT INTO CONTACT_TYPE ( CON_TYP_NAME ) VALUES ( 'FAMILY'   );
INSERT INTO CONTACT_TYPE ( CON_TYP_NAME ) VALUES ( 'FRIEND'   );
COMMIT;

//------------------------------------------------------------------------------

CREATE TABLE USERS (
     USERID    USERNAME        NOT NULL,
     USERPASS  USERNAME        NOT NULL,
     USERTYPE  CHARACTER( 3 ),
     USERPRIV  VARCHAR( 2 ),
     CONSTRAINT USERS_PK PRIMARY KEY ( USERID )
);
COMMIT;

INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'MGR1',   'MGR1',    'MGR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'MGR2',   'MGR2',    'MGR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'MGR3',   'MGR3',    'MGR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'USR1',   'USR1',    'USR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'USR2',   'USR2',    'USR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'USR3',   'USR3',    'USR',      'W' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'PUB1',   'PUB1',    'PUB',      'R' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'PUB2',   'PUB2',    'PUB',      'R' );
INSERT INTO USERS ( USERID, USERPASS, USERTYPE, USERPRIV )
           VALUES ( 'PUB3',   'PUB3',    'PUB',      'R' );
COMMIT;

//------------------------------------------------------------------------------

CREATE GENERATOR CONTACT_ID;

SET GENERATOR CONTACT_ID TO 999;

CREATE TABLE CONTACT (
     ID            INTEGER              NOT NULL,
     LASTNAME      NAME                 NOT NULL,
     FIRSTNAME     NAME                 NOT NULL,
     TYPE          CNTCT_TYPE           NOT NULL,
     ADDR1         ADDR                 NOT NULL,
     CITY          NAME                 NOT NULL,
     STATE         USASTATE             NOT NULL,
     ZIP           USAZIP               NOT NULL,
     PHONE         USAPHONE,
     GENDER        GENDER,
     BUSNAME       NAME,
     BUSADDR1      ADDR,
     BUSCITY       NAME,
     BUSSTATE      USASTATE,
     BUSZIP        USAZIP,
     BUSPHONE      USAPHONE,
     PICTURE       BLOB( 4096, 0 ),
     COMMENT       BLOB(   80, 1 ),
     ADDDATE       DATE                 NOT NULL,
     ADDUSER       USERNAME             NOT NULL,
     CHGDATE       DATE                 NOT NULL,
     CHGUSER       USERNAME             NOT NULL
);
COMMIT;

ALTER TABLE CONTACT
     ADD CONSTRAINT CONTACT_PK PRIMARY KEY ( ID );
COMMIT;

CREATE INDEX FIRSTNAME_IDX   ON CONTACT( FIRSTNAME );
CREATE INDEX NAME_IDX        ON CONTACT( LASTNAME, FIRSTNAME );
CREATE INDEX TYPE_IDX        ON CONTACT( TYPE,    LASTNAME, FIRSTNAME );
CREATE INDEX BUSNAME_IDX     ON CONTACT( BUSNAME, LASTNAME, FIRSTNAME );
CREATE INDEX ADDDATE_IDX     ON CONTACT( ADDDATE  );
CREATE INDEX CHGDATE_IDX     ON CONTACT( CHGDATE  );
CREATE INDEX PHONE_IDX       ON CONTACT( PHONE    );
CREATE DESCENDING INDEX CHGDATE_DESCIDX  ON CONTACT( CHGDATE  );
CREATE DESCENDING INDEX ADDDATE_DESCIDX  ON CONTACT( ADDDATE  );
COMMIT;

//------------------------------------------------------------------------------

CREATE TABLE HISTORY (
     ID            INTEGER  NOT NULL,
     LASTNAME      NAME,
     FIRSTNAME     NAME,
     PHONE         USAPHONE,
     CHGUSER       USERNAME,
     CHGDATE       DATE     NOT NULL
);
COMMIT;

CREATE            INDEX HISID_IDX          ON HISTORY( ID       );
CREATE DESCENDING INDEX HISCHGDATE_DESCIDX ON HISTORY( CHGDATE  );
COMMIT;

ALTER TABLE HISTORY
     ADD CONSTRAINT HISTORY_PK PRIMARY KEY ( ID, CHGDATE );
ALTER TABLE HISTORY
      ADD CONSTRAINT CONTACT_FK FOREIGN KEY ( ID ) REFERENCES CONTACT;
COMMIT;


//------------------------------------------------------------------------------

begin
CREATE TRIGGER CASCADE_TYPE_UPDATE FOR CONTACT_TYPE
AFTER UPDATE AS
BEGIN
  IF (OLD.CON_TYP_NAME <> NEW.CON_TYP_NAME) THEN BEGIN
    UPDATE CONTACT
      SET TYPE = NEW.CON_TYP_NAME
      WHERE TYPE = OLD.CON_TYP_NAME;
  END
END
end;

//------------------------------------------------------------------------------

begin
CREATE TRIGGER INSERT_HISADDDATE FOR HISTORY
BEFORE INSERT AS
BEGIN
  IF ( NEW.CHGDATE IS NULL ) THEN NEW.CHGDATE = "NOW";
  IF ( NEW.CHGUSER IS NULL ) THEN NEW.CHGUSER = "UNKNOWN";
END
end;

begin
CREATE TRIGGER INSERT_ADDDATE FOR CONTACT
BEFORE INSERT AS
BEGIN
  NEW.ADDDATE = "NOW";
  NEW.CHGDATE = NEW.ADDDATE;
END
end;

begin
CREATE TRIGGER UPDATE_CHDDATE FOR CONTACT
BEFORE UPDATE AS
DECLARE VARIABLE NEED_LOG SMALLINT;
BEGIN
  NEED_LOG = 0;
  IF ( OLD.LASTNAME  <> NEW.LASTNAME  ) THEN NEED_LOG = 1;
  IF ( OLD.FIRSTNAME <> NEW.FIRSTNAME ) THEN NEED_LOG = 1;
  IF ( OLD.PHONE     <> NEW.PHONE     ) THEN NEED_LOG = 1;
  IF ( OLD.PHONE IS     NULL ) THEN
  IF ( NEW.PHONE IS NOT NULL ) THEN NEED_LOG = 1;

  IF ( NEED_LOG > 0 ) THEN NEW.CHGDATE = "NOW";
END
end;

begin
CREATE TRIGGER UPDATE_HISTORY FOR CONTACT
AFTER UPDATE AS
BEGIN
  IF ( OLD.CHGDATE <> NEW.CHGDATE ) THEN
    INSERT INTO HISTORY
    ( ID,
      LASTNAME,
      FIRSTNAME,
      PHONE,
      CHGDATE,
      CHGUSER )
    VALUES
    ( OLD.ID,
      OLD.LASTNAME,
      OLD.FIRSTNAME,
      OLD.PHONE,
      OLD.CHGDATE,
      OLD.CHGUSER );
END
end;
COMMIT;

