unit Form_IB_WISQL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Spin, 
  StdCtrls, ExtCtrls, Grids, Buttons, Dialogs, ComCtrls, Mask, Registry,

  IB_Components,
  IB_Events,
  IB_Monitor,
  IB_Controls,
  IB_StatementBar,
  IB_CursorGrid,
  IB_StatementGrid,
  IB_SearchBar,
  IB_UpdateBar,
  IB_NavigationBar,
  IB_DataSetBar,
  IB_TransactionBar,
  IB_ConnectionBar;

type
  TfrmIB_Obj_Demo = class(TForm)
    PageControl: TPageControl;
    SQLTab: TTabSheet;
    ConnectionTab: TTabSheet;
    Panel1: TPanel;
    edUserName: TEdit;
    edPassword: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Panel2: TPanel;
    CursorStatementPanel: TPanel;
    IB_ConnectionBar: TIB_ConnectionBar;
    tsDSQL: TTabSheet;
    DSQLStatementPanel: TPanel;
    btSQLPrevious: TButton;
    btSQLNext: TButton;
    Panel4: TPanel;
    pcCursor: TPageControl;
    tsCursorSQL: TTabSheet;
    meCursor: TMemo;
    tsParameters: TTabSheet;
    tsCursorColumns: TTabSheet;
    sbStatementBar: TIB_StatementBar;
    dsbCursorBar: TIB_DataSetBar;
    Panel6: TPanel;
    btNewSQL: TButton;
    IB_ConnectionLink: TIB_ConnectionLink;
    IB_CursorStatementLink: TIB_StatementLink;
    IB_DSQLStatementLink: TIB_StatementLink;
    IB_CursorLink: TIB_DataSetLink;
    pcDSQL: TPageControl;
    tsDSQLStatement: TTabSheet;
    tsDSQLParameters: TTabSheet;
    tsDSQLOutput: TTabSheet;
    meDSQL: TMemo;
    IB_StatementGrid1: TIB_StatementGrid;
    IB_StatementGrid2: TIB_StatementGrid;
    IB_StatementGrid3: TIB_StatementGrid;
    cbDatabase: TComboBox;
    SpeedButton1: TSpeedButton;
    tsFields: TTabSheet;
    Panel13: TPanel;
    TabSheet8: TTabSheet;
    meSQLMonitorOutput: TMemo;
    Panel15: TPanel;
    btSQLMonClear: TButton;
    cbMonConnection: TCheckBox;
    cbMonTransaction: TCheckBox;
    cbMonStatement: TCheckBox;
    cbMonRow: TCheckBox;
    btSQLMonSave: TButton;
    sdSaveMonitorOutput: TSaveDialog;
    Button1: TButton;
    TabSheet9: TTabSheet;
    Panel16: TPanel;
    Panel17: TPanel;
    Panel23: TPanel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    cbRemember: TCheckBox;
    btScriptExecute: TButton;
    odOpenScript: TOpenDialog;
    sdSaveScript: TSaveDialog;
    IB_Script: TIB_Script;
    tsExtract: TTabSheet;
    Label4: TLabel;
    cbForcedWrites: TCheckBox;
    seBuffers: TSpinEdit;
    sbCursorSearch: TScrollBox;
    Panel10: TPanel;
    PageControl1: TPageControl;
    tsRelations: TTabSheet;
    meScript: TMemo;
    nbNavigationBar: TIB_NavigationBar;
    ubUpdateBar: TIB_UpdateBar;
    sbSearchBar: TIB_SearchBar;
    cbMonSQL: TCheckBox;
    Panel5: TPanel;
    sbCountBar: TIB_SearchBar;
    IB_TransactionBar2: TIB_TransactionBar;
    IB_TransactionLink: TIB_TransactionLink;
    TabSheet7: TTabSheet;
    Panel3: TPanel;
    IB_TransactionBar1: TIB_TransactionBar;
    Panel7: TPanel;
    Panel8: TPanel;
    ScrollBox3: TScrollBox;
    cbAutoStart: TCheckBox;
    cbReadOnly: TCheckBox;
    rgIsolation: TRadioGroup;
    cbLockWait: TCheckBox;
    cbRecVersion: TCheckBox;
    cbAutoCommit: TCheckBox;
    Panel9: TPanel;
    Panel11: TPanel;
    Panel12: TPanel;
    Panel14: TPanel;
    edAllocatedpages: TEdit;
    edImplementation: TEdit;
    edLevel: TEdit;
    edODS: TEdit;
    edVersion: TEdit;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label12: TLabel;
    Label6: TLabel;
    edPageSize: TEdit;
    cbMonitorEnabled: TCheckBox;
    OpenGDB: TOpenDialog;
    TabSheet10: TTabSheet;
    Panel20: TPanel;
    pcRelExtract: TPageControl;
    tsRelColumns: TTabSheet;
    sgExtractColumns: TIB_StatementGrid;
    tsRelData: TTabSheet;
    IB_CursorGrid2: TIB_CursorGrid;
    Panel22: TPanel;
    IB_NavigationBar2: TIB_NavigationBar;
    dslRelations: TIB_DataSetLink;
    lbRelations: TListBox;
    rbTables: TRadioButton;
    rbViews: TRadioButton;
    tsDomains: TTabSheet;
    pnSizerRelations: TPanel;
    tsRelIndicies: TTabSheet;
    tsRelConstraints: TTabSheet;
    meRelIndicies: TMemo;
    meRelConstraints: TMemo;
    tsRelTriggers: TTabSheet;
    cbSystem: TCheckBox;
    cbDomainInfo: TCheckBox;
    IB_SearchBar1: TIB_SearchBar;
    dsTriggerExtract: TIB_DataSetLink;
    lbRelTriggers: TListBox;
    pnSizerRelTriggers: TPanel;
    lbProcedures: TListBox;
    pnSizerProcedures: TPanel;
    dsProcExtract: TIB_DataSetLink;
    lbDomains: TListBox;
    pnSizerDomains: TPanel;
    IB_TransactionBar3: TIB_TransactionBar;
    tsCursorPlan: TTabSheet;
    meCursorPlan: TMemo;
    tsCursorData: TTabSheet;
    cgCursor: TIB_CursorGrid;
    IB_StatementGrid4: TIB_StatementGrid;
    Panel18: TPanel;
    meTriggers: TIB_Memo;
    Panel19: TPanel;
    IB_Edit1: TIB_Edit;
    IB_Edit2: TIB_Edit;
    IB_Edit3: TIB_Edit;
    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    btEditTrigger: TButton;
    Panel24: TPanel;
    Panel21: TPanel;
    btEditProcedure: TButton;
    PageControl2: TPageControl;
    tsProcedureSource: TTabSheet;
    meProcudureSource: TIB_Memo;
    tsProcedureInputs: TTabSheet;
    tsProcedureOutputs: TTabSheet;
    IB_StatementGrid5: TIB_StatementGrid;
    IB_StatementGrid6: TIB_StatementGrid;
    IB_StatementBar1: TIB_StatementBar;
    IB_TransactionBar4: TIB_TransactionBar;
    tsProcDesc: TTabSheet;
    meProcDesc: TIB_Memo;
    tsRelDesc: TTabSheet;
    mrRelDesc: TIB_Memo;
    IB_Monitor: TIB_Monitor;
    tsEvents: TTabSheet;
    meEvents: TMemo;
    Panel25: TPanel;
    btRegEvents: TButton;
    tsViewSource: TTabSheet;
    meViewSource: TIB_Memo;
    meEventResults: TMemo;
    btClearResults: TButton;
    TabSheet1: TTabSheet;
    Panel26: TPanel;
    Memo1: TMemo;
    IB_Events: TIB_Events;
    IB_BDataSet1: TIB_BDataSet;
    IB_NavigationBar1: TIB_NavigationBar;
    IB_DataSetLink1: TIB_DataSetLink;
    IB_CursorGrid1: TIB_CursorGrid;
    IB_DataSetBar1: TIB_DataSetBar;
    IB_SearchBar2: TIB_SearchBar;
    Label14: TLabel;
    IB_Edit4: TIB_Edit;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure btSQLPreviousClick(Sender: TObject);
    procedure btSQLNextClick(Sender: TObject);
    procedure cbAutoStartClick(Sender: TObject);
    procedure IB_ConnectionLinkBeforeConnect(Sender: TIB_ConnectionLink;
      IB_Connection: TIB_Connection);
    procedure IB_ConnectionLinkConnectedChanged(
      Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
    procedure IB_ConnectionLinkBeforeDropDatabase(
      Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
    procedure IB_CursorStatementLinkBeforePrepare(
      Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
    procedure IB_DSQLStatementLinkBeforePrepare(Sender: TIB_StatementLinkBase;
      IB_Statement: TIB_Statement);
    procedure meDSQLChange(Sender: TObject);
    procedure meCursorChange(Sender: TObject);
    procedure IB_DSQLStatementLinkPreparedChanged(
      Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
    procedure btNewSQLClick(Sender: TObject);
    procedure IB_DSQLStatementLinkAfterUnprepare(Sender: TIB_StatementLinkBase;
      IB_Statement: TIB_Statement);
    procedure cbDatabaseChange(Sender: TObject);
    procedure IB_ConnectionLinkAfterConnect(Sender: TIB_ConnectionLink;
      IB_Connection: TIB_Connection);
    procedure IB_ConnectionLinkBeforeCreateDatabase(
      Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
    procedure IB_CursorStatementLinkPreparedChanged(
      Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
    procedure SQLMonitorMonitorOutputItem(Sender: TObject;
      NewString: string);
    procedure btSQLMonClearClick(Sender: TObject);
    procedure cbMonConnectionClick(Sender: TObject);
    procedure btSQLMonSaveClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure IB_CursorStatementLinkAfterPrepare(
      Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
    procedure IB_DSQLStatementLinkAfterPrepare(
      Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
    procedure meScriptChange(Sender: TObject);
    procedure btScriptExecuteClick(Sender: TObject);
    procedure IB_ScriptAfterExecute(Sender: TIB_Script);
    procedure IB_ScriptBeforeExecute(Sender: TIB_Script);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure tsExtractEnter(Sender: TObject);
    procedure IB_CursorLinkStateChanged(Sender: TIB_DataSetLink;
      AIB_DataSet: TIB_DataSet);
    procedure IB_TransactionLinkBeforeStart(Sender: TIB_TransactionLink;
      T: TIB_Transaction);
    procedure TransactionPropChanged(Sender: TObject);
    procedure cbAutoCommitClick(Sender: TObject);
    procedure IB_TransactionLinkStatusChanged(Sender: TIB_TransactionLink;
      T: TIB_Transaction);
    procedure cbMonitorEnabledClick(Sender: TObject);
    procedure lbRelationsClick(Sender: TObject);
    procedure lbRelationsKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pnSizerRelationsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnSizerRelationsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnSizerRelationsMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RelationsClick(Sender: TObject);
    procedure cbDomainInfoClick(Sender: TObject);
    procedure pcRelExtractChange(Sender: TObject);
    procedure lbTriggersClick(Sender: TObject);
    procedure lbProceduresClick(Sender: TObject);
    procedure lbProceduresKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure meTriggersKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pcCursorChange(Sender: TObject);
    procedure btEditTriggerClick(Sender: TObject);
    procedure btEditProcedureClick(Sender: TObject);
    procedure IB_ConnectionLinkAfterExecDDL(Sender: TIB_ConnectionLink;
      IB_Connection: TIB_Connection);
    procedure btRegEventsClick(Sender: TObject);
    procedure meEventsChange(Sender: TObject);
    procedure IB_EventsAfterRegister(Sender: TObject);
    procedure IB_EventsAfterUnregister(Sender: TObject);
    procedure IB_EventsBeforeRegister(Sender: TObject);
    procedure IB_EventsEventAlert(Sender: TObject; EventName: string;
      EventCount: Longint);
    procedure btClearResultsClick(Sender: TObject);
    procedure nbNavigationBarBeforeAction(Sender: TObject);
    procedure IB_DataSetBar1BeforeAction(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
  private
    IB_WISQL_INI: TRegINIFile;
    PanelSizing: boolean;
    LabelList: TList;
    IB_EditList: TList;
    procedure UpdateDSQLButtons;
  public
  end;

var
  frmIB_Obj_Demo: TfrmIB_Obj_Demo;

implementation

{$R *.DFM}

uses
  Module_IB_Data,
  Form_About,
  IB_Parse;

{------------------------------------------------------------------------------}
{   Form related stuff                                                         }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.FormCreate(Sender: TObject);
var
  ii: integer;
  ATop, ALeft, AHeight, AWidth: integer;
  AMaximized: boolean;
begin
  Caption := Application.Title;
  IB_WISQL_INI := TRegINIFile.Create( 'IB_WISQL' );
  cbDatabase.Text := ParamStr(1);
  if ParamStr(2) <> '' then begin
    edUserName.Text := ParamStr(2);
  end;
  if ParamStr(3) <> '' then begin
    edPassword.Text := ParamStr(3);
  end;
  with IB_WISQL_INI, cbDatabase.Items do begin
    ii := 0;
    while ReadString( 'Connections', IntToStr( ii ),'' ) <> '' do begin
      Add( ReadString( 'Connections', IntToStr( ii ), '' ));
      Inc( ii );
    end;
  end;
  with IB_WISQL_INI, meDSQL.Lines do begin
    ii := 0;
    while ReadString( 'DSQL', IntToStr( ii ), '' ) <> '' do begin
      Add( ReadString( 'DSQL', IntToStr( ii ), '' ));
      Inc( ii );
    end;
  end;
  with IB_WISQL_INI, meCursor.Lines do begin
    ii := 0;
    while ReadString( 'Cursor', IntToStr( ii ), '' ) <> '' do begin
      Add( ReadString( 'Cursor', IntToStr( ii ), '' ));
      Inc( ii );
    end;
  end;
  with IB_WISQL_INI, meEvents.Lines do begin
    ii := 0;
    while ReadString( 'Events', IntToStr( ii ), '' ) <> '' do begin
      Add( ReadString( 'Events', IntToStr( ii ), '' ));
      Inc( ii );
    end;
  end;
//  with IB_WISQL_INI, meScript.Lines do begin
//    ii := 0;
//    while ReadString( 'Script', IntToStr( ii ), '' ) <> '' do begin
//      Add( ReadString( 'Script', IntToStr( ii ), '' ));
//      Inc( ii );
//    end;
//  end;
  with cbDatabase do begin
    if ( Text = '' ) and ( Items.Count > 0 ) then begin
      Text := Items[ 0 ];
    end;
  end;
  with IB_WISQL_INI, edUserName do begin
    if ( Text = '' )  then begin
      Text := ReadString( 'Settings', 'USER NAME', 'SYSDBA' );
    end;
  end;
  with IB_WISQL_INI, edPassword do begin
    if ( Trim( Text ) = '' )  then begin
      cbRemember.Checked := ReadString( 'Settings', 'PASSWORD', '' ) <> '';
      Text := ReadString( 'Settings', 'PASSWORD', 'masterkey' );
    end;
  end;
  with IB_WISQL_INI do begin
    AMaximized := ReadBool( 'Settings', 'Maximized', true );
    ATop    := ReadInteger( 'Settings', 'TOP',      0 );
    ALeft   := ReadInteger( 'Settings', 'LEFT',     0 );
    AHeight := ReadInteger( 'Settings', 'HEIGHT', 400 );
    AWidth  := ReadInteger( 'Settings', 'WIDTH',  600 );
    lbRelations.Width   := ReadInteger( 'Settings', 'lbRelations.Width',   120);
    lbRelTriggers.Width := ReadInteger( 'Settings', 'lbRelTriggers.Width', 120);
    lbProcedures.Width  := ReadInteger( 'Settings', 'lbProcedures.Width',  120);
    lbDomains.Width     := ReadInteger( 'Settings', 'lbDomains.Width',     120);
  end;
  SetBounds( ALeft, ATop, AWidth, AHeight );
  if AMaximized then begin
    WindowState := wsMaximized;
  end;
  PageControl.ActivePage  := ConnectionTab;
  PageControl1.ActivePage := tsRelations;
  pcRelExtract.ActivePage := tsRelColumns;
  pcCursor.ActivePage := tsCursorSQL;
  pcDSQL.ActivePage := tsDSQLStatement;
  LabelList := TList.Create;
  IB_EditList := TList.Create;
end;

procedure TfrmIB_Obj_Demo.FormClose( Sender: TObject; var Action: TCloseAction);
begin
  with IB_DataModule do begin
    if IB_Transaction.CloseWithConfirm <> mrCancel then begin
      IB_Connection.Connected := false;
      if IB_WISQL_INI <> nil then begin
        try
          with IB_WISQL_INI do begin
            if WindowState = wsMaximized then begin
              WriteBool( 'Settings', 'Maximized', true );
            WindowState := wsNormal;
            end else begin
              WriteBool( 'Settings', 'Maximized', false );
            end;
            WriteInteger( 'Settings','TOP',    Top    );
            WriteInteger( 'Settings','LEFT',   Left   );
            WriteInteger( 'Settings','HEIGHT', Height );
            WriteInteger( 'Settings','WIDTH',  Width  );
            WriteInteger( 'Settings','lbRelations.Width',  lbRelations.Width);
            WriteInteger( 'Settings','lbRelTriggers.Width',lbRelTriggers.Width);
            WriteInteger( 'Settings','lbProcedures.Width', lbProcedures.Width);
            WriteInteger( 'Settings','lbDomains.Width',    lbDomains.Width);
          end;
        except
        // Throw away any exception here.
        end;
        IB_WISQL_INI.Free;
        IB_WISQL_INI := nil;
      end;
      LabelList.Free;
      IB_EditList.Free;
    end else begin
      Action := caNone;
    end;
  end;
end;

{------------------------------------------------------------------------------}
{   Connection tab related stuff                                               }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkBeforeConnect(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
begin
  with IB_Connection do begin
    if ConnectionStatus = csConnectPending then begin
    // This is invoked when a database is created in the connection tab.
      Database := cbDatabase.Text;
      UserName := edUserName.Text;
      Password := edPassword.Text;
      Buffers  := seBuffers.Value;
      ForcedWrites := cbForcedWrites.Checked;
    end else begin
    // This is invoked when a script creates a new database.
      cbDatabase.Text := Database;
      edUserName.Text := UserName;
      edPassword.Text := Password;
      seBuffers.Value := Buffers;
      cbForcedWrites.Checked := ForcedWrites;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.cbDatabaseChange(Sender: TObject);
begin
  IB_DataModule.IB_Connection.Connected := false;
end;

procedure TfrmIB_Obj_Demo.SpeedButton1Click(Sender: TObject);
begin
  if cbDatabase.Text <> '' then begin
    IB_DataModule.IB_Connection.Database := cbDatabase.Text;
    OpenGDB.FileName := IB_DataModule.IB_Connection.Path;
  end else begin
    OpenGDB.FileName := '*.GDB';
  end;
  if OpenGDB.Execute then begin
    IB_DataModule.IB_Connection.Connected := false;
    IB_DataModule.IB_Connection.Database := OpenGDB.FileName;
    cbDatabase.Text := IB_DataModule.IB_Connection.Database;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkAfterConnect(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
var
  ii: integer;
begin
  with cbDatabase, Items, IB_Connection do begin
    ii := IndexOf( Database );
    if ii <> -1 then begin
      Delete( ii );
    end;
    Insert( 0, Database );
    IB_WISQL_INI.EraseSection( 'Connections' );
    for ii := 0 to Count - 1 do begin
      IB_WISQL_INI.WriteString( 'Connections',
                                IntToStr( ii ),
                                cbDatabase.Items[ ii ]);
    end;
    with IB_WISQL_INI do begin
      WriteString( 'Settings', 'USER NAME', edUserName.Text );
      if cbRemember.Checked then begin
        WriteString( 'Settings', 'PASSWORD', edPassword.Text );
      end else begin
        edPassword.Text := '';
        WriteString( 'Settings', 'PASSWORD', '' );
      end;
    end;
    cbDatabase.Text := Database;
    edUsername.Text := UserName;
    edPassword.Text := Password;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkConnectedChanged(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
begin
  Caption := Application.Title;
  if IB_Connection.Connected then begin
    Caption := Caption + ' - ' + IB_Connection.Database;
  end;

  if IB_Connection.Connected then begin
    with IB_Connection.Characteristics do begin
      edAllocatedPages.Text := IntToStr( dbAllocation );
//    ShowMessage( 'Site: ' + dbSite );
//    ShowMessage( 'File: ' + dbFile );
      edLevel.Text := IntToStr( dbLevelPrefix )  + '.' +
                      IntToStr( dbBase_Level  )  + '.';
      edImplementation.Text := IntToStr( dbImplementationPrefix ) + '.' +
                               IntToStr( dbImplementation ) + '.' +
                               IntToStr( dbClass );
//    cbReservePageSpace.Checked := dbNo_Reserve = 0;
      edODS.Text := IntToStr( dbODS_Minor_Version ) + '.' +
                    IntToStr( dbODS_Version );
      edPageSize.Text := IntToStr( dbPage_Size );
      edVersion.Text := IntToStr( dbVersionPrefix ) + '.' + dbVersion;
    end;
  end else begin
    edAllocatedPages.Text      := '';
    edLevel.Text               := '';
    edImplementation.Text      := '';
//  cbReservePageSpace.Checked := true;
    edODS.Text                 := '';
    edPageSize.Text            := '';
    edVersion.Text             := '';
  end;
  lbRelations.Items.Clear;
end;

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkBeforeCreateDatabase(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
begin
  if MessageDlg( 'Are you sure you want to create this database?',
                 mtConfirmation,
                 mbOkCancel,
                 0 ) <> mrOk then begin
    SysUtils.Abort;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkBeforeDropDatabase(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
begin
  if MessageDlg( 'Are you sure you want to drop this database?',
                 mtConfirmation,
                 mbOkCancel,
                 0 ) <> mrOk then begin
    SysUtils.Abort;
  end;
end;

procedure TfrmIB_Obj_Demo.Button1Click(Sender: TObject);
begin
  with TAboutBox.Create( Application ) do try
    ShowModal;
  finally
    Free;
  end;
end;

{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.cbAutoStartClick(Sender: TObject);
begin
  IB_DataModule.IB_Transaction.AutoStart := cbAutoStart.Checked;
end;

procedure TfrmIB_Obj_Demo.cbAutoCommitClick(Sender: TObject);
begin
  IB_TransactionLink.IB_Transaction.AutoCommit := cbAutoCommit.Checked;
end;

procedure TfrmIB_Obj_Demo.IB_TransactionLinkBeforeStart(
  Sender: TIB_TransactionLink; T: TIB_Transaction);
begin
  with T do begin
    ReadOnly   := cbReadOnly.Checked;
    LockWait   := cbLockWait.Checked;
    case rgIsolation.ItemIndex of
      0: Isolation := tiConcurrency;
      1: Isolation := tiConsistency;
      2: Isolation := tiCommitted;
    end;
    RecVersion := cbRecVersion.Checked;
  end;
end;

procedure TfrmIB_Obj_Demo.TransactionPropChanged(Sender: TObject);
begin
  with IB_TransactionLink do begin
    if Started then begin
      IB_Transaction.Close;
    end;
  end;
  cbRecVersion.Enabled := rgIsolation.ItemIndex = 2;
end;

procedure TfrmIB_Obj_Demo.IB_TransactionLinkStatusChanged(
  Sender: TIB_TransactionLink; T: TIB_Transaction);
begin
//  cbReadOnly.Enabled   := not T.Started;
//  cbLockWait.Enabled   := not T.Started;
//  cbRecVersion.Enabled := not T.Started and ( rgIsolation.ItemIndex = 2 );
//  rgIsolation.Enabled  := not T.Started;
end;

{------------------------------------------------------------------------------}
{   Cursor tab related stuff                                                   }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.IB_CursorStatementLinkBeforePrepare(
  Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
begin
  with IB_DataModule.IB_Cursor.SQL do begin
    if Count = 0 then begin
      AddStrings( meCursor.Lines );
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.meCursorChange(Sender: TObject);
begin
  IB_DataModule.IB_Cursor.SQL.Clear;
end;

procedure TfrmIB_Obj_Demo.IB_CursorStatementLinkPreparedChanged(
  Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
var
  ii: integer;
  tmpLabel: TLabel;
  tmpIB_Edit: TIB_Edit;
begin
  tmpLabel   := nil;
  tmpIB_Edit := nil;
  with Statement do begin
    if Prepared then begin
      for ii := 0 to OutputCount - 1 do with OutputRow[ ii ] do begin
        if ii >= LabelList.Count then begin
          tmpLabel := TLabel.Create( Self );
          tmpIB_Edit := TIB_Edit.Create( Self );
          LabelList.Add( tmpLabel );
          IB_EditList.Add( tmpIB_Edit );
          tmpLabel.Visible := false;
          tmpIB_Edit.Visible := false;
          tmpLabel.Parent := sbCursorSearch;
          tmpIB_Edit.Parent := sbCursorSearch;
          tmpLabel.Width := 140;
          tmpIB_Edit.Width := 360;
          tmpLabel.Top := ii * 24 + 8;
          tmpIB_Edit.Top := ii * 24 + 6;
          tmpLabel.Left := 20;
          tmpIB_Edit.Left := 180;
        end else begin
          tmpLabel := TLabel( LabelList.Items[ ii ] );
          tmpIB_Edit := TIB_Edit( IB_EditList.Items[ ii ] );
        end;
        tmpLabel.Caption := DisplayName;
        tmpIB_Edit.DataSetLink := IB_CursorLink;
        tmpIB_Edit.DataColumnname := AliasName;
        tmpLabel.Visible := true;
        tmpIB_Edit.Visible := true;
      end;
    end else begin
      for ii := 0 to LabelList.Count - 1 do begin
        TWinControl( LabelList.Items  [ ii ] ).Visible := false;
        TWinControl( IB_EditList.Items[ ii ] ).Visible := false;
      end;
      LabelList.Clear;
      IB_EditList.Clear;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_CursorStatementLinkAfterPrepare(
  Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
var
  ii: integer;
  NewWidth: integer;
begin
  IB_WISQL_INI.EraseSection( 'Cursor' );
  for ii := 0 to meCursor.Lines.Count - 1 do begin
    IB_WISQL_INI.WriteString( 'Cursor',
                              IntToStr( ii ),
                              meCursor.Lines[ ii ] );
  end;
  pcCursorChange( Sender );
end;

procedure TfrmIB_Obj_Demo.pcCursorChange(Sender: TObject);
begin
  if pcCursor.ActivePage = tsCursorPlan then begin
    meCursorPlan.Text := IB_DataModule.IB_Cursor.StatementPlan;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_CursorLinkStateChanged(
  Sender: TIB_DataSetLink; AIB_DataSet: TIB_DataSet);
begin
  if AIB_DataSet.DataSetState = dsSearching then begin
    pcCursor.ActivePage := tsFields;
  end;
end;

procedure TfrmIB_Obj_Demo.nbNavigationBarBeforeAction(Sender: TObject);
begin
  if nbNavigationBar.FocusedButton = nbLast then begin
    pcCursor.ActivePage := tsCursorData;
  end;
end;

{------------------------------------------------------------------------------}
{   DSQL tab related stuff                                                     }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.IB_DSQLStatementLinkBeforePrepare(
  Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
begin
  with IB_DataModule.IB_DSQL.SQL do begin
    if Count = 0 then begin
      AddStrings( meDSQL.Lines );
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.meDSQLChange(Sender: TObject);
begin
  IB_DataModule.IB_DSQL.SQL.Clear;
end;

procedure TfrmIB_Obj_Demo.IB_DSQLStatementLinkPreparedChanged(
  Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
begin
  with DSQLStatementPanel do begin
    case IB_DataModule.IB_DSQL.StatementType of
    stUnknown:         Caption := 'Type: stUnknown    ';
    stSelect:          Caption := 'Type: stSelect    ';
    stInsert:          Caption := 'Type: stInsert    ';
    stUpdate:          Caption := 'Type: stUpdate    ';
    stDelete:          Caption := 'Type: stDelete    ';
    stDDL:             Caption := 'Type: stDDL    ';
    stGetSegment:      Caption := 'Type: stGetSegment    ';
    stPutSegment:      Caption := 'Type: stPutSegment    ';
    stExecProcedure:   Caption := 'Type: stExecProcedure    ';
    stStartTrans:      Caption := 'Type: stStartTrans    ';
    stCommit:          Caption := 'Type: stCommit    ';
    stRollback:        Caption := 'Type: stRollback    ';
    stSelectForUpdate: Caption := 'Type: stSelectForUpdate    ';
    stSetGenerator:    Caption := 'Type: stSetGenerator    ';
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.btNewSQLClick(Sender: TObject);
begin
  with IB_DataModule.IB_DSQL do begin
    SQLHistoryRef := SQLHistoryCount;
    Prepared := false;
  end;
  meDSQL.Lines.Clear;
  pcDSQL.ActivePage := tsDSQLStatement;
  meDSQL.SetFocus;
  UpdateDSQLButtons;
end;

procedure TfrmIB_Obj_Demo.btSQLPreviousClick(Sender: TObject);
begin
  with IB_DataModule.IB_DSQL do begin
    SQLHistoryRef := SQLHistoryRef - 1;
  end;
  meDSQL.Lines.Text := IB_DataModule.IB_DSQL.SQL.Text;
  pcDSQL.ActivePage := tsDSQLStatement;
  meDSQL.SetFocus;
  UpdateDSQLButtons;
end;

procedure TfrmIB_Obj_Demo.btSQLNextClick(Sender: TObject);
begin
  with IB_DataModule.IB_DSQL do begin
    SQLHistoryRef := SQLHistoryRef + 1;
  end;
  meDSQL.Lines.Text := IB_DataModule.IB_DSQL.SQL.Text;
  pcDSQL.ActivePage := tsDSQLStatement;
  meDSQL.SetFocus;
  UpdateDSQLButtons;
end;

procedure TfrmIB_Obj_Demo.IB_DSQLStatementLinkAfterUnprepare(
  Sender: TIB_StatementLinkBase; IB_Statement: TIB_Statement);
begin
  UpdateDSQLButtons;
end;

procedure TfrmIB_Obj_Demo.IB_DSQLStatementLinkAfterPrepare(
  Sender: TIB_StatementLinkBase; Statement: TIB_Statement);
var
  ii: integer;
begin
  IB_WISQL_INI.EraseSection( 'DSQL' );
  for ii := 0 to meDSQL.Lines.Count - 1 do begin
    IB_WISQL_INI.WriteString( 'DSQL',
                              IntToStr( ii ),
                              meDSQL.Lines[ ii ] );
  end;
end;

procedure TfrmIB_Obj_Demo.UpdateDSQLButtons;
begin
  with IB_DataModule.IB_DSQL do begin
    btSQLPrevious.Enabled := ( SQLHistoryCount > 0 ) and ( SQLHistoryRef > 0 );
    btSQLNext.Enabled     := ( SQLHistoryCount > SQLHistoryRef + 1 );
  end;
end;

{------------------------------------------------------------------------------}
{  Events tab                                                                  } 
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.btRegEventsClick(Sender: TObject);
begin
  with IB_Events do Registered := not Registered;
end;

procedure TfrmIB_Obj_Demo.meEventsChange(Sender: TObject);
begin
  with IB_Events do Registered := false;
end;

procedure TfrmIB_Obj_Demo.IB_EventsAfterRegister(Sender: TObject);
var
  ii: integer;
begin
  IB_WISQL_INI.EraseSection( 'Events' );
  for ii := 0 to meEvents.Lines.Count - 1 do begin
    IB_WISQL_INI.WriteString( 'Events',
                              IntToStr( ii ),
                              meEvents.Lines[ ii ] );
  end;
  btRegEvents.Caption := 'Unregister';
end;

procedure TfrmIB_Obj_Demo.IB_EventsAfterUnregister(Sender: TObject);
begin
  btRegEvents.Caption := 'Register';
end;

procedure TfrmIB_Obj_Demo.IB_EventsBeforeRegister(Sender: TObject);
begin
  IB_Events.Events.Text := meEvents.Lines.Text;
end;

procedure TfrmIB_Obj_Demo.IB_EventsEventAlert(Sender: TObject;
  EventName: string; EventCount: Longint);
begin
  meEventResults.Lines.Insert( 0, EventName + ': ' +
                                  IntToStr( EventCount ) + '  -  ' +
                                  DateTimeToStr( now ) );
end;

procedure TfrmIB_Obj_Demo.btClearResultsClick(Sender: TObject);
begin
  meEventResults.Lines.Clear;
end;

{------------------------------------------------------------------------------}
{   Script tab related stuff                                                   }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.meScriptChange(Sender: TObject);
begin
  if IB_Script.SQL.Count <> 0 then begin
    IB_Script.SQL.Clear;
  end;
end;

procedure TfrmIB_Obj_Demo.btScriptExecuteClick(Sender: TObject);
var
  WasDisabled: boolean;
begin
  if MessageDlg( 'Clear Monitor?',
                 mtConfirmation,
                 mbOkCancel,
                 0 ) = mrOk then begin
    meSQLMonitorOutput.Lines.Clear;
    if not cbMonitorEnabled.Checked then begin
      cbMonitorEnabled.Checked := true;
      WasDisabled := true;
    end else begin
      WasDisabled := false;
    end;
  end;
  try
    try
      IB_Script.Execute;
    except
      ShowMessage( 'Script failed with errors: Check monitor for output.' );
      raise;
    end;
  finally
    if WasDisabled then cbMonitorEnabled.Checked := false;
  end;
  ShowMessage( 'Script completed without exceptions.'#13#10#13#10 +
               'Please check monitor results to verify accuracy.' );
end;

procedure TfrmIB_Obj_Demo.IB_ScriptBeforeExecute(Sender: TIB_Script);
begin
  with IB_Script do begin
    if SQL.Count = 0 then begin
      SQL.Text := meScript.Lines.Text;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.IB_ScriptAfterExecute(Sender: TIB_Script);
//var
//  ii: integer;
begin
//  IB_WISQL_INI.EraseSection( 'Script' );
//  for ii := 0 to meScript.Lines.Count - 1 do begin
//    IB_WISQL_INI.WriteString( 'Script',
//                              IntToStr( ii ),
//                              meScript.Lines[ ii ] );
//  end;
  lbRelations.Items.Clear;
end;

procedure TfrmIB_Obj_Demo.Button2Click(Sender: TObject);
begin
  meScript.Lines.Clear;
end;

procedure TfrmIB_Obj_Demo.Button3Click(Sender: TObject);
begin
  if odOpenScript.Execute then begin
    meScript.Lines.LoadFromFile( odOpenScript.FileName );
  end;
end;

procedure TfrmIB_Obj_Demo.Button4Click(Sender: TObject);
begin
  if sdSaveScript.Execute then begin
    meScript.Lines.SaveToFile( sdSaveScript.FileName );
  end;
end;

{------------------------------------------------------------------------------}
{   Monitor tab related stuff                                                  }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.SQLMonitorMonitorOutputItem(Sender: TObject;
  NewString: string);
begin
  meSQLMonitorOutput.Lines.Add( NewString );
end;

procedure TfrmIB_Obj_Demo.btSQLMonClearClick(Sender: TObject);
begin
  meSQLMonitorOutput.Lines.Clear;
end;

procedure TfrmIB_Obj_Demo.cbMonConnectionClick(Sender: TObject);
  procedure UpdateStatementGroup;
  begin
    with IB_Monitor do begin
      if cbMonStatement.Checked then begin
        IB_StatementGroups := IB_StatementGroups + [ sgAllocate ];
        IB_StatementGroups := IB_StatementGroups + [ sgDescribe ];
        IB_StatementGroups := IB_StatementGroups + [ sgStatementInfo ];
        IB_StatementGroups := IB_StatementGroups + [ sgIBCursor ];
      end else begin
        IB_StatementGroups := IB_StatementGroups - [ sgAllocate ];
        IB_StatementGroups := IB_StatementGroups - [ sgDescribe ];
        IB_StatementGroups := IB_StatementGroups - [ sgStatementInfo ];
        IB_StatementGroups := IB_StatementGroups - [ sgIBCursor ];
      end;
      if cbMonStatement.Checked or cbMonSQL.Checked then begin
        IB_StatementGroups := IB_StatementGroups + [ sgPrepare ];
        IB_StatementGroups := IB_StatementGroups + [ sgExecute ];
        IB_StatementGroups := IB_StatementGroups + [ sgExecuteImmediate ];
      end else begin
        IB_StatementGroups := IB_StatementGroups - [ sgPrepare ];
        IB_StatementGroups := IB_StatementGroups - [ sgExecute ];
        IB_StatementGroups := IB_StatementGroups - [ sgExecuteImmediate ];
      end;
    end;
  end;
begin
  with Sender as TCheckBox, IB_Monitor do begin
    if Sender = cbMonConnection  then begin
      if Checked then begin
        IB_MonitorGroups := IB_MonitorGroups + [ mgConnection ];
      end else begin
        IB_MonitorGroups := IB_MonitorGroups - [ mgConnection ];
      end;
    end else if Sender = cbMonTransaction then begin
      if Checked then begin
        IB_MonitorGroups := IB_MonitorGroups + [ mgTransaction ];
      end else begin
        IB_MonitorGroups := IB_MonitorGroups - [ mgTransaction ];
      end;
    end else if Sender = cbMonStatement then begin
      if Checked or cbMonSQL.Checked then begin
        IB_MonitorGroups := IB_MonitorGroups + [ mgStatement ];
      end else begin
        IB_MonitorGroups := IB_MonitorGroups - [ mgStatement ];
      end;
      UpdateStatementGroup;
    end else if Sender = cbMonSQL then begin
      if Checked or cbMonStatement.Checked then begin
        IB_MonitorGroups := IB_MonitorGroups + [ mgStatement ];
      end else begin
        IB_MonitorGroups := IB_MonitorGroups - [ mgStatement ];
      end;
      UpdateStatementGroup;
    end else if Sender = cbMonRow then begin
      if Checked then begin
        IB_MonitorGroups := IB_MonitorGroups + [ mgRow ];
      end else begin
        IB_MonitorGroups := IB_MonitorGroups - [ mgRow ];
      end;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.btSQLMonSaveClick(Sender: TObject);
begin
  with sdSaveMonitorOutput do begin
    if Execute then begin
      meSQLMonitorOutput.Lines.SaveToFile( FileName );
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.cbMonitorEnabledClick(Sender: TObject);
begin
  IB_Monitor.Enabled := cbMonitorEnabled.Checked;
  cbMonConnection.Enabled := cbMonitorEnabled.Checked;
  cbMonTransaction.Enabled := cbMonitorEnabled.Checked;
  cbMonStatement.Enabled := cbMonitorEnabled.Checked; 
  cbMonSQL.Enabled := cbMonitorEnabled.Checked;
  cbMonRow.Enabled := cbMonitorEnabled.Checked;
  if cbMonitorEnabled.Checked then begin
    meSQLMonitorOutput.Color := clWindow;
    meSQLMonitorOutput.Lines.Add( '----------  ENABLED  ----------' );
  end else begin
    meSQLMonitorOutput.Lines.Add( '----------  DISABLED ----------' );
    meSQLMonitorOutput.Color := clSilver;
  end;
end;

{------------------------------------------------------------------------------}
{   Extract tab related stuff                                                  }
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.tsExtractEnter(Sender: TObject);
begin
  Screen.Cursor := crSQLWait;
  try
    with IB_DataModule, IB_Connection do begin
      RelationsClick( Sender );
      lbProcedures.Items.Text := Info_ProcedureNames.Text;
      lbDomains.Items.Text    := Info_DomainNames.Text;
      if Connected then begin
        crTriggerExtract.Prepared := true;
        crProcExtract.Prepared := true;
      end;
      crTriggerExtract.Active := false;
      crProcExtract.Active := false;
      dsqlProcExtract.Prepared := false;
    end;
  finally
   Screen.Cursor := crDefault;
  end;
end;

procedure TfrmIB_Obj_Demo.RelationsClick(Sender: TObject);
begin
  with IB_DataModule, IB_Connection, crRelations, lbRelations do begin
    Prepared := false;
    if ( Sender = cbSystem ) or
       ( Sender = rbTables ) or
       ( Sender = rbViews  ) or
       ( Items.Count = 0   ) then begin
      SchemaRelationNames( IB_Connection,
                           IB_Transaction,
                           cbSystem.Checked,
                           rbTables.Checked,
                           rbViews.Checked,
                           Items );
    end;
    pcRelExtractChange(Sender);
  end;
end;

procedure TfrmIB_Obj_Demo.lbRelationsClick(Sender: TObject);
begin
  with IB_DataModule, crRelations, lbRelations do begin
    SQLFrom.Text := 'FROM ' + Items[ ItemIndex ];
    Prepared := true;
    pcRelExtractChange(Sender);
    crTriggerExtract.Prepared := true;
    crTriggerExtract.Active := false;
    crProcExtract.Prepared := true;
    crProcExtract.Active := false;
    with crRelDesc, InputRow do begin
      Prepared := true;
      ByAlias[ 'RELATION_NAME' ].AsString := Items[ ItemIndex ];
      First;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.lbRelationsKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin lbRelationsClick(Sender); end;

procedure TfrmIB_Obj_Demo.pcRelExtractChange(Sender: TObject);
begin
  with IB_DataModule, crRelations, lbRelations do begin
    with IB_Connection do begin
      if ItemIndex >= 0 then begin
        if pcRelExtract.ActivePage = tsRelIndicies then begin
          SchemaIndexInfo( IB_Connection,
                           IB_Transaction,
                           meRelIndicies.Lines,
                           Items[ ItemIndex ] );
        end;
        if pcRelExtract.ActivePage = tsRelConstraints then begin
          SchemaConstraintInfo( IB_Connection,
                                IB_Transaction,
                                meRelConstraints.Lines,
                                Items[ ItemIndex ] );
        end;
        if pcRelExtract.ActivePage = tsRelTriggers then begin
          SchemaTriggerInfo( IB_Connection,
                             IB_Transaction,
                             lbRelTriggers.Items,
                             Items[ ItemIndex ] );
        end;
      end else begin
        meRelIndicies.Lines.Clear;
        meRelConstraints.Lines.Clear;
        lbRelTriggers.Items.Clear;
        lbRelTriggers.ItemIndex := -1;
      end;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.cbDomainInfoClick(Sender: TObject);
begin
  sgExtractColumns.DomainInfo := cbDomainInfo.Checked;
end;

procedure TfrmIB_Obj_Demo.pnSizerRelationsMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Sender = pnSizerRelations then begin
    lbRelations.Width := lbRelations.Width + X;
  end else if Sender = pnSizerRelTriggers then begin
    lbRelTriggers.Width := lbRelTriggers.Width + X;
  end else if Sender = pnSizerProcedures then begin
    lbProcedures.Width := lbProcedures.Width + X;
  end else if Sender = pnSizerDomains then begin
    lbDomains.Width := lbDomains.Width + X;
  end;
  PanelSizing := false;
end;

procedure TfrmIB_Obj_Demo.pnSizerRelationsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PanelSizing := true;
end;

procedure TfrmIB_Obj_Demo.pnSizerRelationsMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if PanelSizing then begin
    if Sender = pnSizerRelations then begin
      lbRelations.Width := lbRelations.Width + X;
    end else if Sender = pnSizerRelTriggers then begin
      lbRelTriggers.Width := lbRelTriggers.Width + X;
    end else if Sender = pnSizerProcedures then begin
      lbProcedures.Width := lbProcedures.Width + X;
    end else if Sender = pnSizerDomains then begin
      lbDomains.Width := lbDomains.Width + X;
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.lbTriggersClick(Sender: TObject);
begin
  if lbRelTriggers.Items.Count > 0 then begin
    with IB_DataModule, crTriggerExtract, lbRelations do begin
      Prepared := true;
      Active := false;
      InputRow.ByAlias[ 'TRIGGER_NAME' ].AsString :=
        lbRelTriggers.Items[ lbRelTriggers.ItemIndex ];
      InputRow.ByAlias[ 'RELATION_NAME' ].AsString :=
        lbRelations.Items[ lbRelations.ItemIndex ];
      First;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.lbProceduresClick(Sender: TObject);
var
  ExecProcSQL: string;
begin
  with IB_DataModule, crProcExtract do begin
    with crProcParams do begin
      Prepared := true;
      Active := false;
    end;
    Prepared := true;
    Active := false;
    InputRow.ByAlias[ 'PROCEDURE_NAME' ].AsString :=
      lbProcedures.Items[ lbProcedures.ItemIndex ];
    First;
    if EOF then begin
      dsqlProcExtract.Prepared := false;
    end else begin
      ExecProcSQL := 'EXECUTE PROCEDURE ' +
                     lbProcedures.Items[ lbProcedures.ItemIndex ];
      with crProcParams do begin
        First;
        while not EOF do begin
          ExecProcSQL := ExecProcSQL + '?' +
                       OutputRow.ByAlias[ 'RDB$PARAMETER_NAME' ].AsString;
          Next;
          if not EOF then begin
            ExecProcSQL := ExecProcSQL + ', ';
            dsqlProcExtract.SQL.Add( ', ' );
          end;
        end;
      end;
      dsqlProcExtract.SQL.Text := ExecProcSQL;
      dsqlProcExtract.Prepare;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.lbProceduresKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  lbProceduresClick( Sender );
end;

procedure TfrmIB_Obj_Demo.meTriggersKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  lbTriggersClick( Sender );
end;

procedure TfrmIB_Obj_Demo.btEditTriggerClick(Sender: TObject);
var
  ProcBody: TStrings;
begin
  with IB_DataModule, crTriggerExtract, OutputRow do begin
    if Active and not EOF then begin
      PageControl.ActivePage := tsDSQL;
      btNewSQL.Click;

      meDSQL.Lines.Clear;
      with ByAlias[ 'RDB$TRIGGER_SOURCE' ] as TIB_Column_Blob do begin
        AsStream.Position := 0;
        meDSQL.Lines.LoadFromStream( AsStream );
        meDSQL.Lines.Text :=  'ALTER TRIGGER ' +
                              ByAlias[ 'RDB$TRIGGER_NAME' ].AsString + #13#10 +
                              meDSQL.Lines.Text;
      end;

    end else begin
      ShowMessage( 'Invalid trigger source.' );
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.btEditProcedureClick(Sender: TObject);
var
  ProcBody: TStrings;
begin
  with IB_DataModule, crProcExtract, OutputRow do begin
    if Active and not EOF then begin
      PageControl.ActivePage := tsDSQL;
      btNewSQL.Click;
      ProcBody := TStringList.Create;
      try
        with ByAlias['RDB$PROCEDURE_SOURCE'] as TIB_Column_Blob do begin
          AsStream.Position := 0;
          ProcBody.LoadFromStream( AsStream );
        end;
        meDSQL.Lines.Text :=
          IB_Parse.GetStoredProcedureSource(
            true,  // Is an ALTER PROCEDURE statement
            ByAlias[ 'RDB$PROCEDURE_NAME' ].AsString,
            dsqlProcExtract,
            ProcBody.Text );
      finally
        ProcBody.Free;
      end;
    end else begin
      ShowMessage( 'Invalid procedure source.' );
    end;
  end;
end;

{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.IB_ConnectionLinkAfterExecDDL(
  Sender: TIB_ConnectionLink; IB_Connection: TIB_Connection);
begin
  { Need to invalidate any flags that are caching metadata information. }
  lbRelations.Items.Clear;
end;

{------------------------------------------------------------------------------}
{ Scrolling DataSet Test                                                       } 
{------------------------------------------------------------------------------}

procedure TfrmIB_Obj_Demo.IB_DataSetBar1BeforeAction(Sender: TObject);
begin
  with IB_BDataSet1 do begin
    if not prepared then begin
      SQL.Text := Memo1.Text;
      Prepare;
      Label14.Caption := OutputRow[ 0 ].DisplayName;
      IB_Edit4.DataColumnName := OutputRow[ 0 ].AliasName;
    end;
  end;
end;

procedure TfrmIB_Obj_Demo.Memo1Change(Sender: TObject);
begin
  IB_BDataSet1.Prepared := false;
  Label14.Caption := 'Column Label';
end;

end.


