{ copyright:
   University Hospital Vrije Universiteit, Johan Colijn
   De Boelelaan 1117
   PO Box  7057
   1007 MB Amsterdam
   The Netherlands
   email: j.colijn@azvu.nl

   This product is provided as-is, with no express or implied warranties of
   any kind. Use this product at your own risk.

   It is free for you to use, distribute, modify, etc.... in any way
   you see fit, with the following restrictions:
   1. It may not be sold or added to a commercial product
   2. I would like to receive improvements as well as in the coding (I
      know its poor) as in English (I know its poor)

   Furthermore comments and suggestions are welcome.
}

library UDFLoad;

// User defined function for dataload

uses
  SysUtils, IBLoad, Windows;

var
  iBuffer: Integer;
  pSaveExit: Pointer;


function IBDataLoad(DBName: PChar; Tablename: PChar; Filename: PChar;
          Username: PChar; Password: PChar; Logfile: PChar;
          maxrec: PInteger; append: PInteger; debug: PInteger): PInteger; cdecl; export;

var
  bInsert: boolean;
  bDebug:  boolean;
  bSilent: boolean;
  bLog:    boolean;

begin
  bSilent := true; // no output
  bLog := (StrLen(Logfile) > 0); // logfile? then log switch on
  bDebug := (debug^ <> 0);
  bInsert := (append^ = 0);

  iBuffer := IBLoadProc(StrPas(DBName), StrPas(Tablename), StrPas(Filename),
              StrPas(Username), StrPas(Password), StrPas(Logfile),
              maxrec^, bInsert, bDebug, bSilent, bLog);
  Result := @iBuffer;
end;

procedure LibExit;
begin
  { Library exit code }
  ExitProc := pSaveExit;        { Restore exit procedure chain }
end;

exports
  IBDataLoad;

begin
  { Library initialization code }
  pSaveExit := ExitProc;        { Save exit procedure chain }
  ExitProc := @LibExit;         { Install LibExit exit procedure }
end.
