{ copyright:
   University Hospital Vrije Universiteit, Johan Colijn
   De Boelelaan 1117
   PO Box  7057
   1007 MB Amsterdam
   The Netherlands
   email: j.colijn@azvu.nl

   This product is provided as-is, with no express or implied warranties of
   any kind. Use this product at your own risk.

   It is free for you to use, distribute, modify, etc.... in any way
   you see fit, with the following restrictions:
   1. It may not be sold or added to a commercial product
   2. I would like to receive improvements as well as in the coding (I
      know its poor) as in English (I know its poor)

   Furthermore comments and suggestions are welcome.
}

program DBLoad;

uses
  SysUtils, IBLoad;

const
  version = '1.00';
{$R *.RES}
var
  sDBName:    string;
  sUsername:  string;
  sPassword:  string;
  sTablename: string;
  sFilename:  string;
  sLogfile:   string;

  debug:      boolean;
  insert:     boolean;
  silent:     boolean;
  log:        boolean;

  maxrec:     longint;

  i:          smallint;

begin
  debug  := false;
  silent := false;
  insert := true;
  log    := false;
  maxrec := 0;

  if paramCount < 5 then begin
    writeln('DBLoad version ',version, ' (IBLoad unit: ', ibload_version, ')');
    writeln('DBLoad transfers an ascii file into a InterBase table.');
    writeln('The table has to have the same layout as the ascii file, including');
    writeln('carriage return(s) (= just as a external file).');
    writeln('The only data type allowed is CHAR(nn).');
    writeln;writeln('Usage: ');
    writeln('DBLoad <database> <tabel> <file> <username> <password>');
    writeln('  database:   path to the database');
    writeln('  tabel:      table to be loaded');
    writeln('  file:       filename to transfer into the table');
    writeln('  username:   username');
    writeln('  password:   password');
    writeln;writeln('options:');
    writeln('  <n>:        number of records to be loaded (0=all)');
    writeln('  /append:    append records (default the table is emptied)');
    writeln('  /debug:     extra debug information');
    writeln('  /silent:    no output (overrules /debug)');
    writeln('  /log=<file>:logfile');
    halt;
  end;

  sDBName    := ParamStr(1);
  sTablename := ParamStr(2);
  sFilename  := ParamStr(3);
  sUsername  := ParamStr(4);
  sPassword  := ParamStr(5);
  sLogfile   := '';
  
  for i := 6 to paramcount do begin
    if UpperCase(ParamStr(i)) = '/APPEND' then
      Insert := false
    else if UpperCase(ParamStr(i)) = '/DEBUG' then
      debug  := true
    else if UpperCase(ParamStr(i)) = '/SILENT' then
      silent := true
    else if Pos('/LOG=',UpperCase(ParamStr(i))) = 1 then begin
      log := true;
      sLogfile := Copy(ParamStr(i), 6, Length(ParamStr(i)) - 4);
    end
    else
      try
        maxrec := StrToInt(ParamStr(i));
      except
        on E:EConvertError do
          writeln(E.message)
      end;
    end;

  IBLoadProc(sDBName, sTablename, sFilename, sUsername, sPassword, sLogfile,
             maxrec, insert, debug, silent, log);

end.
