{$R-} {$D-} {$S-}

unit HwPort95;

interface

uses SysUtils, Windows,Messages,Classes, Forms;

type THWPriority = (tpIdle,tpLowest,tpLower,tpNormal,tpHigher,
                                      tpHighest,tpTimeCritical);
type
  TVicHW_95 = class(TComponent)
  private
    fCurrDay        : dWord;
    fWinHandle      : hWnd;
    fIsIRQSet       : Boolean;
    fMasked         : Boolean;
    fOpenDrive      : Boolean;
    hVxD            : THandle;
    fOnHwInterrupt  : TNotifyEvent;
    fIRQNumber      : Byte;
    fThreadId       : THandle;
    fThreadHandle   : THandle;
    fHWCritSect_IO  : TRTLCriticalSection;
    fHWCritSect_IRQ : TRTLCriticalSection;
    fPrty           : THWPriority;
    procedure   SetActiveDriver(flag:Boolean);
    function    ReadPort  (nPort:Word):Byte;
    procedure   WritePort (nPort:Word; pval:Byte);
    function    ReadPortW (nPort:Word):Word;
    procedure   WritePortW(nPort:Word; pval:Word);
    function    ReadPortL (nPort:Word):dWord;
    procedure   WritePortL(nPort:Word; pval:dWord);
    procedure   SetPriority(Value: THWPriority);
    function    SetPointerToPhysicalAddress(PhAddr:dWord; Size:dWord):Pointer;

  public

    constructor Create(Owner:TComponent); override;
    destructor  Destroy; override;
    procedure   OpenDriver;
    procedure   CloseDriver;

    function    GetInterruptCounter:dWord;
    procedure   SetIRQ;
    procedure   DestroyIRQ;
    procedure   MaskInterrupt;
    procedure   UnmaskInterrupt;
    
    procedure   ReadPortArray(BasePort,NumPorts:Word; pValues:Pointer);
    procedure   WritePortArray(BasePort,NumPorts:Word; pValues:Pointer);
    procedure   ReadPortRecord(NumPorts:Word; pPorts,pValues:Pointer);
    procedure   WritePortRecord(NumPorts:Word; pPorts,pValues:Pointer);

    property    Port[Index:Word]  : Byte  read ReadPort  write WritePort;
    property    PortW[Index:Word] : Word  read ReadPortW write WritePortW;
    property    PortL[Index:Word] : dWord read ReadPortL write WritePortL;

    property    PhysMemPtr[PhysAddr,SizeOfByte:dWord]:Pointer
                                              read SetPointerToPhysicalAddress;

    property    IsIRQSet : Boolean read fIsIRQSet;
    property    Masked   : Boolean read fMasked;

  published

    property ActiveHW : Boolean read fOpenDrive write SetActiveDriver;
    property OnHwInterrupt :TNotifyEvent read fOnHwInterrupt write fOnHwInterrupt;
    property IRQNumber : Byte read fIRQNumber write fIRQNumber;
    property Priority: THWPriority read    fPrty
                                   write   SetPriority
                                   default tpNormal;

  end;

