{========================================================================}
{=                      Copyright (c) 1998 MiSoftware                   =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  MiSoftware                  = Tel.: +61 417 572 065                 =}
{========================================================================}
{=  Actual versions on http://www.misoftware.com/delphi/                =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from MiSoftware.                         =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 1999/01/27 - 11:12:00 AM $                                     =}
{========================================================================}
unit HQClearAll;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, StdCtrls, Forms;

type
  THQClearAll = class(TComponent)
  private
    FCText    : String;
    FCOptions : Boolean;
    procedure SetOptions(Value: Boolean);
    procedure SetText(Value: String);
    function GetForm: TForm;
  public
    { Public declarations }
    constructor Create(aOwner : TComponent); override;
    procedure Start;
  published
    { Published declarations }
    property ChangeText : string read FCText write SetText;
    property Change     : boolean read FCOptions write SetOptions;
  end;

{$R HQClearAll.RES}

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('DelphiHQ', [THQClearAll]);
end;

constructor THQClearAll.Create(aOwner : TComponent);
begin
  inherited create(aOwner);
  FCOptions := False;
end;

procedure THQClearAll.SetText(Value: String);
begin
  FCText := Value;
end;

procedure THQClearAll.SetOptions(Value: Boolean);
begin
  FCOptions := Value;
end;

function THQClearAll.GetForm: TForm;
begin
  if Owner is TCustomForm then Result := TForm(Owner as TCustomForm)
  else Result := nil;
end;

procedure THQClearAll.Start;
var
  i : integer;
begin
  for i := 0 to GetForm.ComponentCount-1 do
    begin
      if (GetForm.Components[i] is TEdit) then
      begin
        if (FCOptions = True) then
           (GetForm.Components[i] as TEdit).Text := FCText 
        else
           (GetForm.Components[i] as TEdit).Text := '';
      end;
  end;
end;

end.
