unit HHComp;
{This is freeware Delphi unit which allow to use HTMLHelp instead of usual Windows Help 
 intercepting OnHelp event. With this component you can still use HelpContext properties
 of the components but THHComp redirect help request to the HTMLHelp API.
 Only one component per programm can be used. 
 Copyright (c) 2003 Ainars Skangals
 Version 1.20
 This component is provided "as is" without warranty of any kind, 
 either expressed or implied.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  THtmlHelp=Function(hwndCaller : HWND; pszFile: PChar; uCommand : Integer;
            dwData : DWORD) : HWND; stdcall;

  TTCardEvent=procedure(wParam: WPARAM; lParam: LPARAM) of object;


  THHComp = class(TComponent)
  private
    { Private declarations }
    FHelp,
    FHelp1:String;
    HHHandle:THandle;
    HtmlHelp:THtmlHelp;
    FOnTCardEvent: TTCardEvent;
    FOldEvent: TMessageEvent;
  protected
    { Protected declarations }
    procedure Loaded; override;
    procedure CatchCardMessage(var Msg: TMsg; var Handled: Boolean);
  public
    { Public declarations }
    Function ShowContents:Integer;
    Function ShowIndex:Integer;
    Function ShowHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
    Destructor Destroy; override;
  published
    { Published declarations }
    Property HelpFile:String read FHelp write FHelp;
    Property OnTCardMessage:TTcardEvent Read FOnTCardEvent write FOnTCardEvent;
  end;

procedure Register;

implementation
const
  HH_DISPLAY_TOPIC  = $0000;
  HH_DISPLAY_TOC    = $0001;
  HH_DISPLAY_INDEX  = $0002;
  HH_HELP_CONTEXT   = $000F;
  HH_CLOSE_ALL      = $0012;

function THHComp.ShowContents:Integer;
begin
  if HHHandle<>0 then
   Result:=HtmlHelp(Application.Handle,PChar(FHelp1),HH_DISPLAY_TOC,0);
end;

function THHComp.ShowIndex:Integer;
begin
  if HHHandle<>0 then
   Result:=HtmlHelp(Application.Handle,PChar(FHelp),HH_DISPLAY_INDEX,0);
end;

function THHComp.ShowHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
begin
  Result:=False;
  if FHelp<>'' then
   if HHHandle<>0 then
    HtmlHelp(Application.Handle,PChar(FHelp1),HH_HELP_CONTEXT,Data);
  CallHelp:=False;
  Result:=true;
end;

procedure THHComp.Loaded;
begin
Inherited;
HHHandle:=0;
// dynamic library loading to avoid exceptions on program start
HHHandle:=LoadLibrary('HHCTRL.OCX');
  if HHHandle<>0 then
     HtmlHelp := GetProcAddress(HHHandle, 'HtmlHelpA');
// Here the help system is switched to HTMLHelp
Application.OnHelp:=ShowHelp;
if Assigned(Application.OnMessage) then
 FOldEvent:=Application.OnMessage else FOldEvent:=nil; 
Application.OnMessage:=CatchCardMessage;
FHelp1:=ExtractFilePath(Application.exename)+FHelp;
end;

procedure THHComp.CatchCardMessage(var Msg: TMsg; var Handled: Boolean);
begin
Handled:=false;
   if Msg.Message=WM_TCARD then begin
    Handled:=true;
    if assigned(FOnTCardEvent) then FOnTCardEvent(Msg.wParam,Msg.lParam);
    end else
    if assigned(FOldEvent) then FOldEvent(Msg,Handled);
end;

destructor THHComp.Destroy;
begin
 // Automatically close help window if any
 HtmlHelp(0,PChar(FHelp1),HH_CLOSE_ALL,0);
 if HHHandle<>0 then begin
  HtmlHelp(0,PChar(FHelp1),HH_CLOSE_ALL,0);
  FreeLibrary(HHHandle);
  end;
 inherited;
end;

procedure Register;
begin
  RegisterComponents('Install', [THHComp]);
end;

end.
